/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import javax.naming.Binding;
import javax.naming.Referenceable;
import oracle.javatools.db.Database;

public final class ConnectionsEvent {
    private final String m_name;
    private final Referenceable m_ref;
    private final String m_originalName;
    private final Database m_database;

    ConnectionsEvent(Binding binding) {
        this(binding.getName(), (Referenceable)binding.getObject());
    }

    ConnectionsEvent(Binding oldBinding, Binding newBinding) {
        this(oldBinding.getName(), newBinding.getName(), (Referenceable)newBinding.getObject());
    }

    ConnectionsEvent(String name, Referenceable ref) {
        this(null, name, ref, null);
    }

    ConnectionsEvent(Database db) {
        this(null, db.getConnectionName(), null, db);
    }

    ConnectionsEvent(String oldName, String newName, Referenceable newRef) {
        this(oldName, newName, newRef, null);
    }

    private ConnectionsEvent(String oldName, String newName, Referenceable newRef, Database db) {
        this.m_name = newName;
        this.m_originalName = oldName;
        this.m_ref = newRef;
        this.m_database = db;
    }

    public Referenceable getReferenceable() {
        return this.m_ref;
    }

    public String getName() {
        return this.m_name;
    }

    public String getOriginalName() {
        return this.m_originalName;
    }

    public Database getDatabase() {
        return this.m_database;
    }
}

