/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.util.Comparator;
import oracle.mof.xmi.XMIException;
import oracle.mof.xmi.XMIPropertyType;
import oracle.mof.xmi.XMIType;

public interface XMIProperty {
    public static final PropertyComparator COMPARATOR = new PropertyComparator();

    public XMIType getOwningType();

    public String getName();

    public XMIType getType();

    public XMIPropertyType getPropertyType();

    public boolean isMultivalued();

    public void addValue(Object var1, Object var2) throws XMIException;

    public Object getValue(Object var1) throws XMIException;

    public static class PropertyComparator
    implements Comparator<XMIProperty> {
        @Override
        public int compare(XMIProperty p1, XMIProperty p2) {
            XMIPropertyType pt1 = p1.getPropertyType();
            XMIPropertyType pt2 = p2.getPropertyType();
            boolean mv1 = p1.isMultivalued();
            boolean mv2 = p2.isMultivalued();
            int result = pt1.ordinal() + (pt1 == XMIPropertyType.COMPOSITE || mv1 ? 3 : 0) - pt2.ordinal() - (pt2 == XMIPropertyType.COMPOSITE || mv2 ? 3 : 0);
            if (result != 0) {
                return result;
            }
            return p1.getName().compareTo(p2.getName());
        }
    }
}

