/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import oracle.mof.xmi.ContractUtils;
import oracle.mof.xmi.XMIException;
import oracle.mof.xmi.XMIExportBuilder;
import oracle.mof.xmi.XMIMetaModelProvider;
import oracle.mof.xmi.XMIProperty;
import oracle.mof.xmi.XMIPropertyType;
import oracle.mof.xmi.XMIType;

public class XMIExporter {
    private final PropertyExporter PROPERTY_EXPORTER = new PropertyExporter();
    private final PropertyExporter REFERENCE_EXPORTER = new ReferenceExporter();
    private final PropertyExporter COMPOSITE_EXPORTER = new CompositeExporter();
    private XMIExportBuilder m_builder;
    private XMIMetaModelProvider m_provider;
    private Object[] m_instances;

    public XMIExporter(XMIExportBuilder builder, XMIMetaModelProvider provider, Object ... instances) {
        ContractUtils.checkNull(builder, "Missing builder");
        ContractUtils.checkNull(provider, "Missing provider");
        ContractUtils.checkNull(instances, "Missing instances");
        this.m_builder = builder;
        this.m_provider = provider;
        this.m_instances = instances;
    }

    /*
     * WARNING - void declaration
     */
    public void export() throws XMIException {
        try {
            this.m_builder.startXMI();
        }
        catch (IOException ioe) {
            throw new XMIException(null, ioe, 2);
        }
        try {
            for (Object object : this.m_instances) {
                void var4_7;
                void var4_10;
                if (object instanceof Object[]) {
                    List<Object> list = Arrays.asList((Object[])object);
                }
                if (var4_10 instanceof Iterable) {
                    Iterator iterator = ((Iterable)var4_10).iterator();
                }
                if (var4_7 instanceof Iterator) {
                    Iterator iterator = (Iterator)var4_7;
                    while (iterator.hasNext()) {
                        this.exportInstance(iterator.next());
                    }
                    continue;
                }
                this.exportInstance(var4_7);
            }
        }
        catch (Exception e) {
            this.m_builder.abort();
            if (e instanceof XMIException) {
                throw (XMIException)e;
            }
            throw new XMIException(null, e, 2);
        }
        try {
            this.m_builder.endXMI();
        }
        catch (IOException ioe) {
            throw new XMIException(null, ioe, 2);
        }
    }

    private void exportInstance(Object instance) throws XMIException {
        if (instance == null) {
            throw new IllegalStateException("Missing instance");
        }
        XMIType t = this.findType(instance);
        if (t == null) {
            throw new IllegalStateException("Missing type");
        }
        this.m_builder.startInstance(t);
        Collection<? extends XMIProperty> properties = t.getProperties();
        if (properties != null) {
            IdentityHashMap<Object, Object> composites = new IdentityHashMap<Object, Object>();
            for (XMIProperty xMIProperty : properties) {
                Iterator value = xMIProperty.getValue(instance);
                if (value == null) continue;
                XMIPropertyType pt = xMIProperty.getPropertyType();
                PropertyExporter pe = this.PROPERTY_EXPORTER;
                if (pt == XMIPropertyType.REFERENCE) {
                    pe = this.REFERENCE_EXPORTER;
                } else if (pt == XMIPropertyType.COMPOSITE) {
                    pe = this.COMPOSITE_EXPORTER;
                }
                boolean multivalued = xMIProperty.isMultivalued();
                if (multivalued) {
                    if (value instanceof Iterable) {
                        value = ((Iterable)((Object)value)).iterator();
                    }
                    if (value instanceof Iterator) {
                        Iterator values = value;
                        if (!values.hasNext()) continue;
                        this.m_builder.startProperty(xMIProperty);
                        while (values.hasNext()) {
                            pe.export(instance, composites, values.next());
                        }
                        this.m_builder.endProperty();
                        continue;
                    }
                    int length = Array.getLength(value);
                    if (length <= 0) continue;
                    this.m_builder.startProperty(xMIProperty);
                    for (int i = 0; i < length; ++i) {
                        pe.export(instance, composites, Array.get(value, i));
                    }
                    this.m_builder.endProperty();
                    continue;
                }
                this.m_builder.startProperty(xMIProperty);
                pe.export(instance, composites, value);
                this.m_builder.endProperty();
            }
        }
        this.m_builder.endInstance();
    }

    private XMIType findType(Object instance) throws XMIException {
        return this.m_provider.getTypeForInstance(instance);
    }

    private class CompositeExporter
    extends PropertyExporter {
        private CompositeExporter() {
        }

        @Override
        public void export(Object context, IdentityHashMap<Object, Object> composites, Object value) throws XMIException {
            if (value instanceof String || composites.containsKey(value)) {
                XMIExporter.this.REFERENCE_EXPORTER.export(context, composites, value);
            } else {
                composites.put(value, value);
                XMIExporter.this.exportInstance(value);
            }
        }
    }

    private class ReferenceExporter
    extends PropertyExporter {
        private ReferenceExporter() {
        }

        @Override
        public void export(Object context, IdentityHashMap<Object, Object> composites, Object value) throws XMIException {
            String ref = value instanceof String ? (String)value : XMIExporter.this.findType(value).getId(context, value);
            XMIExporter.this.m_builder.outputValue(ref);
        }
    }

    private class PropertyExporter {
        private PropertyExporter() {
        }

        public void export(Object context, IdentityHashMap<Object, Object> composites, Object value) throws XMIException {
            XMIExporter.this.m_builder.outputValue(value.toString());
        }
    }
}

