/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.mof.xmi.ContractUtils;
import oracle.mof.xmi.ObjectResolver;
import oracle.mof.xmi.ResolutionResult;
import oracle.mof.xmi.ResourcesSingleton;
import oracle.mof.xmi.XMIDocumentSet;
import oracle.mof.xmi.XMIException;
import oracle.mof.xmi.XMIProperty;
import oracle.mof.xmi.XMIReader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMIDocument {
    private ObjectResolver m_objectResolver = new XMIDocumentResolver();
    private ResolutionStrategy m_resolutionStrategy = new ResolutionStrategy();
    private ErrorHandler m_errorHandler;
    private boolean m_logUnsupported;
    private String m_publicId;
    private String m_systemId;
    private URI m_uri;
    private ArrayList<String> m_uris = new ArrayList();
    private XMIDocumentSet m_set;
    private String m_xmiVersion;
    private HashMap<String, Object> m_instancesById = new HashMap();
    private HashMap<String, Object> m_instancesByUUID = new HashMap();
    private ArrayList<XMIReference> m_references = new ArrayList();
    private ArrayList m_rootInstances = new ArrayList();
    private String m_name;
    private String m_version;

    protected XMIDocument(XMIReader reader, InputSource inputSource) {
        ContractUtils.checkNull(reader, "Reader must not be null");
        ContractUtils.checkNull(inputSource, "Input source must not be null");
        this.m_errorHandler = reader.getErrorHandler();
        this.m_logUnsupported = reader.logUnsupported();
        this.m_publicId = inputSource.getPublicId();
        this.m_systemId = inputSource.getSystemId();
        if (this.m_systemId != null) {
            try {
                URI uri = XMIDocument.checkURI(this.m_systemId);
                if (!uri.isOpaque()) {
                    this.m_uri = uri;
                }
                this.m_uris.add(uri.toString());
            }
            catch (XMIException e) {
                this.report(e, -1, -1);
            }
        }
    }

    public ObjectResolver getObjectResolver() {
        return this.m_objectResolver;
    }

    void setXMIVersion(String xmiVersion) {
        ContractUtils.checkNull(xmiVersion, "XMI version must not be null");
        this.m_xmiVersion = xmiVersion;
    }

    public String getXMIVersion() {
        return this.m_xmiVersion;
    }

    void setDocumentSet(XMIDocumentSet set) {
        ContractUtils.checkNull(set, "Set must not be null");
        if (this.m_set != null) {
            throw new IllegalStateException("Already member of a set");
        }
        set.addResolver(this.m_objectResolver);
        for (int i = this.m_uris.size() - 1; i >= 0; --i) {
            set.addMapping(this.m_uris.get(i), this.m_objectResolver);
        }
        this.m_set = set;
        this.m_resolutionStrategy = new ResolutionFromSetStrategy();
    }

    public void addURI(String uri) {
        ContractUtils.checkNull(uri, "URI must not be null");
        try {
            uri = XMIDocument.checkURI(uri).toString();
        }
        catch (XMIException e) {
            this.report(e, -1, -1);
            return;
        }
        if (this.m_set != null) {
            this.m_set.addMapping(uri, this.m_objectResolver);
        } else {
            this.m_uris.add(uri);
        }
    }

    void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    void setVersion(String version) {
        this.m_version = version;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void resolveReferences() {
        int size = this.m_references.size();
        for (int i = 0; i < size; ++i) {
            XMIReference ref = this.m_references.get(i);
            ref.resolve();
        }
    }

    void addIdref(Locator locator, Object instance, XMIProperty property, String idref) {
        this.m_references.add(new XMIIdref(locator, instance, property, idref));
    }

    void addHref(Locator locator, Object instance, XMIProperty property, String href) {
        this.m_references.add(new XMIHref(locator, instance, property, href));
    }

    void addIdrefProxy(Locator locator, String xmiId, String idref) throws XMIException {
        this.addInstanceById(xmiId, new XMIIdref(locator, null, null, idref));
    }

    void addHrefProxy(Locator locator, String xmiId, String href) throws XMIException {
        this.addInstanceById(xmiId, new XMIHref(locator, null, null, href));
    }

    void addIgnoredInstanceById(Locator locator, String id) {
        this.m_instancesById.put(id, (Object)ResolutionResult.IGNORED);
    }

    void addIgnoredInstanceByUUID(Locator locator, String uuid) {
        this.m_instancesByUUID.put(uuid, (Object)ResolutionResult.IGNORED);
    }

    void addInstanceById(String id, Object instance) throws XMIException {
        this.addInstanceInternal(id, instance, this.m_instancesById);
    }

    void addInstanceByUUID(String uuid, Object instance) throws XMIException {
        this.addInstanceInternal(uuid, instance, this.m_instancesByUUID);
    }

    private void addInstanceInternal(String identifier, Object instance, HashMap<String, Object> instances) throws XMIException {
        if (instances.put(identifier, instance) != null) {
            throw new XMIException(ResourcesSingleton.getPicker().getString("DuplicateId.text", (Object)identifier), null, 1);
        }
    }

    public Object getInstanceById(String id) {
        return ResolutionResult.getRealInstance(this.getInstanceByIdInternal(id));
    }

    Object getInstanceByIdInternal(String id) {
        ContractUtils.checkNull(id, "Missing id");
        Object instance = this.m_instancesById.get(id);
        if (instance instanceof XMIIdref) {
            instance = ((XMIIdref)instance).resolve();
            this.m_instancesById.put(id, instance);
        }
        return instance == null ? ResolutionResult.NOT_FOUND : instance;
    }

    public Object getInstanceByUUID(String uuid) {
        return ResolutionResult.getRealInstance(this.getInstanceByUUIDInternal(uuid));
    }

    Object getInstanceByUUIDInternal(String uuid) {
        ContractUtils.checkNull(uuid, "Missing uuid");
        Object instance = this.m_instancesByUUID.get(uuid);
        return instance == null ? ResolutionResult.NOT_FOUND : instance;
    }

    public Object[] getRootInstances() {
        return this.m_rootInstances.toArray();
    }

    void addInstance(Locator locator, Object owner, XMIProperty property, Object composite) {
        if (owner == null) {
            this.m_rootInstances.add(composite);
        } else {
            this.m_references.add(new XMICompositeReference(locator, owner, property, composite));
        }
    }

    protected Object resolveId(XMIProperty property, String idref) {
        return this.getInstanceByIdInternal(idref);
    }

    protected Object resolveLocalFragment(XMIProperty property, String documentURI, String fragment) {
        if (this.m_uris.contains(documentURI)) {
            return this.resolveId(property, fragment);
        }
        return ResolutionResult.NOT_FOUND;
    }

    protected Object resolveFragmentFromSet(XMIProperty property, String documentURI, String fragment) {
        return this.m_set.getInstanceByFragment(documentURI, fragment);
    }

    protected Object resolveLocalUUID(XMIProperty property, String ref) {
        return this.getInstanceByUUIDInternal(ref);
    }

    protected Object resolveUUIDFromSet(XMIProperty property, String ref) {
        return this.m_set.getInstanceByUUID(ref);
    }

    protected final void report(XMIException e, int lineNumber, int columnNumber) {
        try {
            e.report(this.m_publicId, this.m_systemId, lineNumber, columnNumber, this.m_errorHandler);
        }
        catch (SAXException saxe) {
            this.logReportingFellOver(saxe, lineNumber, columnNumber);
        }
    }

    private void logReportingFellOver(SAXException e, int lineNumber, int columnNumber) {
        try {
            this.m_errorHandler.fatalError(this.createException(ResourcesSingleton.getPicker().getString("ErrorReportingFailed.text"), e, lineNumber, columnNumber));
        }
        catch (SAXException e2) {
            e.printStackTrace();
            e2.printStackTrace();
        }
    }

    private SAXParseException createException(String message, Exception e, int lineNumber, int columnNumber) {
        return new SAXParseException(message, this.m_publicId, this.m_systemId, lineNumber, columnNumber, e);
    }

    private static URI checkURI(String str) throws XMIException {
        try {
            URI uri = new URI(str.startsWith("jar:") ? str.substring(4) : str).normalize();
            if (!uri.isAbsolute()) {
                throw new XMIException(ResourcesSingleton.getPicker().getString("AbsoluteURI.text", (Object)str), null, 1);
            }
            return uri;
        }
        catch (URISyntaxException use) {
            throw new XMIException(ResourcesSingleton.getPicker().getString("InvalidURI.text", (Object)str), use, 1);
        }
    }

    private final class XMIDocumentResolver
    implements ObjectResolver {
        private XMIDocumentResolver() {
        }

        @Override
        public Object resolve(String namespace, String fragment) {
            return XMIDocument.this.getInstanceByIdInternal(fragment);
        }

        @Override
        public Object resolve(String uri) {
            return XMIDocument.this.getInstanceByUUIDInternal(uri);
        }
    }

    private class ResolutionFromSetStrategy
    extends ResolutionStrategy {
        private ResolutionFromSetStrategy() {
        }

        @Override
        protected Object resolveFragment(XMIProperty property, String documentURI, String fragment) {
            return XMIDocument.this.resolveFragmentFromSet(property, documentURI, fragment);
        }

        @Override
        protected Object resolveUUID(XMIProperty property, String ref) {
            return XMIDocument.this.resolveUUIDFromSet(property, ref);
        }
    }

    private class ResolutionStrategy {
        private ResolutionStrategy() {
        }

        protected Object resolveFragment(XMIProperty property, String documentURI, String fragment) {
            return XMIDocument.this.resolveLocalFragment(property, documentURI, fragment);
        }

        protected Object resolveUUID(XMIProperty property, String ref) {
            return XMIDocument.this.resolveLocalUUID(property, ref);
        }
    }

    private class XMIHref
    extends XMIIdref {
        public XMIHref(Locator locator, Object instance, XMIProperty property, String ref) {
            super(locator, instance, property, ref);
        }

        @Override
        protected Object resolveImpl() {
            int index = this.m_ref.indexOf(35);
            if (index == -1) {
                return XMIDocument.this.m_resolutionStrategy.resolveUUID(this.m_property, this.m_ref);
            }
            int fragmentIndex = index + 1;
            if (this.m_ref.length() > fragmentIndex) {
                if (index == 0) {
                    return XMIDocument.this.resolveId(this.m_property, this.m_ref.substring(1));
                }
                String documentURI = this.m_ref.substring(0, index);
                String fragment = this.m_ref.substring(fragmentIndex);
                if (XMIDocument.this.m_uri != null && documentURI.indexOf(58) == -1) {
                    documentURI = XMIDocument.this.m_uri.resolve(documentURI).toString();
                }
                return XMIDocument.this.m_resolutionStrategy.resolveFragment(this.m_property, documentURI, fragment);
            }
            return ResolutionResult.NOT_FOUND;
        }
    }

    private class XMIIdref
    extends XMIReference {
        protected String m_ref;
        private boolean m_resolving;

        public XMIIdref(Locator locator, Object instance, XMIProperty property, String ref) {
            super(locator, instance, property);
            this.m_ref = ref;
        }

        @Override
        public final Object resolve() {
            if (this.m_resolving) {
                this.report("ReferenceCycle.text", 1);
                return ResolutionResult.NOT_FOUND;
            }
            this.m_resolving = true;
            Object refInstance = this.resolveImpl();
            this.m_resolving = false;
            if (this.m_property != null) {
                if (ResolutionResult.NOT_FOUND == refInstance) {
                    this.report("DereferenceMissingElement.text", 1);
                } else if (ResolutionResult.IGNORED == refInstance) {
                    if (XMIDocument.this.m_logUnsupported) {
                        this.report("DereferenceIgnoredElement.text", 0);
                    }
                } else {
                    this.addValue(refInstance);
                }
            }
            return refInstance;
        }

        protected Object resolveImpl() {
            return XMIDocument.this.resolveId(this.m_property, this.m_ref);
        }

        protected void report(String key, int type) {
            this.report(new XMIException(ResourcesSingleton.getPicker().getString(key, (Object)this.m_ref), null, type));
        }
    }

    private final class XMICompositeReference
    extends XMIReference {
        private Object m_composite;

        public XMICompositeReference(Locator locator, Object instance, XMIProperty property, Object composite) {
            super(locator, instance, property);
            this.m_composite = composite;
        }

        @Override
        public Object resolve() {
            this.addValue(this.m_composite);
            return this.m_composite;
        }
    }

    private abstract class XMIReference {
        protected int m_lineNumber;
        protected int m_columnNumber;
        protected Object m_instance;
        protected XMIProperty m_property;

        public XMIReference(Locator locator, Object instance, XMIProperty property) {
            this.m_lineNumber = locator.getLineNumber();
            this.m_columnNumber = locator.getColumnNumber();
            this.m_instance = instance;
            this.m_property = property;
        }

        public abstract Object resolve();

        protected void addValue(Object refInstance) {
            try {
                this.m_property.addValue(this.m_instance, refInstance);
            }
            catch (XMIException e) {
                this.report(e);
            }
            catch (Exception e) {
                this.report(new XMIException(e.getMessage(), e, 1));
            }
        }

        protected void report(XMIException e) {
            XMIDocument.this.report(e, this.m_lineNumber, this.m_columnNumber);
        }
    }
}

