/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import sqlj.runtime.ConnectionContext;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.ProfileData;
import sqlj.runtime.profile.RTStatement;
import sqlj.runtime.profile.ScrollableResultSetDescriptor;
import sqlj.runtime.profile.ref.CachedDynamicProfile;
import sqlj.runtime.profile.ref.CachedStatement;
import sqlj.runtime.profile.ref.RTCallableStatement;
import sqlj.runtime.profile.ref.RTStatementJDBCCallable;
import sqlj.runtime.profile.ref.RTStatementJDBCPrepared;
import sqlj.runtime.ref.ConnectionContextImpl;

public class JDBCProfile
implements CachedDynamicProfile {
    private ProfileData profileData;
    private Connection conn;
    private Map m_typeMap;

    public JDBCProfile(ConnectionContext connectionContext, ProfileData profileData) {
        block5: {
            this.profileData = profileData;
            this.conn = connectionContext.getConnection();
            try {
                this.m_typeMap = connectionContext.getTypeMap();
            }
            catch (SQLException sQLException) {
                throw new ExceptionInInitializerError(sQLException);
            }
            catch (AbstractMethodError abstractMethodError) {
                String string = null;
                try {
                    string = (String)connectionContext.getClass().getField("typeMap").get(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string == null) break block5;
                this.m_typeMap = ConnectionContextImpl.loadTypeMap(connectionContext.getClass(), string);
            }
        }
    }

    public Map getTypeMap() {
        return this.m_typeMap;
    }

    public ProfileData getProfileData() {
        return this.profileData;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public RTStatement getStatement(int n) throws SQLException {
        EntryInfo entryInfo = this.profileData.getEntryInfo(n);
        if (entryInfo.getStatementType() == 2) {
            return this.prepareStatement(this.getSQLString(n), entryInfo);
        }
        return this.prepareCall(this.getSQLString(n), entryInfo);
    }

    public RTStatement getStatement(int n, BatchContext batchContext) throws SQLException {
        EntryInfo entryInfo = this.profileData.getEntryInfo(n);
        if (entryInfo.getStatementType() == 2) {
            return this.prepareStatement(this.getSQLString(n), batchContext, entryInfo);
        }
        return this.prepareCall(this.getSQLString(n), batchContext, entryInfo);
    }

    public CachedStatement getCachedStatement(int n) throws SQLException {
        EntryInfo entryInfo = this.profileData.getEntryInfo(n);
        if (entryInfo.getStatementType() == 2) {
            return this.prepareCachedStatement(this.getSQLString(n), entryInfo);
        }
        return this.prepareCachedCall(this.getSQLString(n), entryInfo);
    }

    public CachedStatement getCachedStatement(int n, BatchContext batchContext) throws SQLException {
        EntryInfo entryInfo = this.profileData.getEntryInfo(n);
        if (entryInfo.getStatementType() == 2) {
            return this.prepareCachedStatement(this.getSQLString(n), batchContext, entryInfo);
        }
        return this.prepareCachedCall(this.getSQLString(n), batchContext, entryInfo);
    }

    protected String getSQLString(int n) throws SQLException {
        return this.profileData.getEntryInfo(n).getSQLString();
    }

    public RTCallableStatement prepareCall(String string, EntryInfo entryInfo) throws SQLException {
        return (RTCallableStatement)this.prepareCachedCall(string, entryInfo).getStatement(null);
    }

    public RTCallableStatement prepareCall(String string, BatchContext batchContext, EntryInfo entryInfo) throws SQLException {
        return (RTCallableStatement)this.prepareCachedCall(string, batchContext, entryInfo).getStatement(null);
    }

    public CachedStatement prepareCachedCall(String string, EntryInfo entryInfo) throws SQLException {
        return new RTStatementJDBCCallable(entryInfo.getMetaBinds() == null ? (entryInfo.getScrollableDescriptor() == null ? this.conn.prepareCall(string) : this.prepareScrollableCall(string, entryInfo.getScrollableDescriptor())) : null, this.conn, false, this.m_typeMap, entryInfo);
    }

    public CachedStatement prepareCachedCall(String string, BatchContext batchContext, EntryInfo entryInfo) throws SQLException {
        return new RTStatementJDBCCallable(entryInfo.getMetaBinds() == null ? (entryInfo.getScrollableDescriptor() == null ? this.conn.prepareCall(string) : this.prepareScrollableCall(string, entryInfo.getScrollableDescriptor())) : null, this.conn, false, batchContext, this.m_typeMap, entryInfo);
    }

    protected CallableStatement prepareScrollableCall(String string, ScrollableResultSetDescriptor scrollableResultSetDescriptor) throws SQLException {
        return this.conn.prepareCall(string, scrollableResultSetDescriptor.getType(), scrollableResultSetDescriptor.getConcurrency());
    }

    public RTStatement prepareStatement(String string, EntryInfo entryInfo) throws SQLException {
        return this.prepareCachedStatement(string, entryInfo).getStatement(null);
    }

    public RTStatement prepareStatement(String string, BatchContext batchContext, EntryInfo entryInfo) throws SQLException {
        return this.prepareCachedStatement(string, batchContext, entryInfo).getStatement(null);
    }

    public CachedStatement prepareCachedStatement(String string, EntryInfo entryInfo) throws SQLException {
        return new RTStatementJDBCPrepared(entryInfo.getMetaBinds() == null ? (entryInfo.getScrollableDescriptor() == null ? this.conn.prepareStatement(string) : this.prepareScrollableStatement(string, entryInfo.getScrollableDescriptor())) : null, this.conn, false, this.m_typeMap, entryInfo);
    }

    public CachedStatement prepareCachedStatement(String string, BatchContext batchContext, EntryInfo entryInfo) throws SQLException {
        return new RTStatementJDBCPrepared(entryInfo.getMetaBinds() == null ? (entryInfo.getScrollableDescriptor() == null ? this.conn.prepareStatement(string) : this.prepareScrollableStatement(string, entryInfo.getScrollableDescriptor())) : null, this.conn, false, batchContext, this.m_typeMap, entryInfo);
    }

    protected PreparedStatement prepareScrollableStatement(String string, ScrollableResultSetDescriptor scrollableResultSetDescriptor) throws SQLException {
        return this.conn.prepareStatement(string, scrollableResultSetDescriptor.getType(), scrollableResultSetDescriptor.getConcurrency());
    }

    public void close() throws SQLException {
    }
}

