/*
 * Decompiled with CFR 0.152.
 */
package oracle.sqlj.runtime;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.sqlj.runtime.IBMWrappedRTStmt;
import oracle.sqlj.runtime.OraCachedStatement;
import oracle.sqlj.runtime.OraConsts;
import oracle.sqlj.runtime.OraDynamicClosure;
import oracle.sqlj.runtime.OraEntryInfo;
import oracle.sqlj.runtime.OraIterConvertStatement;
import oracle.sqlj.runtime.OraProfileData;
import oracle.sqlj.runtime.OraRTResultSet;
import oracle.sqlj.runtime.OraRTStatement;
import oracle.sqlj.runtime.OraSerializableClosure;
import oracle.sqlj.runtime.OraTypeClosure;
import oracle.sqlj.runtime.OraTypeInfo;
import sqlj.runtime.ConnectionContext;
import sqlj.runtime.error.ProfileRefErrors;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.ScrollableResultSetDescriptor;
import sqlj.runtime.profile.TypeInfo;
import sqlj.runtime.profile.ref.CachedStatement;
import sqlj.runtime.profile.ref.JDBCProfile;

public class OraProfile
extends JDBCProfile
implements OraConsts {
    private OraProfileData m_oraProfile;
    private OraTypeClosure[] m_typeClosures;
    private boolean m_isNativeSQL;
    private OracleConnection m_oConn;
    private OraTypeClosure m_serializableClosure = null;

    public OraProfile(ConnectionContext connectionContext, OraProfileData oraProfileData, OraTypeClosure[] oraTypeClosureArray, boolean bl) {
        super(connectionContext, oraProfileData.getProfileData());
        this.m_oraProfile = oraProfileData;
        this.m_typeClosures = oraTypeClosureArray;
        this.m_isNativeSQL = bl;
        this.m_oConn = connectionContext.getConnection() instanceof OracleConnection ? (OracleConnection)connectionContext.getConnection() : null;
    }

    protected String getSQLString(int n) throws SQLException {
        return this.m_oraProfile.getEntryInfo(n).getSQLString();
    }

    OraTypeClosure getTypeClosure(OraTypeInfo oraTypeInfo) {
        int n = oraTypeInfo.getOracleType();
        if (n < 0 || n >= this.m_typeClosures.length) {
            if (n == -99) {
                if (this.m_serializableClosure == null) {
                    this.m_serializableClosure = new OraSerializableClosure(this.getConnection());
                }
                return this.m_serializableClosure;
            }
            n = 0;
        }
        return this.m_typeClosures[n];
    }

    public CachedStatement getCachedStatement(int n) throws SQLException {
        OraEntryInfo oraEntryInfo = this.m_oraProfile.getEntryInfo(n);
        EntryInfo entryInfo = oraEntryInfo.getEntryInfo();
        int n2 = entryInfo.getRole();
        switch (n2) {
            case 18: {
                return new OraIterConvertStatement(this, oraEntryInfo);
            }
        }
        return new OraCachedStatement(this.newStatement(oraEntryInfo, n2, n), super.getCachedStatement(n));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CachedStatement getCachedStatement(int n, BatchContext batchContext) throws SQLException {
        OraEntryInfo oraEntryInfo = this.m_oraProfile.getEntryInfo(n);
        EntryInfo entryInfo = oraEntryInfo.getEntryInfo();
        int n2 = entryInfo.getRole();
        switch (n2) {
            case 18: {
                return new OraIterConvertStatement(this, oraEntryInfo);
            }
        }
        OraRTStatement oraRTStatement = null;
        CachedStatement cachedStatement = null;
        if (batchContext != null) {
            if (!(batchContext instanceof OraRTStatement.OraBatchContext) || (oraRTStatement = ((OraRTStatement.OraBatchContext)batchContext).getCachedStatement(this, n)) == null) return null;
            cachedStatement = (CachedStatement)((Object)oraRTStatement.getWrappedRTStatement());
            return new OraCachedStatement(oraRTStatement, cachedStatement, this, n);
        } else {
            oraRTStatement = this.newStatement(oraEntryInfo, n2, n);
            cachedStatement = super.getCachedStatement(n, batchContext);
        }
        return new OraCachedStatement(oraRTStatement, cachedStatement, this, n);
    }

    protected OraRTStatement newStatement(OraEntryInfo oraEntryInfo, int n, int n2) throws SQLException {
        if (this.m_oraProfile.getIBMWrapped()) {
            return new IBMWrappedRTStmt(null, oraEntryInfo, this, this.m_isNativeSQL, n2);
        }
        return new OraRTStatement(null, oraEntryInfo, this, this.m_isNativeSQL, n2);
    }

    protected RTResultSet newResultSet(RTResultSet rTResultSet, OraEntryInfo oraEntryInfo) throws SQLException {
        if (oraEntryInfo == null || oraEntryInfo.getEntryInfo().getRole() == 19) {
            return rTResultSet;
        }
        return new OraRTResultSet(rTResultSet, oraEntryInfo, this);
    }

    Class getTypeClass(TypeInfo typeInfo) {
        return this.getProfileData().getProfile().getJavaType(typeInfo);
    }

    protected PreparedStatement prepareScrollableStatement(String string, ScrollableResultSetDescriptor scrollableResultSetDescriptor) throws SQLException {
        if (this.m_oConn == null) {
            Method method = null;
            try {
                method = this.getConnection().getClass().getMethod("prepareStatement", String.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (method == null) {
                if (scrollableResultSetDescriptor.getConcurrency() == 1007 && scrollableResultSetDescriptor.getType() == 1003) {
                    return this.getConnection().prepareStatement(string);
                }
                String string2 = this.getConnection().getClass().getName() + ".prepareStatement(java.lang.String,int,int)";
                ProfileRefErrors.raise_EXCEPTION_IN_METHOD(string2, new NoSuchMethodException(string2));
                return null;
            }
            return (PreparedStatement)OraDynamicClosure.invoke(method, this.getConnection(), new Object[]{string, OraDynamicClosure.toInteger(scrollableResultSetDescriptor.getType()), OraDynamicClosure.toInteger(scrollableResultSetDescriptor.getConcurrency())});
        }
        if (scrollableResultSetDescriptor.getReturnability()) {
            boolean bl = this.m_oConn.getCreateStatementAsRefCursor();
            if (!bl) {
                this.m_oConn.setCreateStatementAsRefCursor(true);
            }
            PreparedStatement preparedStatement = this.m_oConn.prepareStatement(string, scrollableResultSetDescriptor.getType(), scrollableResultSetDescriptor.getConcurrency());
            if (!bl) {
                this.m_oConn.setCreateStatementAsRefCursor(false);
            }
            return preparedStatement;
        }
        return this.m_oConn.prepareStatement(string, scrollableResultSetDescriptor.getType(), scrollableResultSetDescriptor.getConcurrency());
    }

    protected CallableStatement prepareScrollableCall(String string, ScrollableResultSetDescriptor scrollableResultSetDescriptor) throws SQLException {
        if (this.m_oConn == null) {
            Method method = null;
            try {
                method = this.getConnection().getClass().getMethod("prepareCall", String.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (method == null) {
                if (scrollableResultSetDescriptor.getConcurrency() == 1007 && scrollableResultSetDescriptor.getType() == 1003) {
                    return this.getConnection().prepareCall(string);
                }
                String string2 = this.getConnection().getClass().getName() + ".prepareCall(java.lang.String,int,int)";
                ProfileRefErrors.raise_EXCEPTION_IN_METHOD(string2, new NoSuchMethodException(string2));
                return null;
            }
            return (CallableStatement)OraDynamicClosure.invoke(method, this.getConnection(), new Object[]{string, OraDynamicClosure.toInteger(scrollableResultSetDescriptor.getType()), OraDynamicClosure.toInteger(scrollableResultSetDescriptor.getConcurrency())});
        }
        if (scrollableResultSetDescriptor.getReturnability()) {
            boolean bl = this.m_oConn.getCreateStatementAsRefCursor();
            if (!bl) {
                this.m_oConn.setCreateStatementAsRefCursor(true);
            }
            CallableStatement callableStatement = this.m_oConn.prepareCall(string, scrollableResultSetDescriptor.getType(), scrollableResultSetDescriptor.getConcurrency());
            if (!bl) {
                this.m_oConn.setCreateStatementAsRefCursor(false);
            }
            return callableStatement;
        }
        return this.m_oConn.prepareCall(string, scrollableResultSetDescriptor.getType(), scrollableResultSetDescriptor.getConcurrency());
    }
}

