/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.wizards.rdfmodel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.actions.SQLScriptProcessor;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.wizards.AbstractWizardPanel;
import oracle.dbtools.rdfgraph.wizards.rdfmodel.RDFModelWizardModel;
import oracle.javatools.editor.BasicEditorPane;

public class RDFModelSummaryWizardPanel
extends AbstractWizardPanel<RDFModelWizardModel>
implements ActionListener,
LayoutControl {
    CustomTabbedPane tabbedPane;
    JPanel summaryPanel;
    JButton loadBtn;
    SQLScriptProcessor scriptProcessor;
    BasicEditorPane sqlEditor;
    String[] columnNames = new String[]{RdfgraphArb.getString("RDFModelSummaryWizardPanel.TASK_S_")};
    JTable summaryTable;
    DefaultTableModel lmodel = new DefaultTableModel();

    @Override
    protected void initializeUI(RDFModelWizardModel rDFModelWizardModel) {
        this.setLayout(new BorderLayout());
        this.tabbedPane = new CustomTabbedPane();
        this.summaryPanel = LayoutControl.GBC.createPanel();
        this.summaryPanel.setLayout(new BorderLayout());
        this.summaryTable = new JTable();
        this.summaryTable.setModel(this.lmodel);
        this.lmodel.setColumnIdentifiers(this.columnNames);
        for (String string : rDFModelWizardModel.getSummaryLines()) {
            this.lmodel.addRow(new Object[]{string});
        }
        this.summaryPanel.add(new JScrollPane(this.summaryTable));
        this.tabbedPane.addTab(null, RdfgraphArb.getString("RDFModelSummaryWizardPanel.SUMMARY"), (Component)this.summaryPanel);
        this.scriptProcessor = new SQLScriptProcessor();
        this.sqlEditor = this.scriptProcessor.getEditorPane();
        this.sqlEditor.setText(rDFModelWizardModel.getSummaryScript());
        this.sqlEditor.setEditable(false);
        this.tabbedPane.addTab(null, RdfgraphArb.getString("PL_SQL"), (Component)new JScrollPane((Component)this.sqlEditor));
        this.add((Component)this.tabbedPane);
        this.loadBtn = new JButton(RdfgraphArb.getString("RDFModelSummaryWizardPanel.LOAD_RDF_MODEL"));
        this.loadBtn.addActionListener(this);
    }

    @Override
    protected void onEntry(RDFModelWizardModel rDFModelWizardModel) {
        this.sqlEditor.setEditable(true);
        this.sqlEditor.setText(rDFModelWizardModel.getSummaryScript());
        this.sqlEditor.setEditable(false);
        this.sqlEditor.updateUI();
        this.lmodel.getDataVector().removeAllElements();
        for (String string : rDFModelWizardModel.getSummaryLines()) {
            this.lmodel.addRow(new Object[]{string});
        }
        this.lmodel.fireTableDataChanged();
        this.enableButtons(true, true, true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BulkLoadTask bulkLoadTask = new BulkLoadTask((RDFModelWizardModel)this.getModel());
        RaptorTaskManager.getInstance().addTask((RaptorTask)bulkLoadTask);
        bulkLoadTask.setMessage(RdfgraphArb.getString("RDFModelSummaryWizardPanel.BULK_LOADING_FROM_STAGING_TABLE___"));
    }

    public class BulkLoadTask
    extends DatabaseQueryTask<List<String>> {
        private RDFModelWizardModel model;

        public BulkLoadTask(RDFModelWizardModel rDFModelWizardModel) {
            super("ListTask", IRaptorTaskRunMode.IDE_STATUSBAR, false, true, true);
            this.model = rDFModelWizardModel;
        }

        public String getConnectionName() {
            return "";
        }

        public String getQuery() {
            return RdfgraphArb.getString("RDFModelSummaryWizardPanel.BULK_LOAD_FROM_STAGING_TABLE");
        }

        protected List<String> doWork() {
            this.setMessage(RdfgraphArb.getString("RDFModelSummaryWizardPanel.BULK_LOADING_FROM_STAGING_TABLE_INTO_MODEL___"));
            this.model.BulkInsertFromStaging();
            return Collections.emptyList();
        }
    }
}

