/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.rdfgraph.utils.RDFStatement;

public class RDFStatementIterator
implements Iterator<RDFStatement>,
Iterable<RDFStatement> {
    final int EOF_CODE = -1;
    final int N_COMMENT_START = 35;
    final int N_FULL_STOP = 46;
    final int BEGIN_READ = -2;
    private InputStream in;
    private Reader reader;
    private int line_number = 1;
    private int curr_char = -2;
    private RDFStatement nextStatement = null;

    public RDFStatementIterator(InputStream inputStream) {
        this.in = inputStream;
        this.reader = new InputStreamReader(inputStream, Charset.forName("UTF-8"));
        this.loadNextStatement();
    }

    public RDFStatementIterator(File file) {
        try {
            this.in = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(RDFStatementIterator.class.getName()).log(Level.SEVERE, null, fileNotFoundException);
        }
        this.reader = new InputStreamReader(this.in, Charset.forName("UTF-8"));
        this.loadNextStatement();
    }

    public RDFStatementIterator(String string) {
        this(new File(string));
    }

    @Override
    public boolean hasNext() {
        return this.nextStatement != null && !this.nextStatement.isEmpty();
    }

    @Override
    public RDFStatement next() {
        if (this.nextStatement == null) {
            throw new NoSuchElementException();
        }
        RDFStatement rDFStatement = this.nextStatement;
        this.nextStatement = new RDFStatement();
        this.loadNextStatement();
        return rDFStatement;
    }

    @Override
    public Iterator<RDFStatement> iterator() {
        return this;
    }

    private void loadNextStatement() {
        RDFStatement rDFStatement = new RDFStatement();
        int n = this.curr_char;
        try {
            n = this.skipLineStart(n);
            switch (n) {
                case 35: {
                    break;
                }
                case 10: 
                case 13: {
                    break;
                }
                case -1: {
                    return;
                }
                default: {
                    n = this.parseRDFStatement(n, rDFStatement);
                }
            }
            n = this.skipWhiteSpaceAndTabs(n);
            this.curr_char = n = this.jumptoNextLine(n);
            if (rDFStatement.isEmpty() && n != -1) {
                this.loadNextStatement();
            } else {
                this.nextStatement = rDFStatement;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(RDFStatementIterator.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    private int parseRDFStatement(int n, RDFStatement rDFStatement) {
        try {
            n = this.parseRDFTerm(n, rDFStatement);
            n = this.parseRDFTerm(n, rDFStatement);
            n = this.parseRDFTerm(n, rDFStatement);
            if (n != 46) {
                n = this.parseRDFTerm(n, rDFStatement);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(RDFStatementIterator.class.getName()).log(Level.SEVERE, null, iOException);
        }
        return n;
    }

    private int parseRDFTerm(int n, RDFStatement rDFStatement) throws IOException {
        switch (n) {
            case 60: {
                n = this.parseURI(n, rDFStatement);
                break;
            }
            case 95: {
                n = this.parseBNode(n, rDFStatement);
                break;
            }
            case 34: {
                n = this.parseLiteral(n, rDFStatement);
                break;
            }
            case -1: {
                throw new IOException("Expecting <, _ or \" but EOF was found at line: " + this.line_number);
            }
        }
        n = this.skipWhiteSpaceAndTabs(n);
        return n;
    }

    private int parseURI(int n, RDFStatement rDFStatement) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        if (n != 60) {
            // empty if block
        }
        stringBuilder.append(Character.toChars(n));
        n = this.readNextCodePoint();
        while (n != 62) {
            if (n == -1) {
                throw new IOException("EOF found while parsing URI at line: " + this.line_number);
            }
            if (n == 92) {
                stringBuilder.append(Character.toChars(n));
                n = this.readNextCodePoint();
                if (n == -1) {
                    throw new IOException("EOF found while parsing URI at line: " + this.line_number);
                }
                if (n != 117 && n != 85) {
                    throw new IOException("Escape sequence not supported at URI at line: " + this.line_number);
                }
            }
            stringBuilder.append(Character.toChars(n));
            n = this.readNextCodePoint();
        }
        stringBuilder.append(Character.toChars(n));
        rDFStatement.addRDFTerm(stringBuilder.toString());
        n = this.readNextCodePoint();
        return n;
    }

    private int parseBNode(int n, RDFStatement rDFStatement) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        if (n != 95) {
            throw new IOException("Expected _ while parsing bnode, but " + new String(Character.toChars(n)) + " was found instead at line " + this.line_number);
        }
        stringBuilder.append(Character.toChars(n));
        n = this.readNextCodePoint();
        if (n == -1) {
            throw new IOException("EOF found while parsing bnode at line " + this.line_number);
        }
        if (n != 58) {
            throw new IOException("Expected : while parsing bnode, but " + Arrays.toString(Character.toChars(n)) + " was found instead at line " + this.line_number);
        }
        stringBuilder.append(Character.toChars(n));
        n = this.readNextCodePoint();
        if (n == -1) {
            throw new IOException("EOF found while parsing bnode at line " + this.line_number);
        }
        if (!Character.isDigit(n) && !Character.isLetter(n)) {
            throw new IOException("Expected number or letter while parsing bnode, but " + new String(Character.toChars(n)) + " was found instead at line " + this.line_number);
        }
        while (n != -1 && Character.isLetterOrDigit(n)) {
            stringBuilder.append(Character.toChars(n));
            n = this.readNextCodePoint();
        }
        rDFStatement.addRDFTerm(stringBuilder.toString());
        return n;
    }

    private int parseLiteral(int n, RDFStatement rDFStatement) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        if (n != 34) {
            throw new IOException(" Literal should start with \" at: " + this.line_number);
        }
        stringBuilder.append(Character.toChars(n));
        n = this.readNextCodePoint();
        while (n != 34) {
            if (n == -1) {
                throw new IOException("EOF found while parsing literal at line " + this.line_number);
            }
            if (n == 92) {
                stringBuilder.append(Character.toChars(n));
                n = this.readNextCodePoint();
                if (n == -1) {
                    throw new IOException("EOF found while parsing literal at line " + this.line_number);
                }
            }
            stringBuilder.append(Character.toChars(n));
            n = this.readNextCodePoint();
        }
        stringBuilder.append(Character.toChars(n));
        n = this.readNextCodePoint();
        if (n == 64) {
            stringBuilder.append(Character.toChars(n));
            n = this.readNextCodePoint();
            if (!Character.isLetter(n)) {
                throw new IOException("Expected letter while parsing literal lang, but " + new String(Character.toChars(n)) + " was found instead at line " + this.line_number);
            }
            while (n != -1 && n != 46 && n != 94 && n != 32 && n != 9) {
                stringBuilder.append(Character.toChars(n));
                n = this.readNextCodePoint();
            }
        } else if (n == 94) {
            stringBuilder.append(Character.toChars(n));
            n = this.readNextCodePoint();
            if (n == -1) {
                throw new IOException("EOF found while parsing literal at line " + this.line_number);
            }
            if (n != 94) {
                throw new IOException("Expected ^ while parsing literal datatype, but " + new String(Character.toChars(n)) + " was found instead at line " + this.line_number);
            }
            stringBuilder.append(Character.toChars(n));
            n = this.readNextCodePoint();
            if (n == -1) {
                throw new IOException("EOF found while parsing literal at line " + this.line_number);
            }
            if (n != 60) {
                throw new IOException("Expected < while parsing literal datatype, but " + new String(Character.toChars(n)) + " was found instead at line " + this.line_number);
            }
            n = this.parseDatatypeURI(n, stringBuilder);
        }
        rDFStatement.addRDFTerm(stringBuilder.toString());
        return n;
    }

    private int parseDatatypeURI(int n, StringBuilder stringBuilder) throws IOException {
        if (n != 60) {
            // empty if block
        }
        stringBuilder.append(Character.toChars(n));
        n = this.readNextCodePoint();
        while (n != 62) {
            if (n == -1) {
                throw new IOException("EOF found while parsing URI at line: " + this.line_number);
            }
            if (n == 92) {
                stringBuilder.append(Character.toChars(n));
                n = this.readNextCodePoint();
                if (n == -1) {
                    throw new IOException("EOF found while parsing URI at line: " + this.line_number);
                }
                if (n != 117 && n != 85) {
                    throw new IOException("Escape sequence not supported at URI at line: " + this.line_number);
                }
            }
            stringBuilder.append(Character.toChars(n));
            n = this.readNextCodePoint();
        }
        stringBuilder.append(Character.toChars(n));
        n = this.readNextCodePoint();
        return n;
    }

    private int skipLineStart(int n) throws IOException {
        if (n == -2) {
            n = this.readNextCodePoint();
        }
        return this.skipWhiteSpaceAndTabs(n);
    }

    private int skipWhiteSpaceAndTabs(int n) throws IOException {
        while (n == 32 || n == 9) {
            n = this.readNextCodePoint();
        }
        return n;
    }

    private int jumptoNextLine(int n) throws IOException {
        while (n != -1 && n != 13 && n != 10) {
            n = this.readNextCodePoint();
        }
        if (n == 10) {
            n = this.readNextCodePoint();
            ++this.line_number;
        } else if (n == 13) {
            n = this.readNextCodePoint();
            if (n == 10) {
                n = this.readNextCodePoint();
            }
            ++this.line_number;
        }
        return n;
    }

    private int readNextCodePoint() throws IOException {
        int n = this.reader.read();
        if (Character.isHighSurrogate((char)n)) {
            n = Character.toCodePoint((char)n, (char)this.reader.read());
        }
        return n;
    }
}

