/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.controls.JPanelActionControl;
import oracle.dbtools.raptor.ui.controls.SideBySideActionControl;
import oracle.dbtools.raptor.ui.controls.TableActionControl;
import oracle.dbtools.raptor.ui.controls.TableActionControlPanel;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.ui.SourceRow;
import oracle.dbtools.rdfgraph.ui.TableSearchRunnable;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class SearchShuttleControl
extends ActionControl
implements SearchListener {
    JPanel mPanel = new JPanel();
    SearchField txtSearch;
    TableActionControl leftTable;
    JTable jLeftTable;
    TableActionControl rightTable;
    JTable jRightTable;
    SideBySideActionControl sideBySideControl;
    Connection connection;
    TableSearchRunnable searchRunnable;
    String[] columnNames;
    String searchCol;
    private List<ActionControl> childControls;
    private List<SourceRow> selectedRows;
    String querySource;

    public void setSearchCol(String string) {
        this.searchCol = string;
    }

    public String getSearchCol() {
        return this.searchCol;
    }

    public List<SourceRow> getSelectedRows() {
        return this.selectedRows;
    }

    public void setColumnNames(String[] stringArray) {
        this.columnNames = stringArray;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setQuerySource(String string) {
        this.querySource = string;
    }

    public String getQuerySource() {
        return this.querySource;
    }

    public void setSearchRunnable(TableSearchRunnable tableSearchRunnable) {
        this.searchRunnable = tableSearchRunnable;
    }

    public TableSearchRunnable getSearchRunnable() {
        return this.searchRunnable;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public SearchShuttleControl(String string, String string2, Connection connection, String string3, String[] stringArray, String string4) {
        super(string, string2);
        this.setConnection(connection);
        this.setQuerySource(string3);
        this.setColumnNames(stringArray);
        this.setSearchCol(string4);
        this.init();
    }

    private void init() {
        this.selectedRows = new ArrayList<SourceRow>();
        this.childControls = new ArrayList<ActionControl>();
        this.txtSearch = new SearchField();
        this.txtSearch.setStyle(SearchField.Style.SEARCH);
        this.txtSearch.addSearchListener((SearchListener)this);
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.getColumnNames()));
        this.leftTable = new TableActionControl("available_sources", arrayList, new ArrayList(), 10);
        this.leftTable.setTitle(RdfgraphArb.getString("SearchShuttleControl.AVAILABLE_SOURCES_DC_TO_ADD_"));
        this.jLeftTable = ((TableActionControlPanel)this.leftTable.getUI()).getTable();
        this.jLeftTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JTable jTable = (JTable)mouseEvent.getSource();
                Point point = mouseEvent.getPoint();
                int n = jTable.rowAtPoint(point);
                if (mouseEvent.getClickCount() == 2) {
                    Object[] objectArray = new Object[SearchShuttleControl.this.getColumnNames().length];
                    for (int i = 0; i < SearchShuttleControl.this.getColumnNames().length; ++i) {
                        objectArray[i] = (String)jTable.getModel().getValueAt(n, i);
                    }
                    SearchShuttleControl.this.selectedRows.add(new SourceRow(objectArray));
                    SearchShuttleControl.this.rightTable.setRows(SearchShuttleControl.this.selectedRows);
                }
            }
        });
        this.rightTable = new TableActionControl("selected_sources", arrayList, new ArrayList(), 10);
        this.rightTable.setTitle(RdfgraphArb.getString("SearchShuttleControl.SELECTED_SOURCES_DC_TO_REMOVE_"));
        this.jRightTable = ((TableActionControlPanel)this.rightTable.getUI()).getTable();
        this.jRightTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JTable jTable = (JTable)mouseEvent.getSource();
                Point point = mouseEvent.getPoint();
                int n = jTable.rowAtPoint(point);
                if (mouseEvent.getClickCount() == 2) {
                    SearchShuttleControl.this.selectedRows.remove(n);
                    SearchShuttleControl.this.rightTable.setRows(SearchShuttleControl.this.selectedRows);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.txtSearch, "Center");
        JPanelActionControl jPanelActionControl = new JPanelActionControl("search_panel", "", jPanel);
        this.sideBySideControl = new SideBySideActionControl(null, null, (ActionControl)this.leftTable, (ActionControl)this.rightTable);
        this.childControls.add((ActionControl)jPanelActionControl);
        this.childControls.add((ActionControl)this.sideBySideControl);
        this.mPanel.setLayout(new BorderLayout());
        this.mPanel.add((Component)jPanelActionControl.getUI(), "North");
        this.mPanel.add((Component)this.sideBySideControl.getUI(), "Center");
    }

    public void searchPerformed(SearchEvent searchEvent) {
        TableSearchRunnable tableSearchRunnable = new TableSearchRunnable(searchEvent.getSearchProgress(), searchEvent.getSearchCategory(), searchEvent.getSearchText());
        tableSearchRunnable.setColumnNames(this.getColumnNames());
        tableSearchRunnable.setQuerySource(this.getQuerySource());
        tableSearchRunnable.setSearchCol(this.getSearchCol());
        tableSearchRunnable.setResultTablecontrol(this.leftTable);
        tableSearchRunnable.setConnection(this.getConnection());
        Thread thread = new Thread((Runnable)tableSearchRunnable, RdfgraphArb.getString("SEARCHING"));
        thread.start();
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
    }

    public ActionControl.Value getValue() {
        return new ActionControl.Value();
    }

    public Component getUI() {
        return this.mPanel;
    }

    public void setEditable(boolean bl) {
    }

    public List<ActionControl> getChildControls() {
        return this.childControls;
    }
}

