/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.ui.actions.LongActionDialog;
import oracle.dbtools.rdfgraph.utils.PLSQLBlockTemplate;

public class BulkLoadFromStagingActionDialog
extends LongActionDialog {
    private String title;
    String uname = "";
    Connection conn;
    TextBoxActionControl txtModelName;
    BooleanCheckBoxActionControl chkCreateModel;
    TextBoxActionControl txtTableOwner;
    SqlComboBoxActionControl txtTableName;
    TextBoxActionControl txtFlags;
    BooleanCheckBoxActionControl chkDebug;
    BooleanCheckBoxActionControl chkDebugETAB;
    TextBoxActionControl txtStartComment;
    TextBoxActionControl txtEndComment;

    public void setTitle(String string) {
        this.title = string;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setUname(String string) {
        this.uname = string;
    }

    public String getUname() {
        return this.uname;
    }

    public void setConn(Connection connection) {
        this.conn = connection;
    }

    public Connection getConn() {
        return this.conn;
    }

    public BulkLoadFromStagingActionDialog(String string) {
        this.title = string;
    }

    public BulkLoadFromStagingActionDialog() {
        this(RdfgraphArb.getString("BULK_LOAD_MODEL_FROM_STAGING_TABLE"));
    }

    @Override
    protected List<ActionControl> createControls(Connection connection) {
        HashMap hashMap = new HashMap();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        this.uname = dBUtil.executeOracleReturnOneCol(this.getQuery(connection, "getUser"), hashMap);
        this.txtModelName = new TextBoxActionControl("model_name", RdfgraphArb.getString("MODEL"), "model_name");
        this.chkCreateModel = new BooleanCheckBoxActionControl("create_model", RdfgraphArb.getString("BulkLoadFromStagingActionDialog.CREATE_MODEL"), true);
        this.txtTableOwner = new TextBoxActionControl("table_owner", RdfgraphArb.getString("BulkLoadFromStagingActionDialog.STAGING_TABLE_OWNER_"), this.uname);
        String string = "SELECT table_name FROM user_tab_cols WHERE column_name = 'RDF$STC_SUB'";
        this.txtTableName = new SqlComboBoxActionControl("table_name", RdfgraphArb.getString("BulkLoadFromStagingActionDialog.STAGING_TABLE_NAME_"), connection, string);
        this.txtFlags = new TextBoxActionControl("flags", RdfgraphArb.getString("FLAGS_"), " PARSE MBV_METHOD=SHADOW ");
        this.chkDebugETAB = new BooleanCheckBoxActionControl("create_et_tab", RdfgraphArb.getString("BulkLoadFromStagingActionDialog.CREATE_EVENT_TRACE_TABLE"), false);
        this.chkDebug = new BooleanCheckBoxActionControl("debug", RdfgraphArb.getString("BulkLoadFromStagingActionDialog.DEBUG_"), false);
        this.txtStartComment = new TextBoxActionControl("start_comment", RdfgraphArb.getString("START_COMMENT_"), "");
        this.txtEndComment = new TextBoxActionControl("end_comment", RdfgraphArb.getString("END_COMMENT_"), "");
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
            {
                this.add(BulkLoadFromStagingActionDialog.this.txtModelName);
                this.add(BulkLoadFromStagingActionDialog.this.chkCreateModel);
                this.add(BulkLoadFromStagingActionDialog.this.txtTableOwner);
                this.add(BulkLoadFromStagingActionDialog.this.txtTableName);
                this.add(BulkLoadFromStagingActionDialog.this.txtFlags);
                this.add(BulkLoadFromStagingActionDialog.this.chkDebugETAB);
                this.add(BulkLoadFromStagingActionDialog.this.chkDebug);
                this.add(BulkLoadFromStagingActionDialog.this.txtStartComment);
                this.add(BulkLoadFromStagingActionDialog.this.txtEndComment);
            }
        };
        return arrayList;
    }

    @Override
    protected String getScript(LongActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        Boolean bl = values.get("create_model").equals("true");
        Boolean bl2 = values.get("create_et_tab").equals("true");
        PLSQLBlockTemplate pLSQLBlockTemplate = new PLSQLBlockTemplate(this.getQuery(this.conn, "FULL_SIMPLE_CREATE_SEM_MODEL"));
        pLSQLBlockTemplate.replaceToken("#model_name#", values.get("model_name"), PLSQLBlockTemplate.ParamType.RAW);
        pLSQLBlockTemplate.setEndingSlash(true);
        if (bl.booleanValue()) {
            stringBuilder.append(pLSQLBlockTemplate.toString());
        }
        PLSQLBlockTemplate pLSQLBlockTemplate2 = new PLSQLBlockTemplate(this.getQuery(this.conn, "CREATE_ET_TAB"));
        if (bl2.booleanValue()) {
            stringBuilder.append(pLSQLBlockTemplate2.toString());
        }
        PLSQLBlockTemplate pLSQLBlockTemplate3 = new PLSQLBlockTemplate(this.getQuery(this.conn, "BULK_LOAD_FROM_STAGING_TABLE"));
        pLSQLBlockTemplate3.replaceToken("#model_name#", values.get("model_name"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate3.replaceToken("#table_owner#", values.get("table_owner"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate3.replaceToken("#table_name#", values.get("table_name"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate3.replaceToken("#table_owner_raw#", values.get("table_owner"), PLSQLBlockTemplate.ParamType.RAW);
        pLSQLBlockTemplate3.replaceToken("#table_name_raw#", values.get("table_name"), PLSQLBlockTemplate.ParamType.RAW);
        pLSQLBlockTemplate3.replaceToken("#flags#", values.get("flags"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate3.replaceToken("#start_comment#", values.get("start_comment"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate3.replaceToken("#end_comment#", values.get("end_comment"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate3.setEndingSlash(true);
        stringBuilder.append(pLSQLBlockTemplate3.toString());
        return stringBuilder.toString();
    }
}

