/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.sparql.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ButtonActionControl;
import oracle.dbtools.raptor.ui.controls.PropertyPanelActionControl;
import oracle.dbtools.raptor.ui.controls.SideBySideActionControl;
import oracle.dbtools.raptor.ui.controls.SpinnerActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.sparql.SPARQLArb;
import oracle.dbtools.rdfgraph.sparql.editor.SPARQLQueryEditor;

public class QueryOptionsDialog
extends JDialog
implements LayoutControl {
    SPARQLQueryEditor editor;

    public QueryOptionsDialog(JFrame jFrame, String string, SPARQLQueryEditor sPARQLQueryEditor) {
        super(jFrame, string, true);
        if (jFrame != null) {
            Dimension dimension = jFrame.getSize();
            Point point = jFrame.getLocation();
            this.setLocation(point.x + dimension.width / 4, point.y + dimension.height / 4);
        }
        this.editor = sPARQLQueryEditor;
        this.initControls();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setVisible(true);
    }

    private void initControls() {
        int n = this.editor.getQueryDynamicSampling();
        int n2 = this.editor.getQueryDop();
        int n3 = this.editor.getQueryTimeout();
        PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl("query_options", SPARQLArb.getString("QueryOptionsDialog.QUERY_OPTIONS"));
        final SpinnerActionControl spinnerActionControl = new SpinnerActionControl("dynamic", SPARQLArb.getString("QueryOptionsDialog.DYNAMIC_SAMPLING_"), Integer.valueOf(n), Integer.valueOf(0), Integer.valueOf(11), Integer.valueOf(1));
        final TextBoxActionControl textBoxActionControl = new TextBoxActionControl("dop", SPARQLArb.getString("QueryOptionsDialog.PARALLEL_"), Integer.toString(n2));
        final TextBoxActionControl textBoxActionControl2 = new TextBoxActionControl("timeout", SPARQLArb.getString("QueryOptionsDialog.TIMEOUT_MS__"), Integer.toString(n3));
        final BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl("chk_shorten", SPARQLArb.getString("QueryOptionsDialog.SHORTEN_URIS"), this.editor.isShortenURIs());
        ButtonActionControl buttonActionControl = new ButtonActionControl(RdfgraphArb.getString("DIALOG_OK_BUTTON_TEXT"));
        buttonActionControl.getUI().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryOptionsDialog.this.editor.setQueryDynamicSampl(Integer.parseInt(spinnerActionControl.getValue().get()));
                QueryOptionsDialog.this.editor.setQueryDop(Integer.parseInt(textBoxActionControl.getValue().get()));
                QueryOptionsDialog.this.editor.setQueryTimeout(Integer.parseInt(textBoxActionControl2.getValue().get()));
                QueryOptionsDialog.this.editor.setShortenURIs(Boolean.parseBoolean(booleanCheckBoxActionControl.getValue().get()));
                QueryOptionsDialog.this.setVisible(false);
            }
        });
        ButtonActionControl buttonActionControl2 = new ButtonActionControl(RdfgraphArb.getString("DIALOG_CANCEL_BUTTON_TEXT"));
        buttonActionControl2.getUI().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryOptionsDialog.this.setVisible(false);
            }
        });
        final SideBySideActionControl sideBySideActionControl = new SideBySideActionControl("buttons", "", (ActionControl)buttonActionControl, (ActionControl)buttonActionControl2);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
            {
                this.add(spinnerActionControl);
                this.add(textBoxActionControl);
                this.add(textBoxActionControl2);
                this.add(booleanCheckBoxActionControl);
                this.add(sideBySideActionControl);
            }
        };
        propertyPanelActionControl.addChildControls((List)arrayList);
        this.add(LayoutControl.GBC.createDialogMainPanel((Component)propertyPanelActionControl.getUI()));
    }
}

