/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.language;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.util.Pair;

public class R2RMLNode {
    public static final String BASE_LABEL = R2RMLArb.getString("R2RMLNODE");
    String value = "";
    String nodeType = "<R2RMLNode>";
    String description = "";
    List<Pair<String, R2RMLNode>> childEdges = new ArrayList<Pair<String, R2RMLNode>>();

    public R2RMLNode() {
    }

    public R2RMLNode(String string, String string2) {
        this();
        this.value = string;
        this.nodeType = string2;
    }

    public R2RMLNode(String string) {
        this(string, "<R2RMLNode>");
    }

    public R2RMLNode(String string, String string2, String string3) {
        this(string, string2);
        this.description = string3;
    }

    public List<Pair<String, R2RMLNode>> getChildEdges() {
        return this.childEdges;
    }

    public void addChildEdge(String string, R2RMLNode r2RMLNode) {
        this.childEdges.add((Pair<String, R2RMLNode>)new Pair((Object)string, (Object)r2RMLNode));
    }

    public void addChildEdge(String string, R2RMLNode r2RMLNode, int n) {
        this.childEdges.add(n, (Pair<String, R2RMLNode>)new Pair((Object)string, (Object)r2RMLNode));
    }

    public int getChildCount() {
        return this.childEdges.size();
    }

    public R2RMLNode getChildNode(String string) {
        Optional<Pair> optional = this.childEdges.stream().filter(pair -> ((R2RMLNode)pair.second()).getValue().equals(string)).findFirst();
        if (optional.isPresent()) {
            return (R2RMLNode)optional.get().second();
        }
        return null;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setNodeType(String string) {
        this.nodeType = string;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public boolean isBlankNode() {
        return this.getValue().startsWith("_:");
    }

    public List<R2RMLNode> getChildren() {
        ArrayList<R2RMLNode> arrayList = new ArrayList<R2RMLNode>();
        for (Pair<String, R2RMLNode> pair : this.childEdges) {
            arrayList.add((R2RMLNode)pair.second());
        }
        return arrayList;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return BASE_LABEL;
    }

    public void compile() {
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public R2RMLNode getFirstChildOfClass(Class clazz) {
        R2RMLNode r2RMLNode = null;
        for (R2RMLNode r2RMLNode2 : this.getChildren()) {
            if (clazz.isInstance(r2RMLNode2)) {
                return r2RMLNode2;
            }
            r2RMLNode = r2RMLNode2.getFirstChildOfClass(clazz);
            if (r2RMLNode == null) continue;
            return r2RMLNode;
        }
        return null;
    }

    public R2RMLNode getFirstChildByPredicate(String string) {
        Pair pair2 = this.childEdges.stream().filter(pair -> ((String)pair.first()).equals(string)).findFirst().orElse(null);
        if (pair2 != null) {
            return (R2RMLNode)pair2.second();
        }
        return null;
    }

    public <T extends R2RMLNode> List<T> getChildrenByPredicate(String string) {
        return this.childEdges.stream().filter(pair -> ((String)pair.first()).equals(string)).map(pair -> (R2RMLNode)pair.second()).collect(Collectors.toList());
    }

    public <T extends R2RMLNode> List<T> getChildrenByPredicateSet(HashSet<String> hashSet) {
        return this.childEdges.stream().filter(pair -> hashSet.contains(pair.first())).map(pair -> (R2RMLNode)pair.second()).collect(Collectors.toList());
    }

    public static String stripQuotes(String string) {
        string = string.replaceAll("\\\"", "");
        string = string.replaceAll("\\\\", "");
        return string;
    }

    public int removeChild(R2RMLNode r2RMLNode) {
        int n = 0;
        Iterator<Pair<String, R2RMLNode>> iterator = this.childEdges.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().second() == r2RMLNode) {
                iterator.remove();
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean removeChildEdge(String string) {
        Iterator<Pair<String, R2RMLNode>> iterator = this.childEdges.iterator();
        while (iterator.hasNext()) {
            if (!((String)iterator.next().first()).equals(string)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean replaceSingleChildByPredicate(String string, R2RMLNode r2RMLNode) {
        boolean bl = this.removeChildEdge(string);
        this.addChildEdge(string, r2RMLNode);
        return bl;
    }
}

