/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.editor.predicate;

import javax.swing.table.AbstractTableModel;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.language.ColumnNameNode;
import oracle.dbtools.rdfgraph.r2rml.language.PredicateMap;
import oracle.dbtools.rdfgraph.r2rml.language.PredicateObjectMap;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLNode;
import oracle.dbtools.rdfgraph.r2rml.language.StringTemplateNode;
import oracle.dbtools.rdfgraph.utils.RDFStringUtils;

public class PredicateMapTableModel
extends AbstractTableModel {
    private final String[] headers = new String[]{R2RMLArb.getString("PREDICATE_VALUE"), RdfgraphArb.getString("TYPE")};
    private final PredicateObjectMap node;

    public PredicateMapTableModel(PredicateObjectMap predicateObjectMap) {
        this.node = predicateObjectMap;
    }

    @Override
    public int getRowCount() {
        return this.node.getPredicateMaps().size();
    }

    @Override
    public int getColumnCount() {
        return this.headers.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                PredicateMap predicateMap = (PredicateMap)this.node.getPredicateMaps().get(n);
                return predicateMap.getSimpleValue();
            }
            case 1: {
                PredicateMap predicateMap = (PredicateMap)this.node.getPredicateMaps().get(n);
                return predicateMap.getMappingType();
            }
        }
        return "NULL";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        int n3;
        String string = "";
        String string2 = "";
        string = n2 == 0 ? (String)object : (String)this.getValueAt(n, 0);
        string2 = n2 == 1 ? (String)object : (String)this.getValueAt(n, 1);
        PredicateMap predicateMap = (PredicateMap)this.node.getPredicateMaps().get(n);
        if (string2.equals(R2RMLArb.getString("CONSTANT")) && predicateMap.isShortcut()) {
            this.node.getPredicateMaps().get(n).setValue(string);
        }
        if (string2.equals(R2RMLArb.getString("CONSTANT")) && !predicateMap.isShortcut()) {
            this.node.removeChild(predicateMap);
            predicateMap = new PredicateMap("_:" + RDFStringUtils.generateRandomId());
            this.node.addChildEdge("<http://www.w3.org/ns/r2rml#predicateMap>", predicateMap);
            predicateMap.addChildEdge("<http://www.w3.org/ns/r2rml#constant>", new R2RMLNode(string));
        }
        if (string2.equals(R2RMLArb.getString("TEMPLATE"))) {
            n3 = this.node.removeChild(predicateMap);
            predicateMap = new PredicateMap("_:" + RDFStringUtils.generateRandomId());
            this.node.addChildEdge("<http://www.w3.org/ns/r2rml#predicateMap>", predicateMap, n3);
            predicateMap.addChildEdge("<http://www.w3.org/ns/r2rml#template>", new StringTemplateNode(string));
        }
        if (string2.equals(R2RMLArb.getString("COLUMN"))) {
            n3 = this.node.removeChild(predicateMap);
            predicateMap = new PredicateMap("_:" + RDFStringUtils.generateRandomId());
            this.node.addChildEdge("<http://www.w3.org/ns/r2rml#predicateMap>", predicateMap, n3);
            predicateMap.addChildEdge("<http://www.w3.org/ns/r2rml#column>", new ColumnNameNode(string));
        }
        this.fireTableDataChanged();
    }

    public void removeRow(int n) {
        R2RMLNode r2RMLNode = this.node.getPredicateMaps().get(n);
        this.node.removeChild(r2RMLNode);
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public String getColumnName(int n) {
        return this.headers[n];
    }
}

