/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.editor.predicate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.sql.Connection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.editor.objectmap.TermMapTypeCellEditor;
import oracle.dbtools.rdfgraph.r2rml.editor.objectmap.TermMapValueCellRenderer;
import oracle.dbtools.rdfgraph.r2rml.editor.predicate.PredicateMapTableModel;
import oracle.dbtools.rdfgraph.r2rml.editor.predicate.PredicateMapValueCellEditor;
import oracle.dbtools.rdfgraph.r2rml.language.PredicateMap;
import oracle.dbtools.rdfgraph.r2rml.language.PredicateObjectMap;
import oracle.dbtools.rdfgraph.r2rml.language.TriplesMapNode;
import oracle.javatools.icons.OracleIcons;

public class PredicateMapListEditor
extends JPanel {
    private static final String PMAP_LIST_TITLE = R2RMLArb.getString("PredicateMapListEditor.PREDICATE_MAP_S_");
    TriplesMapNode tmap;
    PredicateObjectMap node;
    Connection connection;
    private JTable table;
    private PredicateMapTableModel tmodel;
    private JToolBar toolbar;
    public static final int VALUE_COL_IDX = 0;
    public static final int TYPE_COL_IDX = 1;
    public static final int TMAP_PROPS_COL_IDX = 2;

    public PredicateMapListEditor(TriplesMapNode triplesMapNode, PredicateObjectMap predicateObjectMap, Connection connection) {
        this.tmap = triplesMapNode;
        this.node = predicateObjectMap;
        this.connection = connection;
        this.setBorder(BorderFactory.createTitledBorder(PMAP_LIST_TITLE));
        this.setLayout(new BorderLayout());
        this.initUI();
    }

    private void initUI() {
        this.table = this.createTable();
        this.toolbar = this.createToolBar();
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)this.toolbar, "North");
    }

    private JTable createTable() {
        this.tmodel = new PredicateMapTableModel(this.node);
        this.table = new JTable(this.tmodel);
        this.table.setPreferredScrollableViewportSize(this.table.getPreferredSize());
        this.table.getColumnModel().getColumn(0).setPreferredWidth(250);
        this.table.setAutoResizeMode(3);
        this.table.setFillsViewportHeight(true);
        this.table.getColumnModel().getColumn(1).setCellEditor(new TermMapTypeCellEditor());
        this.table.getColumnModel().getColumn(0).setCellEditor(new PredicateMapValueCellEditor(this.tmap, this.connection));
        this.table.getColumnModel().getColumn(0).setCellRenderer(new TermMapValueCellRenderer());
        this.table.setPreferredScrollableViewportSize(new Dimension(this.table.getPreferredScrollableViewportSize().width, this.table.getPreferredScrollableViewportSize().height + 35));
        return this.table;
    }

    private JToolBar createToolBar() {
        this.toolbar = new JToolBar();
        JButton jButton = new JButton(R2RMLArb.getString("PredicateMapListEditor.ADD_PREDICATE_MAP"), OracleIcons.getIcon((String)"add.png"));
        jButton.addActionListener(actionEvent -> {
            this.node.addChildEdge("<http://www.w3.org/ns/r2rml#predicate>", new PredicateMap("<urn:somePredicate>"));
            this.tmodel.fireTableDataChanged();
            int n = this.node.getPredicateMaps().size();
            boolean bl = this.table.editCellAt(n - 1, 0);
            if (bl) {
                boolean bl2 = false;
                boolean bl3 = false;
                this.table.changeSelection(n - 1, 0, bl2, bl3);
                this.table.requestFocusInWindow();
            }
        });
        JButton jButton2 = new JButton(RdfgraphArb.getString("DELETE"), OracleIcons.getIcon((String)"delete.png"));
        jButton2.addActionListener(actionEvent -> {
            if (this.table.getSelectedRow() != -1) {
                int n = this.table.getSelectedRow();
                this.table.clearSelection();
                if (this.table.isEditing()) {
                    this.table.getCellEditor().stopCellEditing();
                }
                this.tmodel.removeRow(n);
            }
        });
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.add(jButton);
        this.toolbar.add(jButton2);
        return this.toolbar;
    }
}

