/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.editor.pomap;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.sql.Connection;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.editor.objectmap.ObjectMapListEditor;
import oracle.dbtools.rdfgraph.r2rml.editor.pomap.POMapGraphMapListEditor;
import oracle.dbtools.rdfgraph.r2rml.editor.predicate.PredicateMapListEditor;
import oracle.dbtools.rdfgraph.r2rml.language.PredicateObjectMap;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLTree;
import oracle.dbtools.rdfgraph.r2rml.language.TriplesMapNode;
import oracle.javatools.icons.OracleIcons;

public class POMapNodeEditor
extends JPanel {
    private static final String PO_MAP_EDITOR_TITLE = R2RMLArb.getString("POMapNodeEditor.PREDICATE_OBJECT_MAP");
    private static final String POMAP_ID = R2RMLArb.getString("POMapNodeEditor.PREDICATE_OBJECT_MAP_ID");
    private static final String LBL_NODE_ID = R2RMLArb.getString("POMapNodeEditor.NODE_ID_");
    final int COLLAPSED_HEIGHT = 50;
    Connection connection;
    JTextField two;
    R2RMLTree tree;
    TriplesMapNode tmap;
    JTable table;
    PredicateObjectMap node;
    PredicateMapListEditor predicateMapListPanel;
    JPanel objectMapPanel;
    JPanel predDynEditor;
    JPanel objDynEditor;
    JComboBox predMappingType;
    JComboBox objMappingType;
    CardLayout predCardLayout;
    CardLayout objCardLayout;

    public void setNode(PredicateObjectMap predicateObjectMap) {
        this.node = predicateObjectMap;
    }

    public PredicateObjectMap getNode() {
        return this.node;
    }

    public POMapNodeEditor(R2RMLTree r2RMLTree, TriplesMapNode triplesMapNode, PredicateObjectMap predicateObjectMap, Connection connection, JTable jTable) {
        this.tree = r2RMLTree;
        this.tmap = triplesMapNode;
        this.node = predicateObjectMap;
        this.connection = connection;
        this.table = jTable;
        this.setLayout(new BoxLayout(this, 1));
        this.initUI();
    }

    private void initUI() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel(LBL_NODE_ID);
        jPanel.add(jLabel);
        JTextField jTextField = new JTextField(this.node.getValue());
        jLabel.setLabelFor(jTextField);
        jTextField.setEditable(false);
        jPanel.add(jTextField);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 60));
        this.add(jPanel);
        this.predicateMapListPanel = this.getPredicateMapPanel();
        this.objectMapPanel = this.getObjectMapPanel();
        Container container = new Container();
        container.setLayout(new GridLayout(1, 2));
        container.add(this.predicateMapListPanel);
        container.add(this.objectMapPanel);
        this.add(container);
        POMapGraphMapListEditor pOMapGraphMapListEditor = new POMapGraphMapListEditor(this.tmap, this.node, this.connection);
        this.add(pOMapGraphMapListEditor);
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton("OK", OracleIcons.getIcon((String)"check.png"));
        jButton.addActionListener(actionEvent -> {
            this.table.clearSelection();
            if (this.table.isEditing()) {
                this.table.getCellEditor().stopCellEditing();
                int n = this.table.getRowCount();
                for (int i = 0; i < n; ++i) {
                    this.table.setRowHeight(i, 50);
                }
            }
        });
        jPanel2.add(jButton);
        this.add((Component)jPanel2, "South");
    }

    private PredicateMapListEditor getPredicateMapPanel() {
        this.predicateMapListPanel = new PredicateMapListEditor(this.tmap, this.node, this.connection);
        return this.predicateMapListPanel;
    }

    private JPanel getObjectMapPanel() {
        this.objectMapPanel = new ObjectMapListEditor(this.tree, this.tmap, this.node, this.connection);
        return this.objectMapPanel;
    }
}

