/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.editor.objectmap;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.sql.Connection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.editor.objectmap.TermMapPopupDialog;
import oracle.dbtools.rdfgraph.r2rml.language.ObjectMapNode;
import oracle.dbtools.rdfgraph.r2rml.language.PredicateObjectMap;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLNode;
import oracle.dbtools.rdfgraph.r2rml.language.TermMapNode;
import oracle.dbtools.rdfgraph.r2rml.language.TriplesMapNode;
import oracle.dbtools.rdfgraph.utils.RDFPrefixManager;
import oracle.javatools.dialogs.MessageDialog;

public class TermMapPropertiesCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    final int TMAP_TYPE_COL = 1;
    final int TMAP_PROPS_COL = 2;
    JTextField textEditor;
    Connection connection;
    SqlComboBoxActionControl sqlSelectCol;
    CardLayout cardLayout;
    String editorValue = "";
    String tmtype;
    TriplesMapNode tmap;
    PredicateObjectMap pmap;
    private JButton editorComponent;
    TermMapPopupDialog popup;
    private String currentText = "";

    public TermMapPropertiesCellEditor(TriplesMapNode triplesMapNode, PredicateObjectMap predicateObjectMap, Connection connection) {
        this.connection = connection;
        this.tmap = triplesMapNode;
        this.pmap = predicateObjectMap;
        this.editorComponent = new JButton();
        this.editorComponent.setBackground(Color.white);
        this.editorComponent.setBorderPainted(false);
        this.editorComponent.setContentAreaFilled(false);
        this.editorComponent.setFocusable(false);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, final int n, int n2) {
        this.tmtype = (String)jTable.getValueAt(n, 1);
        if (this.tmtype.equals(R2RMLArb.getString("REFERENCE"))) {
            MessageDialog.error((Component)SwingUtilities.getRoot(jTable), (Object)R2RMLArb.getString("TermMapPropertiesCellEditor.THE_TERM_MAP_IS_A_REFERENCING_OBJECT_MAP"), (String)R2RMLArb.getString("TermMapPropertiesCellEditor.INVALID_OPERATION"), null);
            return this.editorComponent;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TermMapPropertiesCellEditor.this.popup = new TermMapPopupDialog(TermMapPropertiesCellEditor.this.connection, TermMapPropertiesCellEditor.this.tmap, (TermMapNode)TermMapPropertiesCellEditor.this.pmap.getObjectMaps().get(n));
                TermMapPropertiesCellEditor.this.popup.setLocationRelativeTo(SwingUtilities.getWindowAncestor(TermMapPropertiesCellEditor.this.editorComponent));
                TermMapPropertiesCellEditor.this.popup.setVisible(true);
                TermMapPropertiesCellEditor.this.fireEditingStopped();
            }
        });
        ObjectMapNode objectMapNode = (ObjectMapNode)this.pmap.getObjectMaps().get(n);
        List<R2RMLNode> list = objectMapNode.getTermMapProperties();
        if (list.isEmpty()) {
            this.currentText = R2RMLArb.getString("TermMapPropertiesCellEditor._DEFAULT_");
        } else {
            List list2 = list.stream().map(r2RMLNode -> RDFPrefixManager.shortenURI(r2RMLNode.getValue())).collect(Collectors.toList());
            this.currentText = String.join((CharSequence)", ", list2);
        }
        this.editorComponent.setText(this.currentText);
        return this.editorComponent;
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentText;
    }
}

