/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.xml;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.util.NullArgumentException;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.analyzer.IssueReport;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.SuppressionScheme;
import oracle.jdeveloper.audit.extension.ExtensionResource;
import oracle.jdeveloper.audit.xml.XmlModelAdapter;
import oracle.jdevimpl.audit.xml.XmlSuppressionAnalyzerBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class XmlSuppressionAnalyzer
extends Analyzer {
    static final String TARGET = "audit";
    static final String DIRECTIVE = "suppress";
    static final String ID = "id";
    @ExtensionResource(value="oracle.ide.xml.suppress-error")
    private Rule SUPPRESS_ERROR;
    @ExtensionResource(value="oracle.ide.xml.suppress-issues")
    private SuppressionScheme SUPPRESS;

    public void enter(AuditContext context, Document element) {
        context.markSuppressionLimit();
    }

    public void exit(AuditContext context, Document element) {
    }

    public void enter(AuditContext context, Element element) {
        context.markSuppressionLimit();
    }

    public void exit(AuditContext context, Element element) {
        context.markSuppressionLimit();
    }

    public void enter(AuditContext context, ProcessingInstruction construct) {
        if (TARGET.equals(construct.getTarget())) {
            LinkedHashSet<String> ids = new LinkedHashSet<String>();
            ArrayList<ParseError> errors = new ArrayList<ParseError>();
            XmlModelAdapter model = (XmlModelAdapter)context.getModel();
            XmlSuppressionAnalyzer.parseAuditProcessingInstruction((ReadTextBuffer)model.getTextBuffer(), context.getOffset(), context.getLength(), ids, errors);
            Node parent = construct.getParentNode();
            for (String id : ids) {
                context.report(this.SUPPRESS, id, (Object)parent);
            }
            for (ParseError error : errors) {
                IssueReport report = context.report(this.SUPPRESS_ERROR, context.getModel().getLocation(error.getOffset(), error.getLength()));
                report.addParameter("message", (Object)XmlSuppressionAnalyzerBundle.format(error.getKey() + ".message", error.getArguments()));
                report.addParameter("subissue", (Object)error.getKey());
            }
        }
    }

    static void parseAuditProcessingInstruction(ReadTextBuffer buffer, int offset, int length, Set<String> ids, List<ParseError> errors) {
        Token token = new Token(buffer, offset, length);
        token.consume();
        if (!token.isType(Token.Type.PI_BEGIN)) {
            errors.add(new ParseError(token.begin(), token.end(), "token-expected", new String[]{token.text(), "<?"}));
            return;
        }
        token.consume();
        if (!token.isText(TARGET)) {
            errors.add(new ParseError(token.begin(), token.end(), "token-expected", new String[]{token.text()}));
            return;
        }
        token.consume();
        if (!token.isText(DIRECTIVE)) {
            errors.add(new ParseError(token.begin(), token.end(), "token-expected", new String[]{token.text(), DIRECTIVE}));
            return;
        }
        block4: while (true) {
            token.consume();
            switch (token.type()) {
                case NAME: {
                    if (ids.add(token.text())) continue block4;
                    errors.add(new ParseError(token.begin(), token.end(), "name-duplicated", new String[]{token.text()}));
                    continue block4;
                }
                case PI_END: {
                    if (ids.isEmpty()) {
                        errors.add(new ParseError(token.begin(), token.begin(), "name-required", new String[0]));
                    }
                    token.consume();
                    if (!token.isType(Token.Type.END)) {
                        throw new IllegalArgumentException("unexpected text after processing instruction at " + token.begin() + ": " + token.text());
                    }
                    return;
                }
            }
            break;
        }
        String key = ids.isEmpty() ? "name-expected" : "name-or-end-expected";
        errors.add(new ParseError(token.begin(), token.end(), key, new String[]{token.text()}));
    }

    private static class Token {
        private ReadTextBuffer buffer;
        private int position;
        private int endPosition;
        private String token;
        private Type type;
        private int begin;

        public Token(ReadTextBuffer buffer, int offset, int length) {
            this.buffer = buffer;
            this.position = offset;
            this.endPosition = offset + length;
        }

        private Type type() {
            if (this.token == null) {
                throw new IllegalStateException("null token");
            }
            return this.type;
        }

        private boolean isType(Type type) {
            if (type == null) {
                throw new NullArgumentException();
            }
            return this.type().equals((Object)type);
        }

        private boolean isText(String text) {
            if (text == null) {
                throw new NullArgumentException();
            }
            return this.text().equals(text);
        }

        private String text() {
            if (this.token == null) {
                throw new IllegalStateException("null token");
            }
            return this.token;
        }

        private int begin() {
            if (this.token == null) {
                throw new IllegalStateException("null token");
            }
            return this.begin;
        }

        private int length() {
            if (this.token == null) {
                throw new IllegalStateException("null token");
            }
            return this.token.length();
        }

        private int end() {
            if (this.token == null) {
                throw new IllegalStateException("null token");
            }
            return this.begin + this.token.length();
        }

        private void consume() {
            while (this.position < this.endPosition && Character.isWhitespace(this.buffer.getChar(this.position))) {
                ++this.position;
            }
            int remainder = this.endPosition - this.position;
            if (remainder == 0) {
                this.token = "";
                this.type = Type.END;
                this.begin = this.position;
                return;
            }
            char c = this.buffer.getChar(this.position);
            switch (c) {
                case '<': {
                    if (remainder > 1 && this.buffer.getChar(this.position + 1) == '?') {
                        this.token = "<?";
                        this.type = Type.PI_BEGIN;
                        break;
                    }
                    if (remainder > 2 && this.buffer.getChar(this.position + 1) == '-' && this.buffer.getChar(this.position + 2) == '-') {
                        this.token = "<--";
                        this.type = Type.COMMENT_BEGIN;
                        break;
                    }
                    this.token = "<";
                    this.type = Type.TAG_BEGIN;
                    break;
                }
                case '?': {
                    if (remainder > 1 && this.buffer.getChar(this.position + 1) == '>') {
                        this.token = "?>";
                        this.type = Type.PI_END;
                        break;
                    }
                    this.token = "?";
                    this.type = Type.OTHER;
                    break;
                }
                case '-': {
                    if (remainder > 2 && this.buffer.getChar(this.position + 1) == '-' && this.buffer.getChar(this.position + 2) == '>') {
                        this.token = "-->";
                        this.type = Type.COMMENT_END;
                        break;
                    }
                }
                case '$': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    int count;
                    block10: for (count = 1; count < remainder; ++count) {
                        switch (this.buffer.getChar(this.position + count)) {
                            case '$': 
                            case '-': 
                            case '.': 
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': 
                            case ':': 
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': 
                            case 'G': 
                            case 'H': 
                            case 'I': 
                            case 'J': 
                            case 'K': 
                            case 'L': 
                            case 'M': 
                            case 'N': 
                            case 'O': 
                            case 'P': 
                            case 'Q': 
                            case 'R': 
                            case 'S': 
                            case 'T': 
                            case 'U': 
                            case 'V': 
                            case 'W': 
                            case 'X': 
                            case 'Y': 
                            case 'Z': 
                            case '_': 
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': 
                            case 'g': 
                            case 'h': 
                            case 'i': 
                            case 'j': 
                            case 'k': 
                            case 'l': 
                            case 'm': 
                            case 'n': 
                            case 'o': 
                            case 'p': 
                            case 'q': 
                            case 'r': 
                            case 's': 
                            case 't': 
                            case 'u': 
                            case 'v': 
                            case 'w': 
                            case 'x': 
                            case 'y': 
                            case 'z': {
                                continue block10;
                            }
                        }
                    }
                    this.token = this.buffer.getString(this.position, count);
                    this.type = Type.NAME;
                    break;
                }
                default: {
                    this.token = String.valueOf(c);
                    this.type = Type.OTHER;
                }
            }
            this.begin = this.position;
            this.position += this.token.length();
        }

        public static enum Type {
            TAG_BEGIN,
            TAG_END,
            PI_BEGIN,
            PI_END,
            COMMENT_BEGIN,
            COMMENT_END,
            NAME,
            OTHER,
            END;

        }
    }

    static class ParseError {
        private final String key;
        private final Object[] arguments;
        private final int offset;
        private final int endOffset;

        private ParseError(int offset, int endOffset, String key, String ... arguments) {
            this.key = arguments.length > 0 && arguments[0].isEmpty() && key.endsWith("-expected") ? key + "-eob" : key;
            this.arguments = arguments;
            this.offset = offset;
            this.endOffset = endOffset;
        }

        private String getKey() {
            return this.key;
        }

        private Object[] getArguments() {
            return this.arguments;
        }

        int getOffset() {
            return this.offset;
        }

        int getEndOffset() {
            return this.endOffset;
        }

        int getLength() {
            return this.endOffset - this.offset;
        }
    }
}

