/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.xml;

import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import javax.swing.Icon;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.selection.XmlSelectionElement;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.DuplexIterator;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.WriteLockRequestListener;
import oracle.javatools.util.ArrayIterator;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.CompositeDependency;
import oracle.jdeveloper.audit.model.ContainerModelAdapter;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.LockPolicy;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdeveloper.audit.model.TextFileModelAdapter;
import oracle.jdeveloper.audit.xml.XmlModelDependency;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class XmlModelAdapter
extends TextFileModelAdapter {
    private XmlContext xmlContext;
    private int activeCount;
    private static final Map<Node, Boolean> nodeContextExistedLastAttempt = new WeakHashMap<Node, Boolean>();
    private final int[] offsets = new int[2];
    private static final Log LOG = new Log(new String[]{"xmladapter", "xmldependency"});

    XmlModelAdapter(ModelFactory factory, ModelType type, ContainerModelAdapter workspace, ContainerModelAdapter project, ContainerModelAdapter packag, XMLSourceNode node, URL url) {
        super(factory, type, workspace, project, packag, (Node)node, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquireReadLock(LockPolicy policy) throws InterruptedException {
        XmlModel xmlModel;
        JDevXmlContext xmlContext;
        ReadWriteLock lock = this.getLock();
        Context ideContext = this.getIdeContext();
        if (policy.isRetryPreferred()) {
            boolean contextMaybeExistedLastAttempt;
            boolean contextExists = JDevXmlContext.hasXmlContextBeenCreated(ideContext);
            boolean bl = contextMaybeExistedLastAttempt = nodeContextExistedLastAttempt.get(this.getNode()) != Boolean.FALSE;
            if (!contextExists) {
                if (contextMaybeExistedLastAttempt) {
                    nodeContextExistedLastAttempt.put(this.getNode(), false);
                    LOG.trace("XmlContext for {0} not created: cancelling to retry later", (Object)this);
                    throw new InterruptedException("cancelling to retry later: XML context not created");
                }
                nodeContextExistedLastAttempt.remove(this.getNode());
                LOG.trace("XmlContext for {0} not created: forcing creation", (Object)this);
            }
            try {
                xmlContext = JDevXmlContext.getXmlContextOrThrow(ideContext);
                xmlModel = xmlContext.getModel();
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                throw this.createModelAccessError(e);
            }
            lock.readLockInterruptibly();
            try {
                if (xmlModel.getDomModel().needsReparse()) {
                    LOG.trace("DOM model for {0} needs reparse: cancelling to retry later", (Object)this);
                    throw new InterruptedException("cancelling to retry later: DOM model needs reparse");
                }
                xmlModel.acquireReadLock();
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                throw this.createModelAccessError(e);
            }
            finally {
                lock.readUnlock();
            }
        }
        try {
            xmlContext = JDevXmlContext.getXmlContextOrThrow(ideContext);
            xmlModel = xmlContext.getModel();
            xmlModel.acquireReadLock();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.createModelAccessError(e);
        }
        if (policy.getLockListener() != null && lock.addWriteLockRequestListener(policy.getLockListener())) {
            lock.removeWriteLockRequestListener(policy.getLockListener());
            xmlModel.releaseReadLock();
            throw new InterruptedException("self-cancelling: write lock request waiting");
        }
        XmlModelAdapter xmlModelAdapter = this;
        synchronized (xmlModelAdapter) {
            if (this.activeCount++ == 0) {
                this.xmlContext = xmlContext;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseReadLock(WriteLockRequestListener listener) {
        XmlModel xmlModel = this.xmlContext.getModel();
        XmlModelAdapter xmlModelAdapter = this;
        synchronized (xmlModelAdapter) {
            if (--this.activeCount == 0) {
                this.xmlContext = null;
            }
        }
        if (listener != null) {
            this.getLock().removeWriteLockRequestListener(listener);
        }
        xmlModel.releaseReadLock();
    }

    public void verifyReadTransaction() {
        super.verifyReadTransaction();
        assert (this.xmlContext != null) : "no read transaction active on " + (Object)((Object)this);
    }

    public Object getRootHook() {
        return this.getXmlModel().getDocument();
    }

    public synchronized XmlModel getXmlModel() {
        this.verifyReadTransaction();
        return this.xmlContext.getModel();
    }

    public Location[] getElementLocations(oracle.ide.model.Element element) {
        LOG.trace("getting element location for {0}", (Object)element);
        this.verifyReadTransaction();
        if (element instanceof XMLSourceNode) {
            XMLSourceNode node = (XMLSourceNode)element;
            if (node.getURL().equals(this.getUrl())) {
                return new Location[]{this.getLocation()};
            }
        } else if (element instanceof XmlSelectionElement) {
            Location[] locations;
            org.w3c.dom.Node[] nodes = this.getXmlModel().getSelection().getSelectedNodesArray();
            if (nodes.length > 0) {
                locations = new Location[nodes.length];
                for (int i = 0; i < nodes.length; ++i) {
                    locations[i] = this.getLocation(nodes[i]);
                }
            } else {
                locations = new Location[]{this.getLocation()};
            }
            return locations;
        }
        return null;
    }

    public Dependency getDependency() {
        CompositeDependency dependency = new CompositeDependency();
        dependency.addDependency(super.getDependency());
        dependency.addDependency((Dependency)new XmlModelDependency((XMLSourceNode)this.getNode(), this.getProject(), this.getWorkspace()));
        return dependency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getLocation(Object construct) {
        org.w3c.dom.Node node;
        DomModel model;
        Document root;
        LOG.trace("getting location of {0}", construct);
        this.verifyReadTransaction();
        if (construct instanceof Document) {
            DomModel model2 = this.getXmlModel().getDomModel();
            if (construct == model2.getDocument()) {
                return this.getLocation();
            }
        } else if (construct instanceof org.w3c.dom.Node && ((root = (model = this.getXmlModel().getDomModel()).getDocument()) == (node = (org.w3c.dom.Node)construct) || root == node.getOwnerDocument())) {
            int[] nArray = this.offsets;
            synchronized (this.offsets) {
                model.getTextOffsets(node, this.offsets);
                int start = this.offsets[0];
                int end = this.offsets[1];
                // ** MonitorExit[var7_6] (shouldn't be in output)
                return this.getLocation(start, end - start);
            }
        }
        return null;
    }

    public Iterator getContainedConstructs(Object construct) {
        LOG.trace("getting contained constructs of {0}", construct);
        this.verifyReadTransaction();
        org.w3c.dom.Node node = (org.w3c.dom.Node)construct;
        NamedNodeMap attributes = node.getAttributes();
        int attributeCount = attributes != null ? attributes.getLength() : 0;
        switch (attributeCount) {
            case 0: {
                return new ChildIterator(node);
            }
            case 1: {
                Attr attribute = (Attr)attributes.item(0);
                if (!this.getXmlModel().getDomModel().isUnspecifiedAttribute(attribute)) {
                    return new DuplexIterator((Iterator)new ArrayIterator((Object[])new org.w3c.dom.Node[]{attribute}), (Iterator)new ChildIterator(node));
                }
                LOG.trace("discarding attribute {0}", (Object)attribute);
                return new ChildIterator(node);
            }
        }
        Object[] sortables = new Sortable[attributeCount];
        int count = 0;
        DomModel model = this.getXmlModel().getDomModel();
        int[] offsets = new int[2];
        for (int i = 0; i < attributeCount; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            model.getTextOffsets((org.w3c.dom.Node)attribute, offsets);
            int offset = offsets[0];
            if (offset >= 0) {
                sortables[count++] = new Sortable(attribute, offset);
                continue;
            }
            LOG.trace("discarding attribute {0}", (Object)attribute);
        }
        Arrays.sort(sortables, 0, count);
        Object[] nodes = new org.w3c.dom.Node[count];
        for (int i = 0; i < count; ++i) {
            nodes[i] = ((Sortable)sortables[i]).attribute;
        }
        return new DuplexIterator((Iterator)new ArrayIterator(nodes), (Iterator)new ChildIterator(node));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object construct, Location location) {
        if (construct instanceof Document) {
            assert (location != null);
            assert (this.getFactory() == location.getModel().getFactory()) : "generation mismatch: " + (Object)((Object)this) + " - " + location;
            assert (this == location.getModel());
            this.verifyReadTransaction();
            return true;
        }
        if (construct instanceof org.w3c.dom.Node) {
            assert (location != null);
            assert (this.getFactory() == location.getModel().getFactory()) : "generation mismatch: " + (Object)((Object)this) + " - " + location;
            assert (this == location.getModel());
            this.verifyReadTransaction();
            DomModel model = this.getXmlModel().getDomModel();
            int[] nArray = this.offsets;
            synchronized (this.offsets) {
                model.getTextOffsets((org.w3c.dom.Node)construct, this.offsets);
                int start = this.offsets[0];
                int end = this.offsets[1];
                // ** MonitorExit[var6_4] (shouldn't be in output)
                return XmlModelAdapter.contains((int)start, (int)(end - start), (Location)location);
            }
        }
        return super.contains(construct, location);
    }

    public Location getFocusLocation(Object construct, Location location) {
        LOG.trace("getting focus location of {0}", construct);
        if (construct instanceof Document) {
            int offset;
            Element element = ((Document)construct).getDocumentElement();
            if (element == null) {
                return super.getFocusLocation(construct, location);
            }
            assert (location != null);
            assert (this.getFactory() == location.getModel().getFactory()) : "generation mismatch: " + (Object)((Object)this) + " - " + location;
            assert (this == location.getModel());
            assert (location.isRoot() || location.equals((Object)this.getLocation(construct))) : "location " + location + "; construct location " + this.getLocation(construct) + "; construct " + construct;
            this.verifyReadTransaction();
            ModelAdapter model = location.getModel();
            location = model.getLocation((Object)element);
            TextBuffer buffer = this.getTextBuffer();
            for (offset = location.getOffset() + 1; offset < buffer.getLength() && Character.isWhitespace(buffer.getChar(offset)); ++offset) {
            }
            String name = element.getTagName();
            int length = name.length();
            return model.getLocation(offset, length);
        }
        if (construct instanceof Element) {
            int offset;
            assert (location != null);
            assert (this.getFactory() == location.getModel().getFactory()) : "generation mismatch: " + (Object)((Object)this) + " - " + location;
            assert (this == location.getModel());
            assert (location.equals((Object)this.getLocation(construct))) : "location " + location + "; construct location " + this.getLocation(construct) + "; construct " + construct;
            this.verifyReadTransaction();
            ModelAdapter model = location.getModel();
            TextBuffer buffer = this.getTextBuffer();
            for (offset = location.getOffset() + 1; offset < buffer.getLength() && Character.isWhitespace(buffer.getChar(offset)); ++offset) {
            }
            Element element = (Element)construct;
            String name = element.getTagName();
            int length = name.length();
            return model.getLocation(offset, length);
        }
        return super.getFocusLocation(construct, location);
    }

    public Object getLabel(Object construct) {
        if (construct instanceof Document) {
            return URLFileSystem.getFileName((URL)this.getUrl());
        }
        return this.getXmlModel().getXmlMetadataResolver().getMediumDisplayName((org.w3c.dom.Node)construct);
    }

    public Object getSummary(Object construct) {
        if (construct instanceof Document) {
            return URLFileSystem.getPlatformPathName((URL)this.getUrl());
        }
        return this.getXmlModel().getXmlMetadataResolver().getLongDisplayName((org.w3c.dom.Node)construct);
    }

    public Icon getIcon(Object construct) {
        if (construct instanceof Document) {
            return this.getNode().getIcon();
        }
        return this.getXmlModel().getXmlMetadataResolver().getSmallIcon((org.w3c.dom.Node)construct);
    }

    private static class ChildIterator
    implements Iterator<org.w3c.dom.Node> {
        private org.w3c.dom.Node next;

        public ChildIterator(org.w3c.dom.Node node) {
            this.next = node.getFirstChild();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public org.w3c.dom.Node next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            org.w3c.dom.Node result = this.next;
            this.next = this.next.getNextSibling();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Sortable
    implements Comparable {
        private Attr attribute;
        private int offset;

        public Sortable(Attr attribute, int offset) {
            this.attribute = attribute;
            this.offset = offset;
        }

        public int compareTo(Object object) {
            this.offset = ((Sortable)object).offset;
            return this.offset;
        }
    }
}

