/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.xmlComponent;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentLayoutOption;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentModel;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.gui.jdev.xmlComponent.AbstractXmlPanelWrapper;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlHeader;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlHeaderOption;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlPanelLayoutPolicy;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlSectionHeader;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlTabHeader;
import oracle.bali.xml.gui.swing.xmlComponent.XmlContextualActionButton;
import oracle.bali.xml.gui.swing.xmlComponent.XmlLayoutOption;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderPanel;

public abstract class AbstractXmlPanelLayoutPolicy
implements XmlPanelLayoutPolicy {
    private AbstractXmlPanelWrapper _xmlPanelWrapper;
    private int _labeledComponentAfterPaddingOverride = 20;
    private XmlSectionHeader _currSectionHeader;
    private XmlTabHeader _currTabHeader;

    public AbstractXmlPanelLayoutPolicy(AbstractXmlPanelWrapper xmlPanelWrapper) {
        this._xmlPanelWrapper = xmlPanelWrapper;
        this.setLayout(this.createLayout());
    }

    @Override
    public LayoutManager getLayout() {
        return this.getPanel().getLayout();
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        this.getPanel().setLayout(layoutManager);
    }

    @Override
    public LayoutManager createLayout() {
        String topInset = String.valueOf(10);
        String leftInset = String.valueOf(8);
        String bottomInset = String.valueOf(8);
        String rightInset = String.valueOf(8);
        return new MigLayout(new LC().insets(topInset, leftInset, bottomInset, rightInset).minWidth("1px"), new AC(), new AC().gap(String.valueOf(6)));
    }

    @Override
    public JPanel addPageHeader(JPanel container, XmlHeaderOption headerOption) {
        JPanel hp = this.buildHeaderPanel(container, Header.Level.PAGE, headerOption.getHeaderLabel(), headerOption.getDisplayBorder(), headerOption.getIndent(), headerOption.getExpanded(), headerOption.getIcon(), headerOption.getInstructionalText());
        return hp;
    }

    @Override
    public XmlHeader addSectionHeader(JPanel container, XmlHeaderOption headerOption) {
        this._currSectionHeader = (XmlSectionHeader)new XmlSectionHeader(this.getPanel()).addHeader(container, headerOption);
        return this._currSectionHeader;
    }

    public JPanel getSectionHeaderPanel() {
        if (this._currSectionHeader == null) {
            return null;
        }
        return (JPanel)this._currSectionHeader.getHeaderContainer();
    }

    @Override
    public XmlHeader addTabHeader(JPanel container, XmlHeaderOption headerOption) {
        if (this._currTabHeader == null) {
            this._currTabHeader = new XmlTabHeader(this.getPanel());
        }
        this._currTabHeader.addHeader(container, headerOption);
        return this._currTabHeader;
    }

    @Override
    public JTabbedPane getTabHeaderTabbedPane() {
        if (this._currTabHeader == null) {
            return null;
        }
        if (!(this._currTabHeader instanceof XmlTabHeader)) {
            return null;
        }
        return this._currTabHeader.getTabbedPane();
    }

    @Override
    public void setTabHeader(XmlTabHeader xmlTabHeader) {
        this._currTabHeader = xmlTabHeader;
    }

    @Override
    public void add(JPanel container, XmlComponentWrapper xmlComponentWrapper) {
        this.add(container, xmlComponentWrapper, (XmlComponentLayoutOption)new XmlLayoutOption());
    }

    @Override
    public void add(JPanel container, XmlComponentWrapper xmlComponentWrapper, XmlComponentLayoutOption layoutOption) {
        if (layoutOption.getAddLabel()) {
            this.addLabeledComponent(container, xmlComponentWrapper, layoutOption);
        } else {
            this.addNonLabeledComponent(container, xmlComponentWrapper, layoutOption);
        }
    }

    @Override
    public void addLabeledComponent(JPanel container, XmlComponentWrapper xmlComponentWrapper, XmlComponentLayoutOption layoutOption) {
        Component wrappedComponent = xmlComponentWrapper.getXmlWrappedComponent().getWrappedComponent();
        this.addLabel(container, xmlComponentWrapper, layoutOption);
        if (this.getLabeledComponentAfterPaddingOverride() > 0) {
            layoutOption.setRightMargin(this.getLabeledComponentAfterPaddingOverride());
        }
        if (layoutOption.getShowContextualActionButton()) {
            container.add(XmlContextualActionButton.addContextualActionButton((XmlComponentWrapper)xmlComponentWrapper, null), (CC)layoutOption.getComponentConstraint());
        } else {
            container.add(wrappedComponent, (CC)layoutOption.getComponentConstraint());
        }
    }

    @Override
    public void addNonLabeledComponent(JPanel container, XmlComponentWrapper xmlComponentWrapper, XmlComponentLayoutOption layoutOption) {
        if (layoutOption.getShowContextualActionButton()) {
            this.addComponentWithContextualAction(container, xmlComponentWrapper, layoutOption);
        } else {
            this.addComponent(container, xmlComponentWrapper, layoutOption);
        }
    }

    @Override
    public void addComponent(JPanel container, XmlComponentWrapper xmlComponentWrapper, XmlComponentLayoutOption layoutOption) {
        Component wrappedComponent = xmlComponentWrapper.getXmlWrappedComponent().getWrappedComponent();
        container.add(wrappedComponent, (CC)layoutOption.getComponentConstraint());
    }

    @Override
    public void addComponentWithContextualAction(JPanel container, XmlComponentWrapper xmlComponentWrapper, XmlComponentLayoutOption layoutOption) {
        container.add(XmlContextualActionButton.addContextualActionButton((XmlComponentWrapper)xmlComponentWrapper, null), (CC)layoutOption.getComponentConstraint());
    }

    @Override
    public void addLabel(JPanel container, XmlComponentWrapper xmlComponentWrapper, XmlComponentLayoutOption layoutOption) {
        Component wrappedComponent = xmlComponentWrapper.getXmlWrappedComponent().getWrappedComponent();
        XmlComponentModel xmlComponentModel = xmlComponentWrapper.getXmlComponentModel();
        JLabel label = new JLabel();
        String labelText = xmlComponentModel.getShortDisplayName();
        labelText = labelText + ":";
        if (xmlComponentModel.isRequired().booleanValue()) {
            labelText = labelText + "*";
        }
        ResourceUtils.resLabel((JLabel)label, (Component)wrappedComponent, (String)labelText);
        container.add((Component)label, (CC)layoutOption.getLabelConstraint());
    }

    public JPanel buildHeaderPanel(Component component, Header.Level level, String title, boolean displayBorder, boolean indent, boolean expanded, Icon icon, String instructionalText) {
        HeaderPanel headerPanel = new HeaderPanel((JComponent)((JPanel)component));
        if (instructionalText.length() > 0) {
            headerPanel.setStaticHelpText(instructionalText);
        }
        headerPanel.setComponentBorderPainted(displayBorder);
        headerPanel.setComponentIndented(indent);
        Header header = headerPanel.getHeader();
        if (title != null) {
            header.setText(title);
        }
        if (icon != null) {
            header.setIcon(icon);
        }
        header.setLevel(level);
        header.setExpanded(expanded);
        return headerPanel;
    }

    public JPanel getPanel() {
        return this._xmlPanelWrapper.getPanel();
    }

    protected AbstractXmlPanelWrapper getXmlPanelWrapper() {
        return this._xmlPanelWrapper;
    }

    public int getLabeledComponentAfterPaddingOverride() {
        return this._labeledComponentAfterPaddingOverride;
    }

    @Override
    public void setLabeledComponentAfterPaddingOverride(int labeledComponentAfterPaddingOverride) {
        this._labeledComponentAfterPaddingOverride = labeledComponentAfterPaddingOverride;
    }
}

