/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;

public final class WeakNodeListenerProxy
extends NodeListener {
    private final Reference _node;
    private final Reference _listener;
    private static final NodeListener _sNO_OP_LISTENER = new NodeListener(){};

    public static void attach(Node node, NodeListener listener) {
        WeakNodeListenerProxy proxy = new WeakNodeListenerProxy(new WeakReference<Node>(node), new WeakReference<NodeListener>(listener));
        node.addNodeListener((NodeListener)proxy);
    }

    public void nodeClosed(NodeEvent e) {
        this._delegate().nodeClosed(e);
    }

    public void nodeDirtyStateChanged(NodeEvent e, boolean isNowDirty) {
        this._delegate().nodeDirtyStateChanged(e, isNowDirty);
    }

    public void nodeOpened(NodeEvent e) {
        this._delegate().nodeOpened(e);
    }

    public void nodeReverted(NodeEvent e) {
        this._delegate().nodeReverted(e);
    }

    public void nodeSaved(NodeEvent e) {
        this._delegate().nodeSaved(e);
    }

    public void nodeWillBeSaved(NodeEvent e) {
        this._delegate().nodeWillBeSaved(e);
    }

    public void nodeWillClose(NodeEvent e) {
        this._delegate().nodeWillClose(e);
    }

    private NodeListener _delegate() {
        NodeListener listener = (NodeListener)this._listener.get();
        if (listener != null) {
            return listener;
        }
        Node node = (Node)this._node.get();
        if (node != null) {
            node.removeNodeListener((NodeListener)this);
        }
        return _sNO_OP_LISTENER;
    }

    private WeakNodeListenerProxy(Reference node, Reference listener) {
        this._node = node;
        this._listener = listener;
    }
}

