/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.util;

import java.io.IOException;
import java.io.Reader;
import oracle.bali.xml.dom.parser.TextSynchronizer;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.TextBuffer;

public class JDevTextNodeTextSynchronizer
implements TextSynchronizer {
    private final TextNode _node;

    public JDevTextNodeTextSynchronizer(TextNode node) {
        assert (node != null);
        this._node = node;
    }

    public int getChangeId() {
        TextBuffer buf = this._node.acquireTextBuffer();
        int id = buf.getChangeId();
        this._node.releaseTextBuffer();
        return id;
    }

    public Reader getReader() {
        try {
            return this._node.getReader();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public String getSystemId() {
        return this._node.getURL().toExternalForm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contentUpdated(Reader reader, String systemId) {
        try {
            TextBuffer buf = this._node.acquireTextBuffer();
            buf.writeLock();
            try {
                buf.removeToEnd(0);
                buf.insert(0, reader);
            }
            finally {
                buf.writeUnlock();
            }
            this._node.releaseTextBuffer();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

