/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.util;

import java.awt.Component;
import java.util.List;
import javax.swing.SwingWorker;
import oracle.ide.controls.WaitCursor;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;

public abstract class AbstractSwingWorkerWrapper<T, V> {
    private AbstractSwingWorker<T, V> _worker;
    private IndeterminateProgressMonitor _ipm;
    private Component _parentComponent;
    private String _progressDialogLabel;
    private int _milliSecondsToShowWaitCursor = 1000;
    private int _milliSecondsToPopupProgressMonitor = 5000;

    public AbstractSwingWorkerWrapper(String progressDialogLabel, Component parentComponent) {
        this._progressDialogLabel = progressDialogLabel;
        this._parentComponent = parentComponent;
    }

    public final void execute() {
        final WaitCursor wc = new WaitCursor(this._parentComponent);
        if (this._milliSecondsToShowWaitCursor > -1) {
            wc.show(this._milliSecondsToShowWaitCursor);
        } else {
            wc.show();
        }
        this._ipm = new IndeterminateProgressMonitor(this._parentComponent, this._progressDialogLabel);
        this._ipm.setMillisToPopup(this._milliSecondsToPopupProgressMonitor);
        this._ipm.setCancellable(true);
        this._ipm.start();
        this._worker = new AbstractSwingWorker<T, V>(){

            @Override
            public T doInBackground() {
                return AbstractSwingWorkerWrapper.this.runDoInBackground();
            }

            @Override
            protected void process(List<V> chunks) {
                AbstractSwingWorkerWrapper.this.runProcess(chunks);
            }

            protected void publishChunks(V ... chunks) {
                this.publish(chunks);
            }

            @Override
            public void done() {
                AbstractSwingWorkerWrapper.this._ipm.finish();
                wc.hide();
                AbstractSwingWorkerWrapper.this.runDone();
            }
        };
        this.runWorkerExecute();
    }

    public AbstractSwingWorkerWrapper<T, V> setMilliSecondsToShowWaitCursor(int milliSecondsToShowWaitCursor) {
        this._milliSecondsToShowWaitCursor = milliSecondsToShowWaitCursor;
        return this;
    }

    public AbstractSwingWorkerWrapper<T, V> setMilliSecondsToPopupProgressMonitor(int milliSecondsToPopupProgressMonitor) {
        this._milliSecondsToPopupProgressMonitor = milliSecondsToPopupProgressMonitor;
        return this;
    }

    protected abstract T runDoInBackground();

    protected void runDone() {
    }

    protected void runProcess(List<V> chunks) {
    }

    protected void runWorkerExecute() {
        this.getWorker().execute();
    }

    protected void runPublish(V ... chunks) {
        this.getWorker().runPublish(chunks);
    }

    protected AbstractSwingWorker<T, V> getWorker() {
        return this._worker;
    }

    protected boolean isCancelled() {
        return this._ipm.isCancelled();
    }

    private abstract class AbstractSwingWorker<T, V>
    extends SwingWorker<T, V> {
        private AbstractSwingWorker() {
        }

        public void runPublish(V ... chunks) {
            this.publish(chunks);
        }
    }
}

