/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.undo;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.gui.jdev.undo.MultiEditUndoableEditCommand;
import oracle.bali.xml.gui.jdev.undo.UndoableEditIdeCommand;
import oracle.bali.xml.share.AbstractTransactionMediator;
import oracle.bali.xml.share.TransactionToken;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Node;

public final class TransactionMediator
extends AbstractTransactionMediator {
    private static final TransactionMediator _sINSTANCE = new TransactionMediator();
    private static final Logger _LOGGER = Logger.getLogger(TransactionMediator.class.getName());

    public static TransactionMediator getInstance() {
        return _sINSTANCE;
    }

    public void addEdit(TransactionToken token, Node node, UndoableEdit edit) {
        this.addEditImpl(token, node, edit);
    }

    protected void deliverMultipleEditsImpl(TransactionToken token, AbstractTransactionMediator.Info info) {
        this._invoke(new MultiEditUndoableEditCommand(token.getName(), info.documents, info.edits));
    }

    protected void deliverOneEditImpl(Object node, UndoableEdit edit) {
        UndoableEditIdeCommand casted;
        Context ideContext = new Context((Node)node);
        Command priorCommand = CommandProcessor.getInstance().getCommand(ideContext);
        if (priorCommand instanceof UndoableEditIdeCommand && (casted = (UndoableEditIdeCommand)priorCommand).__addEdit(edit)) {
            return;
        }
        UndoableEditIdeCommand cmd = new UndoableEditIdeCommand(edit);
        cmd.setContext(ideContext);
        this._invoke(cmd);
    }

    private void _invoke(Command cmd) {
        try {
            CommandProcessor.getInstance().invoke(cmd);
        }
        catch (Exception e) {
            _LOGGER.log(Level.WARNING, "Unexpected exception invoking undoable-edit command", e);
        }
    }

    private TransactionMediator() {
    }
}

