/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.palette;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import oracle.bali.xml.gui.jdev.palette.JDevPaletteGui;
import oracle.bali.xml.gui.jdev.palette.XmlPaletteItem;
import oracle.bali.xml.gui.jdev.palette.XmlPaletteSection;
import oracle.bali.xml.model.category.CategoryDefinition;
import oracle.bali.xml.model.creatable.XmlCreatable;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteSection;

class XmlPaletteGroup
extends PaletteGroup {
    private final CategoryDefinition _categoryDefinitionPaletteGroup;
    private final Map<CategoryDefinition, XmlPaletteSection> _sections = new TreeMap<CategoryDefinition, XmlPaletteSection>((Comparator<CategoryDefinition>)new CategoryDefinition.CategoryDefinitionComparator());
    private final Collection<PaletteSection> _sectionsCollection = Collections.unmodifiableCollection(this._sections.values());

    XmlPaletteGroup(CategoryDefinition categoryDefinitionPaletteGroup) {
        this._categoryDefinitionPaletteGroup = categoryDefinitionPaletteGroup;
    }

    public Collection<PaletteSection> getSections() {
        return this._sectionsCollection;
    }

    public String getName() {
        return this._categoryDefinitionPaletteGroup.getDisplayName();
    }

    public int getDisplayOrder() {
        return this._categoryDefinitionPaletteGroup.getDisplayOrder();
    }

    public String getDescription() {
        return null;
    }

    public Icon getIcon() {
        return null;
    }

    public Object getData(Object key) {
        Editor editor;
        if (this._categoryDefinitionPaletteGroup.getOpenByDefault() && "showForTypes".equalsIgnoreCase((String)key) && (editor = EditorManager.getEditorManager().getCurrentEditor()) != null) {
            Context context = editor.getContext();
            if (context == null) {
                return null;
            }
            Node node = context.getNode();
            if (node == null) {
                return null;
            }
            String fileType = XmlPaletteGroup._getSuffix(node.getURL());
            if (fileType == null) {
                return null;
            }
            return Collections.singletonList(fileType);
        }
        return null;
    }

    public boolean isVisible(Context context) {
        return true;
    }

    public String toString() {
        return "{" + this._categoryDefinitionPaletteGroup.getDisplayName() + "; " + this._sections + "}";
    }

    void __addSection(XmlPaletteSection section, CategoryDefinition categoryDefinition) {
        this._sections.put(categoryDefinition, section);
    }

    XmlPaletteItem __addItem(JDevPaletteGui gui, XmlCreatable creatable, CategoryDefinition categoryDefinitionPaletteSection) {
        XmlPaletteSection section = this._sections.get(categoryDefinitionPaletteSection);
        if (section == null) {
            section = new XmlPaletteSection(gui, categoryDefinitionPaletteSection);
            this._sections.put(categoryDefinitionPaletteSection, section);
        }
        return section.__addItem(creatable);
    }

    void __clearItems() {
        Iterator<XmlPaletteSection> itor = this._sections.values().iterator();
        while (itor.hasNext()) {
            itor.next().__clearItems();
        }
    }

    void __dispose() {
        Iterator<XmlPaletteSection> itor = this._sections.values().iterator();
        while (itor.hasNext()) {
            itor.next().__dispose();
        }
        this._sections.clear();
    }

    void __trimEmptyContainers() {
        Iterator<XmlPaletteSection> itor = this._sections.values().iterator();
        while (itor.hasNext()) {
            XmlPaletteSection section = itor.next();
            if (!section.getItems().isEmpty()) continue;
            itor.remove();
        }
    }

    PaletteItem __findItem(String identifier) {
        for (XmlPaletteSection section : this._sections.values()) {
            PaletteItem item = section.__findItem(identifier);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    private static String _getSuffix(URL url) {
        String suffix = URLFileSystem.getSuffix((URL)url);
        int period = suffix.lastIndexOf(".");
        if (period != -1) {
            return suffix.substring(period + 1);
        }
        return "";
    }
}

