/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.overviewEditor;

import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.share.FastMessageFormat;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class OverviewEditorMetadataMethods {
    private static final QualifiedName FAVORITE_PROPERTY_QUALIFIED_NAME = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata", (String)"favoriteProperty");
    private static final String TEXT_CONTENT_FAVORITE_PROPERTY = "[TEXT-CONTENT]";
    private static final String WITH_FAVORITE_PROPERTY_FORMAT = "{0} - {1}";
    private static final String WITH_FAVORITE_PROPERTY_VALUE_FORMAT = "{0}";
    private static final String HELP_TOPIC_FORMAT = "f1_adfc_{0}_html";

    private OverviewEditorMetadataMethods() {
    }

    public static String withFavoriteProperty(MetadataProvider metadataProvider, XmlKey xmlKey, Node node) {
        String favoritePropertyValue;
        String localName = xmlKey.getLocalName();
        Element element = DomUtils.asElement((Node)node);
        if (element != null && (favoritePropertyValue = OverviewEditorMetadataMethods.deriveFavoritePropertyValue(metadataProvider, xmlKey, node)) != null) {
            return FastMessageFormat.formatMessage((String)WITH_FAVORITE_PROPERTY_FORMAT, (String)localName, (String)favoritePropertyValue);
        }
        return localName;
    }

    public static String withFavoritePropertyValue(MetadataProvider metadataProvider, XmlKey xmlKey, Node node) {
        String favoritePropertyValue;
        String localName = xmlKey.getLocalName();
        Element element = DomUtils.asElement((Node)node);
        if (element != null && (favoritePropertyValue = OverviewEditorMetadataMethods.deriveFavoritePropertyValue(metadataProvider, xmlKey, node)) != null) {
            return FastMessageFormat.formatMessage((String)WITH_FAVORITE_PROPERTY_VALUE_FORMAT, (String)favoritePropertyValue);
        }
        return localName;
    }

    private static String deriveFavoritePropertyValue(MetadataProvider metadataProvider, XmlKey xmlKey, Node node) {
        Object favoritePropertyAsObject;
        Element element = DomUtils.asElement((Node)node);
        if (element != null && (favoritePropertyAsObject = metadataProvider.getMetadataItem((Object)xmlKey, (Object)FAVORITE_PROPERTY_QUALIFIED_NAME)) instanceof String) {
            String favoriteProperty = (String)favoritePropertyAsObject;
            if (TEXT_CONTENT_FAVORITE_PROPERTY.equals(favoriteProperty)) {
                String textContent = element.getTextContent();
                if (textContent != null && textContent.length() > 0) {
                    return textContent;
                }
            } else if (element.hasAttribute(favoriteProperty)) {
                String attributeValue = element.getAttribute(favoriteProperty);
                if (attributeValue.length() > 0) {
                    return attributeValue;
                }
            } else {
                NodeList childNodes = element.getChildNodes();
                int childNodeCount = childNodes.getLength();
                for (int i = 0; i < childNodeCount; ++i) {
                    String childTextContent;
                    Element childElement = DomUtils.asElement((Node)childNodes.item(i));
                    if (childElement == null || !favoriteProperty.equals(childElement.getTagName()) || (childTextContent = childElement.getTextContent()) == null || childTextContent.length() <= 0) continue;
                    return childTextContent;
                }
            }
        }
        return null;
    }

    public static String helpTopic(XmlKey xmlKey) {
        String localName = xmlKey.getLocalName();
        String scrubbedLocalName = localName.replace('-', '_');
        String helpTopic = FastMessageFormat.formatMessage((String)HELP_TOPIC_FORMAT, (String)scrubbedLocalName);
        return helpTopic;
    }
}

