/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.extension.guifactory;

import java.util.concurrent.CopyOnWriteArrayList;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.XmlGuiFactory;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.extension.HookDataListener;
import oracle.bali.xml.gui.jdev.extension.guifactory.DeclarativeGuiFactoryHookData;
import oracle.bali.xml.gui.jdev.extension.guifactory.DeclarativeGuiFactoryHookSupport;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;

public class DeclarativeGuiFactory
extends XmlGuiFactory
implements HookDataListener<DeclarativeGuiFactoryHookData> {
    private final JDevXmlContext _xmlContext;
    private final CopyOnWriteArrayList<DeclarativeGuiFactoryHookData> _factories;
    private boolean _bAttached = false;

    public DeclarativeGuiFactory(JDevXmlContext xmlContext) {
        this._xmlContext = xmlContext;
        this._factories = new CopyOnWriteArrayList();
    }

    public XmlGui createGui(XmlView xmlView, XmlUsage xmlUsage) {
        this.ensureAttached();
        for (DeclarativeGuiFactoryHookData xmlGuiFactory : this._factories) {
            XmlGui gui;
            if (!xmlGuiFactory.supportsUsage(xmlUsage) || (gui = xmlGuiFactory.createGui(xmlView, xmlUsage)) == null) continue;
            return gui;
        }
        return null;
    }

    @Override
    public void hookDataAdded(DeclarativeGuiFactoryHookData hookData) {
        if (hookData.evaluateRule(this._xmlContext)) {
            this._factories.add(0, hookData);
        }
    }

    private synchronized void ensureAttached() {
        if (!this._bAttached) {
            this._bAttached = true;
            DeclarativeGuiFactoryHookSupport.getInstance().addHookDataListener(this);
        }
    }
}

