/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.explorer;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversalTreeWalker;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.base.explorer.XmlTreeModel;
import oracle.bali.xml.gui.jdev.explorer.JDevExplorerGui;
import oracle.bali.xml.gui.jdev.util.AbstractSwingWorkerWrapper;
import oracle.bali.xml.gui.swing.explorer.SwingExplorerGui;
import oracle.bali.xml.gui.swing.explorer.XmlJTree;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.task.NonDomMutationTransactionTask;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.ide.controls.KeyNavigationManager;
import org.w3c.dom.Node;

class JDevXmlTree
extends XmlJTree {
    private final KeyNavigationManager _knm = new KeyNavigationManager((KeyNavigationManager.KeyComponentAdapter)new KeyNavAdapter());
    private static int _DEFAULTSCROLLREGIONSIZE = 5;

    public JDevXmlTree(JDevExplorerGui gui) {
        super((SwingExplorerGui)gui);
    }

    protected void processKeyEvent(KeyEvent e) {
        this._knm.preProcessKeyEvent(e);
        super.processKeyEvent(e);
        this._knm.postProcessKeyEvent(e);
    }

    public void expandAll(Component parentComponent, XmlGui xmlGui) {
        this.expandOrCollapseAll(true, parentComponent, xmlGui);
    }

    public void collapseAll(Component parentComponent, XmlGui xmlGui) {
        final XmlTreeModel xmlTreeModel = (XmlTreeModel)this.getModel();
        boolean collapseRoot = (Boolean)new ReadOnlyTask<Boolean>(){

            protected Boolean runImpl(AbstractModel model) {
                Node rootNode;
                Node selectedNode = xmlTreeModel.getView().getSelection().getFirstSelectedNode();
                if (selectedNode != null && selectedNode.equals(rootNode = xmlTreeModel.getRootDomNode(0))) {
                    JDevXmlTree.this.setModel((TreeModel)xmlTreeModel);
                    return true;
                }
                return false;
            }
        }.run((AbstractModel)xmlGui.getView());
        if (collapseRoot) {
            xmlTreeModel.triggerStructureChangeEvent();
            new NonDomMutationTransactionTask(){

                protected void performTask(AbstractModel model) {
                    model.getSelection().set(xmlTreeModel.getRootDomNode(0));
                }
            }.run((AbstractModel)xmlGui.getView());
        } else {
            this.expandOrCollapseAll(false, parentComponent, xmlGui);
        }
    }

    private void expandOrCollapseAll(final boolean expand, Component parentComponent, final XmlGui xmlGui) {
        String progressDialogTitle = expand ? StringUtils.stripMnemonic((String)JDevExplorerGui.getTranslatedResource("EXPLORER.EXPAND_ALL_BELOW")) : StringUtils.stripMnemonic((String)JDevExplorerGui.getTranslatedResource("EXPLORER.COLLAPSE_ALL_BELOW"));
        new AbstractSwingWorkerWrapper<String, TreePath>(progressDialogTitle, parentComponent){

            @Override
            protected String runDoInBackground() {
                final XmlTreeModel xmlTreeModel = (XmlTreeModel)JDevXmlTree.this.getModel();
                new ReadOnlyTask<Boolean>(){

                    protected Boolean runImpl(AbstractModel model) {
                        Node selectedNode = xmlTreeModel.getView().getSelection().getFirstSelectedNode();
                        if (selectedNode != null) {
                            this.expandOrCollapsePath(xmlTreeModel.getPathForDomElement(selectedNode), xmlTreeModel, expand);
                        }
                        return true;
                    }
                }.run((AbstractModel)xmlGui.getView());
                return "done";
            }

            protected void expandOrCollapsePath(TreePath parentTreePath, XmlTreeModel xmlTreeModel, boolean expand2) {
                Node parentNode = (Node)parentTreePath.getLastPathComponent();
                int childCount = xmlTreeModel.getChildCount((Object)parentNode);
                if (childCount > 0) {
                    for (int i = 0; i < childCount && !this.isCancelled(); ++i) {
                        Node childNode = (Node)xmlTreeModel.getChild((Object)parentNode, i);
                        if (xmlTreeModel.isLeaf((Object)childNode)) continue;
                        this.expandOrCollapsePath(parentTreePath.pathByAddingChild(childNode), xmlTreeModel, expand2);
                    }
                }
                if (!this.isCancelled()) {
                    this.runPublish(parentTreePath);
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }

            @Override
            protected void runProcess(List<TreePath> results) {
                for (TreePath treePath : results) {
                    if (expand) {
                        JDevXmlTree.this.expandPath(treePath);
                        continue;
                    }
                    JDevXmlTree.this.collapsePath(treePath);
                }
            }
        }.execute();
    }

    public boolean selectNodeContainingString(String searchText, boolean searchForward, Node startNode, JDevExplorerGui xmlGui) {
        XmlTreeModel xmlTreeModel = (XmlTreeModel)this.getModel();
        if (startNode == null) {
            return false;
        }
        Node beginSearchNode = startNode;
        FindNodeTreeWalker findNodeTreeWalker = new FindNodeTreeWalker(beginSearchNode, xmlTreeModel.getNodeFilterTreeTraversal());
        findNodeTreeWalker.setCurrentNode(beginSearchNode);
        Node currNode = null;
        currNode = searchForward ? findNodeTreeWalker.nextNode() : findNodeTreeWalker.previousNode();
        while (currNode != null) {
            if (this.nodeContainsSearchText(currNode, searchText, xmlGui)) {
                xmlGui.getView().getSelection().set(currNode);
                return true;
            }
            if (searchForward) {
                currNode = findNodeTreeWalker.nextNode();
                continue;
            }
            currNode = findNodeTreeWalker.previousNode();
        }
        return false;
    }

    public boolean nodeContainsSearchText(Node node, String searchText, JDevExplorerGui xmlGui) {
        String text = xmlGui.getTitle(node);
        return text.toLowerCase().indexOf(searchText.toLowerCase()) > -1;
    }

    public Node findLastNode() {
        Node lastNode = null;
        XmlTreeModel xmlTreeModel = (XmlTreeModel)this.getModel();
        Node currRootNode = xmlTreeModel.getRootDomNode(0);
        FindNodeTreeWalker findNodeTreeWalker = new FindNodeTreeWalker(currRootNode, xmlTreeModel.getNodeFilterTreeTraversal());
        findNodeTreeWalker.setCurrentNode(currRootNode);
        Node currNode = currRootNode;
        while (currNode != null) {
            currNode = findNodeTreeWalker.nextNode();
            if (currNode == null) continue;
            lastNode = currNode;
        }
        return lastNode;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int scrollIncr = super.getScrollableUnitIncrement(visibleRect, orientation, direction);
        if (scrollIncr < _DEFAULTSCROLLREGIONSIZE) {
            return _DEFAULTSCROLLREGIONSIZE;
        }
        return scrollIncr;
    }

    private class KeyNavAdapter
    extends KeyNavigationManager.TreeKeyAdapter {
        public KeyNavAdapter() {
            super((JTree)((Object)JDevXmlTree.this));
        }

        public String toString(Object pathObj) {
            TreePath path = (TreePath)pathObj;
            String ret = JDevXmlTree.this.getGui().getTitle(path.getLastPathComponent());
            return ret;
        }
    }

    private class FindNodeTreeWalker
    extends TreeTraversalTreeWalker {
        private Node _rootNode;
        private TreeTraversal _treeTraversal;

        public FindNodeTreeWalker(Node rootNode, TreeTraversal treeTraversal) {
            if (rootNode == null) {
                throw new IllegalArgumentException("No root filter node provided");
            }
            this._rootNode = rootNode;
            this._treeTraversal = treeTraversal;
        }

        public Node getRoot() {
            return this._rootNode;
        }

        protected TreeTraversal getTreeTraversal() {
            return this._treeTraversal;
        }
    }
}

