/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.explorer;

import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.base.explorer.XmlTreeModel;
import oracle.bali.xml.gui.jdev.JDevViewHostedGui;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.ceditor.JDevTextSelectionSynchronizer;
import oracle.bali.xml.gui.jdev.explorer.AbstractExplorerAction;
import oracle.bali.xml.gui.jdev.explorer.ExplorerActionContext;
import oracle.bali.xml.gui.jdev.explorer.ExplorerActionListener;
import oracle.bali.xml.gui.jdev.explorer.JDevExplorerComponent;
import oracle.bali.xml.gui.jdev.explorer.JDevXmlTree;
import oracle.bali.xml.gui.jdev.resource.JDevBundle;
import oracle.bali.xml.gui.jdev.util.AbstractSwingWorkerWrapper;
import oracle.bali.xml.gui.jdev.util.JDevUtils;
import oracle.bali.xml.gui.swing.explorer.SavedExpansionState;
import oracle.bali.xml.gui.swing.explorer.SwingExplorerGui;
import oracle.bali.xml.gui.swing.explorer.XmlJTree;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.bali.xml.share.SafeListenerManager;
import oracle.ide.controls.OverlayIcon;
import oracle.ide.inspector.InspectorManager;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.status.Issue;
import org.w3c.dom.Node;

public class JDevExplorerGui
extends SwingExplorerGui
implements JDevViewHostedGui {
    private JDevExplorerComponent _explorerComponent;
    private final SafeListenerManager _explorerActionListeners = new SafeListenerManager();
    private boolean _allowExpandCollapse = true;
    private View _jdevView;

    public JDevExplorerGui(XmlView view) {
        super(view);
    }

    @Override
    public void setOwningJDevView(View view) {
        this._jdevView = view;
    }

    @Override
    public View getOwningJDevView() {
        return this._jdevView;
    }

    public void ensureActiveGuiAcquired() {
        JDevXmlContext context = (JDevXmlContext)this.getGuiContext();
        XmlGui activeGui = this.getGuiContext().getActiveGui();
        if (activeGui != this) {
            context.acquireActiveGui((XmlGui)this);
        }
    }

    protected JTree createJTree() {
        return new JDevXmlTree(this);
    }

    protected void showPopupMenu(final MouseEvent me, TreePath clickedPath) {
        if (this.getTreeModel().pathToSourceDom(clickedPath) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JDevExplorerGui.this.ensureActiveGuiAcquired();
                    JDevXmlContext.showContextMenu(JDevExplorerGui.this, me);
                }
            });
        } else {
            super.showPopupMenu(me, clickedPath);
        }
    }

    protected boolean invokeDefaultAction(InputEvent e, TreePath eventPath) {
        Issue issue;
        int start;
        Object lastComp;
        if (eventPath != null && (lastComp = eventPath.getLastPathComponent()) instanceof Issue && (start = (issue = (Issue)lastComp).getOffset()) != -1) {
            int end = start + issue.getLength();
            if (end == -1) {
                end = start;
            }
            JDevUtils.openCodeEditor((JDevXmlContext)this.getGuiContext());
            JDevTextSelectionSynchronizer.INSTANCE.syncTextSelection(this.getView().getBaseModel(), start, end, null);
            return true;
        }
        if (InspectorManager.getInspectorManager() != null) {
            InspectorManager.getInspectorManager().showLastView(null);
        }
        return true;
    }

    public Icon getIcon(Object value) {
        Icon icon = super.getIcon(value);
        if (icon != null && value instanceof XmlTreeModel.ErrorsFolder) {
            switch (((XmlTreeModel.ErrorsFolder)value).getHighestSeverity()) {
                case ERROR: {
                    return new OverlayIcon(icon, OracleIcons.getIcon((String)"overlay/error.png"));
                }
                case WARNING: {
                    return new OverlayIcon(icon, OracleIcons.getIcon((String)"overlay/warning.png"));
                }
            }
        }
        return icon;
    }

    protected void handleShown() {
        this.updateExplorerActionContext();
        if (this.getExplorerComponent() != null) {
            if (this.getTreeModel().getSubTreeRootNode() != null) {
                this.getExplorerComponent().setVisibleShowRootButton(true);
            } else {
                this.getExplorerComponent().setVisibleShowRootButton(false);
            }
        }
        new ReadOnlyTask<Boolean>(){

            protected Boolean runImpl(AbstractModel model) {
                DomPosition cursorLocation;
                Node scrollNode = model.getSelection().getFirstSelectedNode();
                if (scrollNode == null && (cursorLocation = model.getSelection().getCursorLocation()) != null) {
                    scrollNode = cursorLocation.getTargetNode();
                }
                if (scrollNode != null) {
                    JDevExplorerGui.this.scrollToNode(scrollNode);
                }
                return true;
            }
        }.run((AbstractModel)this.getView());
    }

    protected void updateExplorerActionContext() {
        List viewActionList = this.getView().getContextActions();
        for (Action viewAction : viewActionList) {
            if (!(viewAction instanceof AbstractExplorerAction)) continue;
            ExplorerActionContext.updateContextIn(viewAction, new ExplorerActionContext(this));
            ((AbstractExplorerAction)((Object)viewAction)).setEnabled();
        }
    }

    public Action getViewAction(String actionCommandKey) {
        List viewActionList = this.getView().getContextActions();
        for (Action viewAction : viewActionList) {
            if (viewAction == null) continue;
            Object viewActionName = viewAction.getValue("ActionCommandKey");
            if (viewActionName == null || !viewActionName.equals(actionCommandKey)) continue;
            return viewAction;
        }
        return null;
    }

    protected void handleModelChangeEventImpl(XmlModelEvent event) {
        Node showAsTopNode;
        if (event.isDomDocumentChanged() && this.getTreeModel().getSubTreeRootNode() != null) {
            Node remappedNode = this.getTreeModel().getRemappedSubTreeNode();
            if (remappedNode != null) {
                this.getTreeModel().setSubTreeRootNode(remappedNode);
            } else {
                new ReadOnlyTask<Boolean>(){

                    protected Boolean runImpl(AbstractModel model) {
                        JDevExplorerGui.this._restoreRootNodeView(model);
                        return true;
                    }
                }.run((AbstractModel)this.getView());
                return;
            }
        }
        if (event.isSelectionChanged() && (showAsTopNode = this.getTreeModel().getSubTreeRootNode()) != null) {
            Set selectionsAdded = event.getSelectionsAdded();
            for (Node selectedNode : selectionsAdded) {
                boolean isNodeOrDescendant = DomUtils.isNodeOrDescendant((TreeTraversal)this.getView().getTreeTraversal(), (Node)selectedNode, (Node)showAsTopNode);
                if (isNodeOrDescendant) continue;
                new ReadOnlyTask<Boolean>(){

                    protected Boolean runImpl(AbstractModel model) {
                        JDevExplorerGui.this._restoreRootNodeView(model);
                        return true;
                    }
                }.run((AbstractModel)this.getView());
            }
        }
        super.handleModelChangeEventImpl(event);
    }

    public void showAsTop() {
        this.showAsTop(null);
    }

    public void showAsTop(final Node topNode) {
        String progressDialogTitle = StringUtils.stripMnemonic((String)JDevExplorerGui.getTranslatedResource("EXPLORER.SHOW_AS_TOP"));
        new AbstractSwingWorkerWrapper<String, Void>(progressDialogTitle, (Component)this.getJTree()){

            @Override
            protected String runDoInBackground() {
                final XmlTreeModel xmlTreeModel = JDevExplorerGui.this.getTreeModel();
                final XmlJTree xmlJTree = (XmlJTree)JDevExplorerGui.this.getJTree();
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            new ReadOnlyTask<Boolean>(){

                                protected Boolean runImpl(AbstractModel model) {
                                    Node showAsTopNode;
                                    Node node = showAsTopNode = topNode != null ? topNode : JDevExplorerGui.this.getView().getSelection().getFirstSelectedNode();
                                    if (showAsTopNode == null) {
                                        return false;
                                    }
                                    JDevExplorerGui.this.disposeTreeSelectionModel(JDevExplorerGui.this.getJTree().getSelectionModel());
                                    JDevExplorerGui.this.getJTree().setSelectionModel(new DefaultTreeSelectionModel());
                                    if (xmlTreeModel.getSubTreeRootNode() == null) {
                                        xmlJTree.saveRootExpansionState();
                                    }
                                    JDevExplorerGui.this._setSubTreeRootNode(showAsTopNode);
                                    xmlJTree.restoreRootExpansionState();
                                    xmlJTree.expandParentNode(showAsTopNode);
                                    JDevExplorerGui.this.scrollToNode(showAsTopNode);
                                    JDevExplorerGui.this.getJTree().setSelectionModel(JDevExplorerGui.this.createTreeSelectionModel());
                                    JDevExplorerGui.this.getExplorerComponent().setVisibleShowRootButton(true);
                                    JDevExplorerGui.this.updateExplorerActionContext();
                                    return true;
                                }
                            }.run((AbstractModel)JDevExplorerGui.this.getView());
                        }
                    });
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return "done";
                }
                return "done";
            }

            @Override
            protected void runDone() {
                for (ExplorerActionListener showAsTopListener : JDevExplorerGui.this._explorerActionListeners) {
                    showAsTopListener.explorerShowAsTopInvoked();
                }
            }
        }.execute();
    }

    public void showRoot() {
        if (this.getTreeModel().getSubTreeRootNode() == null) {
            return;
        }
        String progressDialogTitle = StringUtils.stripMnemonic((String)JDevExplorerGui.getTranslatedResource("EXPLORER.SHOW_ROOT"));
        new AbstractSwingWorkerWrapper<String, Void>(progressDialogTitle, (Component)this.getJTree()){

            @Override
            protected String runDoInBackground() {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            new ReadOnlyTask<Boolean>(){

                                protected Boolean runImpl(AbstractModel model) {
                                    JDevExplorerGui.this._restoreRootNodeView(model);
                                    return true;
                                }
                            }.run((AbstractModel)JDevExplorerGui.this.getView());
                        }
                    });
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return "done";
                }
                return "done";
            }

            @Override
            protected void runDone() {
                for (ExplorerActionListener explorerActionListener : JDevExplorerGui.this._explorerActionListeners) {
                    explorerActionListener.explorerShowRootInvoked();
                }
            }
        }.execute();
    }

    public void setAllowExpandCollapse(boolean allowExpandCollapse) {
        this._allowExpandCollapse = allowExpandCollapse;
    }

    public void addExplorerActionListener(ExplorerActionListener explorerActionListener) {
        this._explorerActionListeners.addListener((Object)explorerActionListener);
    }

    public void removeExplorerActionListener(ExplorerActionListener explorerActionListener) {
        this._explorerActionListeners.removeListener((Object)explorerActionListener);
    }

    private void _setSubTreeRootNode(Node selectedNode) {
        XmlTreeModel xmlTreeModel = this.getTreeModel();
        xmlTreeModel.setSubTreeRootNode(selectedNode);
        xmlTreeModel.triggerStructureChangeEvent();
    }

    private void _restoreRootNodeView(AbstractModel model) {
        XmlTreeModel xmlTreeModel = this.getTreeModel();
        XmlJTree xmlJTree = (XmlJTree)this.getJTree();
        this.disposeTreeSelectionModel(this.getJTree().getSelectionModel());
        this.getJTree().setSelectionModel(new DefaultTreeSelectionModel());
        SavedExpansionState showAsTopExpansionState = this._saveExpansionState(xmlTreeModel.getRoot());
        Node subTreeRootNode = xmlTreeModel.getSubTreeRootNode();
        this._setSubTreeRootNode(null);
        this._restoreExpandedState(showAsTopExpansionState, xmlJTree, subTreeRootNode);
        Node scrollNode = this.getView().getSelection().getFirstSelectedNode();
        if (scrollNode == null) {
            scrollNode = this.getView().getSelection().getCursorLocation().getTargetNode();
        }
        if (scrollNode != null) {
            this.scrollToNode(scrollNode);
        }
        this.getJTree().setSelectionModel(this.createTreeSelectionModel());
        if (this.isShown()) {
            this.getExplorerComponent().setVisibleShowRootButton(false);
            this.updateExplorerActionContext();
        }
    }

    private SavedExpansionState _saveExpansionState(final Object root) {
        final JDevExplorerGui jDevExplorerGui = this;
        SavedExpansionState savedExpansionState = (SavedExpansionState)new ReadOnlyTask<SavedExpansionState>(){

            protected SavedExpansionState runImpl(AbstractModel model) {
                TreePath rootPath = new TreePath(root);
                SavedExpansionState savedExpansionState = SavedExpansionState.saveState((SwingExplorerGui)jDevExplorerGui, (XmlJTree)((XmlJTree)JDevExplorerGui.this.getJTree()), (TreePath)rootPath);
                return savedExpansionState;
            }
        }.run((AbstractModel)this.getView());
        return savedExpansionState;
    }

    private void _restoreExpandedState(SavedExpansionState savedExpansionState, XmlJTree xmlJTree, Node subTreeRootNode) {
        xmlJTree.restoreRootExpansionState();
        TreePath subTreePath = this.getTreeModel().getPathForDomElement(subTreeRootNode);
        this.getJTree().collapsePath(subTreePath);
        savedExpansionState.restore();
    }

    public JDevExplorerComponent getExplorerComponent() {
        return this._explorerComponent;
    }

    public void setExplorerComponent(JDevExplorerComponent explorerComponent) {
        this._explorerComponent = explorerComponent;
    }

    public static String getTranslatedResource(String key) {
        ResourceBundle bundle = JDevBundle.getBundle();
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return "???" + key + "???";
    }
}

