/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.explorer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.gui.jdev.explorer.ExplorerShowAsTopAction;
import oracle.bali.xml.gui.jdev.explorer.JDevExplorerGui;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.javatools.icons.OracleIcons;

public final class ExplorerToolbar {
    private List localButtons;
    private JDevExplorerGui _xmlGui;

    ExplorerToolbar(JDevExplorerGui xmlGui) {
        this._xmlGui = xmlGui;
    }

    public void addToolbarItems() {
        if (this._getToolbar() != null) {
            if (this.localButtons == null) {
                this.localButtons = new ArrayList();
                this.localButtons.add(this._getToolbar().add((ToggleAction)this.createShowAsTopAction()));
                ExplorerShowAsTopAction.IDEACTION.putValue("SmallIcon", null);
                this.localButtons.add(this._getToolbar().addToggleButton(this.createFindAction()));
            } else {
                int numButtons = this.localButtons.size();
                for (int i = 0; i < numButtons; ++i) {
                    this._getToolbar().add((Component)this.localButtons.get(i));
                }
            }
        }
    }

    public void addSeparator() {
        int count = this._getToolbar().getComponentCount();
        if (count > 0) {
            Component c = this._getToolbar().getComponentAtIndex(count - 1);
            if (!(c instanceof JToolBar.Separator)) {
                this._getToolbar().addSeparator();
            }
        } else {
            this._getToolbar().addSeparator();
        }
    }

    public void hideToolbarItems() {
        if (this._getToolbar() != null && this.localButtons != null) {
            int numButtons = this.localButtons.size();
            for (int i = 0; i < numButtons; ++i) {
                this._getToolbar().remove((Component)this.localButtons.get(i));
            }
        }
    }

    public void dispose() {
        this.hideToolbarItems();
        if (this.localButtons != null) {
            int count = this.localButtons.size();
            for (int i = 0; i < count; ++i) {
                Object o = this.localButtons.get(i);
                if (!(o instanceof AbstractButton)) continue;
                ((AbstractButton)o).setAction(null);
            }
            this.localButtons = null;
        }
    }

    private Toolbar _getToolbar() {
        if (this._xmlGui.getOwningJDevView() == null) {
            return null;
        }
        return this._xmlGui.getOwningJDevView().getToolbar();
    }

    private IdeAction createShowAsTopAction() {
        IdeAction showAsTopAction = ExplorerShowAsTopAction.IDEACTION;
        showAsTopAction.setEnabled(false);
        showAsTopAction.putValue("SmallIcon", (Object)ExplorerShowAsTopAction.ICON);
        IdeAction localShowAsTopAction = ExplorerShowAsTopAction.IDEACTION.newLocalAction(this._xmlGui.getOwningJDevView());
        return localShowAsTopAction;
    }

    private ToggleAction createFindAction() {
        ToggleAction action = new ToggleAction("", OracleIcons.getIcon((String)"find.png")){

            public void actionPerformed(ActionEvent e) {
                JComponent findComponent = ExplorerToolbar.this._xmlGui.getExplorerComponent().getFindComponent();
                if (findComponent.isVisible()) {
                    findComponent.setVisible(false);
                } else {
                    ExplorerToolbar.this._xmlGui.getExplorerComponent().getSearchField().setPrompt("");
                    findComponent.setVisible(true);
                }
            }
        };
        action.putValue("ShortDescription", (Object)StringUtils.stripMnemonic((String)JDevExplorerGui.getTranslatedResource("EXPLORER.FIND_TOOLTIP")));
        return action;
    }
}

