/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.dependency.url;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.gui.jdev.audit.XmlefAuditBundle;
import oracle.bali.xml.gui.jdev.audit.xdf.DependencyProvider;
import oracle.bali.xml.gui.jdev.dependency.ExternalIdReference;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.dependency.Declaration;
import oracle.bali.xml.model.dependency.DependencyContext;
import oracle.bali.xml.model.dependency.ResultIssue;
import oracle.bali.xml.model.dependency.ValidationResult;
import oracle.ide.dependency.URLDeclarationProvider;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.status.Issue;
import oracle.javatools.status.Severity;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.model.FileDependency;
import org.w3c.dom.Node;

public class UrlReference
extends ExternalIdReference
implements DependencyProvider {
    public static final String URL_REF_KEY = "XDF_URL_REF";
    protected URL _url;

    public UrlReference(XmlContext xmlContext, Node node, int start, int end, URL url) {
        super(xmlContext, node, start, end);
        this._url = url;
    }

    public ValidationResult validateDeclaration(DependencyContext context, Declaration declaration) {
        if (declaration == null && this._url != null && !this.isLocalURL(this.getURL(), this._url)) {
            ValidationResult result = this.getXmlContext(context).getModel().getCachedURLValidationResult(this._url);
            if (result == null) {
                result = new ValidationResult((Issue)new RemoteURLIssue(Severity.ADVISORY, XmlefAuditBundle.get("REMOTE_LOCATION_NOT_LOADED")));
            }
            return result;
        }
        return super.validateDeclaration(context, declaration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Declaration findDeclaration(DependencyContext context) {
        if (this._url == null) {
            return null;
        }
        boolean isLocal = this.isLocalURL(this.getURL(), this._url);
        if (!isLocal) {
            ValidationResult result = ValidationResult.OK;
            XmlModel model = this.getXmlContext(context).getModel();
            model.acquireReadLock();
            try {
                result = this.getXmlContext(context).getModel().getCachedURLValidationResult(this._url);
            }
            finally {
                model.releaseReadLock();
            }
            if (result == null || result != ValidationResult.OK) {
                return null;
            }
        } else {
            try {
                if (!URLFileSystem.exists((URL)this._url)) {
                    return null;
                }
            }
            catch (RuntimeException re) {
                return null;
            }
        }
        return super.findDeclaration(context);
    }

    @Override
    public String getDeclarationId() {
        return URLDeclarationProvider.getDeclarationId((URL)this._url);
    }

    public URL getReferenceURL() {
        return this._url;
    }

    protected boolean supportsGotoSelf() {
        if (!this.isLocalURL(this.getURL(), this._url)) {
            return false;
        }
        return super.supportsGotoSelf();
    }

    protected String getDisplayNameImpl(DependencyContext context) {
        return "URL Reference: '" + this._url.toString() + "'";
    }

    @Override
    protected String getValueFromId(DependencyContext context, String id) {
        URL url = URLDeclarationProvider.getURL((String)id);
        return url != null ? url.toString() : null;
    }

    protected boolean isLocalURL(URL referencedFrom, URL reference) {
        try {
            if (URLFileSystem.isLocal((URL)reference)) {
                return true;
            }
        }
        catch (RuntimeException re) {
            return true;
        }
        String protocol = reference.getProtocol();
        return "bundleentry".equals(protocol) || "bundleresource".equals(protocol) || referencedFrom.getProtocol().equals(protocol) && referencedFrom.getHost().equals(reference.getHost());
    }

    @Override
    public List<Dependency> getDependencies(Workspace workspace, Project project, boolean isBroken) {
        URL url = this.getReferenceURL();
        if (url != null) {
            FileDependency dependency = new FileDependency(url, project, workspace);
            if (isBroken) {
                dependency.setModifySensitive(false);
            }
            return Collections.singletonList(dependency);
        }
        return Collections.emptyList();
    }

    public static final class RemoteURLIssue
    extends ResultIssue {
        public RemoteURLIssue(Severity severity, String message) {
            super(severity, message);
        }
    }
}

