/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.dependency.url;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.instance.XmlInstanceGrammarProvider;
import oracle.bali.xml.gui.jdev.dependency.url.SchemaLocReference;
import oracle.bali.xml.gui.jdev.dependency.url.UrlReferenceFactory;
import oracle.bali.xml.indexing.IndexingFactory;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.dependency.Reference;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import org.w3c.dom.Node;

public class SchemaLocReferenceFactory
extends UrlReferenceFactory {
    @Override
    public Collection<Reference> getReferences(XmlContext context, Node node, String value) {
        ArrayList<Reference> references = new ArrayList<Reference>();
        List<TokenObject> tokens = this._getTokens(value);
        int numTokens = tokens.size();
        for (int currentLocation = 1; currentLocation < numTokens; currentLocation += 2) {
            TokenObject token = tokens.get(currentLocation);
            URL schemaLocation = context.getURLForRelativePath(token.getToken());
            schemaLocation = this._getAlternateLocationIfAvailable(schemaLocation);
            references.add((Reference)new SchemaLocReference(context, node, token.getStart(), token.getEnd(), schemaLocation));
        }
        return references;
    }

    @Override
    public List<IndexingFactory.IndexEntry> getIndexEntries(QualifiedName elementQN, QualifiedName attrQN, String value) {
        ArrayList<IndexingFactory.IndexEntry> entries = new ArrayList<IndexingFactory.IndexEntry>();
        List<TokenObject> tokens = this._getTokens(value);
        int numTokens = tokens.size();
        for (int currentLocation = 1; currentLocation < numTokens; currentLocation += 2) {
            TokenObject token = tokens.get(currentLocation);
            URL fileUrl = URLFactory.newFileURL((String)token.getToken());
            entries.add(new IndexingFactory.IndexEntry(this.getIndexKey(), URLFileSystem.getFileName((URL)fileUrl), token.getStart(), token.getEnd()));
        }
        return entries;
    }

    private List<TokenObject> _getTokens(String spaceSeparatedList) {
        List<TokenObject> tokens = Collections.emptyList();
        if (spaceSeparatedList != null) {
            String token;
            int iter;
            tokens = new ArrayList<TokenObject>(6);
            char[] chars = spaceSeparatedList.toCharArray();
            int startTokenOffset = -1;
            block3: for (iter = 0; iter < chars.length; ++iter) {
                char currentChar = chars[iter];
                switch (currentChar) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        if (startTokenOffset == -1) continue block3;
                        token = new String(chars, startTokenOffset, iter - startTokenOffset);
                        tokens.add(new TokenObject(token, startTokenOffset, iter));
                        startTokenOffset = -1;
                        continue block3;
                    }
                    default: {
                        if (startTokenOffset != -1) continue block3;
                        startTokenOffset = iter;
                    }
                }
            }
            if (startTokenOffset != -1) {
                token = new String(chars, startTokenOffset, iter - startTokenOffset);
                tokens.add(new TokenObject(token, startTokenOffset, iter));
                startTokenOffset = -1;
            }
        }
        return tokens;
    }

    private URL _getAlternateLocationIfAvailable(URL url) {
        String urlString;
        if (url != null && "http://www.w3.org/2001/xml.xsd".equals(urlString = url.toExternalForm())) {
            return XmlInstanceGrammarProvider.class.getResource("/META-INF/schemas/xml.xsd");
        }
        return url;
    }

    private class TokenObject {
        private int _startIndex;
        private int _endIndex;
        private String _token;

        public TokenObject(String token, int start, int end) {
            this._token = token;
            this._startIndex = start;
            this._endIndex = end;
        }

        public String getToken() {
            return this._token;
        }

        public int getStart() {
            return this._startIndex;
        }

        public int getEnd() {
            return this._endIndex;
        }
    }
}

