/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.dependency;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.dependency.XmlIndexReference;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.dependency.Declaration;
import oracle.bali.xml.model.dependency.DependencyContext;
import oracle.bali.xml.model.dependency.DependencyUtils;
import oracle.bali.xml.model.dependency.FindUsagesCallback;
import oracle.bali.xml.model.dependency.Reference;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dependency.Scope;
import oracle.ide.index.IndexManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.QueryResult;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import org.w3c.dom.Node;

public class IndexingUtils {
    private static final Logger _LOGGER = Logger.getLogger(IndexingUtils.class.getName());
    private static final String _DEFAULT_AUDITOR_CLASS_NAME = "oracle.jdevimpl.audit.core.DefaultAuditor";

    public static Collection<Reference> getReferences(Scope scope, String key, String value) {
        return IndexingUtils.getReferences(scope, key, value, null);
    }

    public static Collection<Reference> getReferences(Scope scope, String key, String value, String extension) {
        FindUsagesCallback callback = new FindUsagesCallback();
        IndexingUtils.getReferences(null, null, callback, scope, key, value, extension);
        return callback.getReferences();
    }

    public static void getReferences(DependencyContext context, Declaration declaration, FindUsagesCallback callback, Scope scope, String key, String value) {
        IndexingUtils.getReferences(context, declaration, callback, scope, key, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void getReferences(DependencyContext context, Declaration declaration, FindUsagesCallback callback, Scope scope, String key, String value, String extension) {
        manager = IndexManager.getIndexManager();
        var8_8 = scope.getProjects().iterator();
        block15: while (var8_8.hasNext() != false) {
            project = (Project)var8_8.next();
            index = manager.getIndex(project);
            criteria = new QueryCriteria();
            if (extension != null && !"".equals(extension)) {
                criteria.put((Object)"file.extension", (Object)extension);
            }
            criteria.put((Object)key, (Object)value);
            try {
                queryTask = index.queryEx(criteria);
                callback.addCancelListener(new FindUsagesCallback.FindUsagesCancelListener(){

                    public void handleCancel() {
                        if (!queryTask.isDone()) {
                            queryTask.cancel();
                        }
                    }
                });
                uniqueIndexReferences = new HashSet<NodeAndDomRange>();
                results = (Collection)queryTask.get();
                var15_18 = results.iterator();
                while (true) {
                    block28: {
                        if (!var15_18.hasNext()) continue block15;
                        result = (QueryResult)var15_18.next();
                        url = result.getURL();
                        if (callback.isCancelled()) {
                            return;
                        }
                        if (!scope.isIncluded(project, url)) continue;
                        try {
                            block29: {
                                ideNode = NodeFactory.findOrCreate((URL)url);
                                if (ideNode == null) continue;
                                ideContext = new Context(Ide.getActiveWorkspace(), project);
                                ideContext.setNode(ideNode);
                                xmlContext = JDevXmlContext.getXmlContext(ideContext);
                                model = xmlContext.getModel();
                                model.acquireReadLock();
                                try {
                                    node = model.getDomModel().getNodeAtOffset(result.getOffset());
                                    if (node == null) break block28;
                                    if (node.getNodeType() != 8) {
                                        if (!(DomUtils.isDocument((Node)node) || DomUtils.isElement((Node)node) || DomUtils.isNodeType((Node)node, (int)10))) {
                                            node = node.getParentNode();
                                        }
                                        if ((attrs = node.getAttributes()) != null) {
                                            for (j = 0; j < attrs.getLength(); ++j) {
                                                attr = attrs.item(j);
                                                offsets = new int[2];
                                                model.getDomModel().getTextOffsets(attr, offsets);
                                                if (offsets[0] > result.getOffset() || offsets[1] < result.getOffset() + result.getLength()) continue;
                                                node = attr;
                                                break;
                                            }
                                        }
                                    }
                                    nodeRefs = DependencyUtils.getReferences((XmlContext)xmlContext, (Node)node);
lbl48:
                                    // 5 sources

                                    for (Reference nodeRef : nodeRefs) {
                                        if (callback.isCancelled()) {
                                            break block29;
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    break block28;
                                }
                                catch (Throwable var27_32) {
                                    model.releaseReadLock();
                                    throw var27_32;
                                }
                            }
                            model.releaseReadLock();
                            return;
                        }
                        catch (Exception e) {
                            IndexingUtils._LOGGER.log(Level.WARNING, "Error creating xmlContext for " + url.toString(), e);
                            continue;
                        }
lbl-1000:
                        // 1 sources

                        {
                            block30: {
                                if (!(nodeRef instanceof XmlIndexReference)) ** GOTO lbl48
                                if (declaration == null) break block30;
                                indRef = (XmlIndexReference)nodeRef;
                                if (indRef.isReferenceFor(context, declaration) && uniqueIndexReferences.add(new NodeAndDomRange(url, ((XmlIndexReference)nodeRef).getDomRange(context)))) {
                                    callback.addReference((Reference)indRef);
                                }
                                ** GOTO lbl48
                            }
                            if (!uniqueIndexReferences.add(new NodeAndDomRange(url, ((XmlIndexReference)nodeRef).getDomRange(context)))) ** GOTO lbl48
                            callback.addReference(nodeRef);
                            ** GOTO lbl48
                        }
                    }
                    model.releaseReadLock();
                }
            }
            catch (InterruptedException ie) {
                stackTraceElement = ie.getStackTrace();
                i = 0;
                while (true) {
                    if (i >= stackTraceElement.length) continue block15;
                    if (stackTraceElement[i].getClassName().compareTo("oracle.jdevimpl.audit.core.DefaultAuditor") == 0) {
                        throw new CancellationException();
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                IndexingUtils._LOGGER.log(Level.WARNING, "Error querying index for project" + project.getShortLabel(), ex);
            }
            finally {
                index.release();
            }
        }
    }
}

