/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev;

import oracle.ide.ceditor.CodeEditor;
import oracle.ide.explorer.Explorer;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ide.inspector.InspectorManager;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;

public final class JDevInspectableViewTracker
implements ActiveViewListener,
ViewListener {
    public static final JDevInspectableViewTracker INSTANCE = new JDevInspectableViewTracker();
    private View _lastView;
    private boolean _wasCodeEditorLast;

    public void activeViewChanged(ActiveViewEvent e) {
        View newView = e.getNewView();
        if (newView != null) {
            if (InspectorManager.getInspectorManager().supportsInspection(newView)) {
                this._switchLastView(newView);
                this._wasCodeEditorLast = false;
            } else if (newView instanceof CodeEditor) {
                this._switchLastView(null);
                this._wasCodeEditorLast = true;
            }
        }
    }

    private void _switchLastView(View newView) {
        if (newView != this._lastView) {
            if (this._lastView != null) {
                this._lastView.removeViewListener((ViewListener)this);
            }
            this._lastView = newView;
            if (this._lastView != null) {
                this._lastView.addViewListener((ViewListener)this);
            }
        }
    }

    public void viewActivated(ViewEvent e) {
    }

    public void viewDeactivated(ViewEvent e) {
    }

    public void viewClosed(ViewEvent e) {
        this._lastView = null;
    }

    public View getLastViewSupportingInspection(View askingView) {
        if (this._lastView != null) {
            return this._lastView instanceof ExplorerWindow ? ((ExplorerWindow)this._lastView).getExplorer() : this._lastView;
        }
        if (this._wasCodeEditorLast && askingView instanceof Explorer) {
            return askingView;
        }
        return null;
    }

    private JDevInspectableViewTracker() {
    }
}

