/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin;

import java.awt.Component;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.addin.CheckSyntaxLog;
import oracle.bali.xml.addin.CheckSyntaxMessage;
import oracle.bali.xml.addin.CheckSyntaxPlugin;
import oracle.bali.xml.addin.SchemaRegistryAddin;
import oracle.bali.xml.addin.XMLEditorAddin;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.schema.OracleSchema;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.message.MessageCategory;
import oracle.bali.xml.model.message.XmlModelMessage;
import oracle.bali.xml.model.message.XmlModelMessageLog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.LineNavigationPoint;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.log.DefaultLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.model.Node;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.xml.dtd.grammar.DtdGrammar;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class CheckSyntaxController
implements ContextMenuListener,
Controller,
DynamicMenuListener {
    private static final String KEY_ERROR = "XMLADDIN.ERROR_OCCURED";
    private static final String KEY_WARNING = "XMLADDIN.WARNING_OCCURED";
    private static final String KEY_PROJECT = "XMLADDIN.PROJECT";
    private static final String KEY_VALIDATE_XML = "XMLADDIN.VALIDATE_XML";
    private static final String KEY_VALIDATE_XML_PAGE = "XMLADDIN.VALIDATE_XML_PAGE";
    private static final String KEY_VALIDATE_MESSAGE = "XMLADDIN.VALIDATE_XML_MESSAGE";
    private static final String KEY_VALIDATING = "XMLADDIN.VALIDATING";
    private static final String KEY_NO_VALIDATE_ERRORS = "XMLADDIN.VALIDATE_NO_ERRORS";
    private static final String KEY_VALIDATE_ERRORS = "XMLADDIN.VALIDATE_ERRORS";
    private static final int ID_CMD_VALIDATE_XML = Ide.findOrCreateCmdID((String)"ValidateXMLCommand");
    private JMenuItem _validateMenu;
    private JMenuItem _dynamicMenu;
    private static CheckSyntaxLogPage _validateLogPage;
    private static CopyOnWriteArraySet _noValidationClasses;
    private static CopyOnWriteArraySet _schemaValidationClasses;
    private static ConcurrentHashMap _dtdValidationClasses;
    private static ConcurrentHashMap _customValidationPlugins;

    public static void registerForNoValidation(Class xmlSourceNodeSubclass) {
        if (XMLSourceNode.isXmlSourceNodeSubclass(xmlSourceNodeSubclass)) {
            _noValidationClasses.add(xmlSourceNodeSubclass);
        }
    }

    public static void registerForSchemaValidation(Class xmlSourceNodeSubclass) {
        if (XMLSourceNode.isXmlSourceNodeSubclass(xmlSourceNodeSubclass)) {
            _schemaValidationClasses.add(xmlSourceNodeSubclass);
        }
    }

    public static void registerForDTDValidation(Class xmlSourceNodeSubclass, URL localDtdUrl) {
        if (XMLSourceNode.isXmlSourceNodeSubclass(xmlSourceNodeSubclass)) {
            _dtdValidationClasses.put(xmlSourceNodeSubclass, localDtdUrl);
        }
    }

    public static void registerForCustomValidation(Class xmlSourceNodeSubclass, CheckSyntaxPlugin plugin) {
        if (XMLSourceNode.isXmlSourceNodeSubclass(xmlSourceNodeSubclass)) {
            _customValidationPlugins.put(xmlSourceNodeSubclass, plugin);
        }
    }

    public JComponent[] gatherDynamicActions(Context context) {
        if (context.getNode() != null) {
            Class<?> c = context.getNode().getClass();
            if (context.getView() instanceof CodeEditor && XMLSourceNode.isXmlSourceNodeSubclass(c) && this._checkIfAllowed(c)) {
                if (this._dynamicMenu == null) {
                    this._dynamicMenu = this._buildMenu((MenuManager)context.getView().getContextMenu());
                }
                return new JComponent[]{this._dynamicMenu};
            }
        }
        return null;
    }

    public void menuWillShow(ContextMenu popup) {
        Class<?> sourceNodeClass;
        Editor currentEditor = EditorManager.getEditorManager().getCurrentEditor();
        if (popup.getContext().getView() == currentEditor && !(currentEditor instanceof CodeEditor)) {
            return;
        }
        Context context = popup.getContext();
        Node sourceNode = context.getNode();
        if (sourceNode != null && XMLSourceNode.isXmlSourceNodeSubclass(sourceNodeClass = sourceNode.getClass())) {
            if (this._validateMenu == null) {
                this._validateMenu = this._buildMenu((MenuManager)popup);
            }
            if (this._checkIfAllowed(sourceNodeClass)) {
                popup.add((Component)this._validateMenu, MenuConstants.SECTION_DYNAMIC_CTXT_MENU);
            }
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        Node sourceNode;
        int cmdId = action.getCommandId();
        if (cmdId == ID_CMD_VALIDATE_XML && (sourceNode = context.getNode()) != null) {
            this.checkXmlSyntax(context, true);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == ID_CMD_VALIDATE_XML) {
            Class<?> sourceNodeClass;
            Node sourceNode = context.getNode();
            if (sourceNode != null && this._checkIfAllowed(sourceNodeClass = sourceNode.getClass())) {
                action.setEnabled(CheckSyntaxController._getDocumentElement(context) != null);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckSyntaxLog checkXmlSyntax(Context context, boolean displayMessage) {
        CheckSyntaxLog checkSyntaxLog;
        block36: {
            checkSyntaxLog = new CheckSyntaxLog();
            Node sourceNode = context.getNode();
            if (displayMessage) {
                this._displayPreParseMessage(context);
            }
            if (!(sourceNode instanceof XMLSourceNode)) {
                return checkSyntaxLog;
            }
            XMLSourceNode xmlSourceNode = (XMLSourceNode)sourceNode;
            Class<?> sourceNodeClass = sourceNode.getClass();
            boolean useGrammarValidation = false;
            boolean useDtdValidation = false;
            boolean useSchemaValidation = false;
            URL localDtdUrl = null;
            CheckSyntaxPlugin plugin = (CheckSyntaxPlugin)_customValidationPlugins.get(sourceNodeClass);
            if (_dtdValidationClasses.containsKey(sourceNodeClass)) {
                localDtdUrl = (URL)_dtdValidationClasses.get(sourceNodeClass);
                if (localDtdUrl != null) {
                    useDtdValidation = true;
                }
            } else if (_schemaValidationClasses.contains(sourceNodeClass)) {
                useSchemaValidation = true;
            } else {
                useGrammarValidation = true;
            }
            SchemaRegistryAddin.loadSchema((oracle.ide.model.Element)xmlSourceNode);
            JDevXmlContext xmlContext = JDevXmlContext.getXmlContext(context);
            XmlModel xmlModel = xmlContext.getModel();
            xmlModel.acquireReadLock();
            try {
                XmlModelMessageLog modelLog;
                List modelMessages;
                DOMParser parser = new DOMParser();
                parser.setDoctype(new DTD());
                if (useDtdValidation) {
                    parser.setValidationMode(2);
                    org.w3c.dom.Node rootElement = CheckSyntaxController._getDocumentElement(context);
                    if (rootElement != null) {
                        try {
                            parser.parseDTD(localDtdUrl, rootElement.getNodeName());
                        }
                        catch (Exception e) {
                            parser.setDoctype(new DTD());
                        }
                    }
                } else if (useSchemaValidation) {
                    DtdGrammar dtdGrammar;
                    URL location;
                    Grammar grammar = this.getGrammarForRootNamespace(xmlContext);
                    if (grammar instanceof OracleSchema) {
                        OracleSchema rootSchema = (OracleSchema)grammar;
                        XMLSchema xdkSchema = rootSchema.getFactory().getXMLSchema();
                        if (xdkSchema != null) {
                            parser.setValidationMode(3);
                            parser.setXMLSchema((Object)xdkSchema);
                        }
                    } else if (grammar instanceof DtdGrammar && (location = (dtdGrammar = (DtdGrammar)grammar).getLocation()) != null) {
                        parser.setValidationMode(2);
                        org.w3c.dom.Node rootElement = CheckSyntaxController._getDocumentElement(context);
                        if (rootElement != null) {
                            try {
                                parser.parseDTD(location, rootElement.getNodeName());
                            }
                            catch (Exception e) {
                                parser.setDoctype(new DTD());
                            }
                        }
                    }
                }
                parser.showWarnings(true);
                parser.setErrorHandler((ErrorHandler)checkSyntaxLog);
                try {
                    TextBuffer textBuffer = xmlSourceNode.acquireTextBuffer();
                    char[] chars = textBuffer.getChars(0, textBuffer.getLength());
                    xmlSourceNode.releaseTextBuffer();
                    CharArrayReader reader = new CharArrayReader(chars);
                    parser.parse((Reader)reader);
                }
                catch (XMLParseException textBuffer) {
                }
                catch (SAXException textBuffer) {
                }
                catch (IOException textBuffer) {
                    // empty catch block
                }
                Document domDocument = xmlContext.getModel().getDocument();
                if (xmlSourceNode == null) break block36;
                if (useGrammarValidation && !(modelMessages = (modelLog = xmlModel.getXmlModelInternalMessageLog()).getMessages(MessageCategory.GRAMMAR_VALIDITY)).isEmpty()) {
                    TextBuffer textBuffer = xmlSourceNode.acquireTextBuffer();
                    try {
                        LineMap lineMap = textBuffer.getLineMap();
                        for (XmlModelMessage message : modelMessages) {
                            int startOffset = message.getTextStartOffset();
                            int lineNumber = 0;
                            int columnNumber = 0;
                            if (startOffset >= 0 && startOffset < textBuffer.getLength()) {
                                lineNumber = lineMap.getLineFromOffset(startOffset);
                                columnNumber = startOffset - lineMap.getLineStartOffset(lineNumber);
                                ++lineNumber;
                                ++columnNumber;
                            }
                            if (message.isError()) {
                                checkSyntaxLog.error(message.getShortDescription(), message.getLongDescription(), lineNumber, columnNumber);
                                continue;
                            }
                            if (!message.isWarning()) continue;
                            checkSyntaxLog.warning(message.getShortDescription(), message.getLongDescription(), lineNumber, columnNumber);
                        }
                    }
                    finally {
                        xmlSourceNode.releaseTextBuffer();
                    }
                }
                if (plugin != null) {
                    plugin.performCustomValidation(context, xmlSourceNode, domDocument, checkSyntaxLog);
                }
            }
            finally {
                xmlModel.releaseReadLock();
            }
        }
        if (displayMessage) {
            this._displayPostParseMessage(context, checkSyntaxLog);
        }
        return checkSyntaxLog;
    }

    private boolean _checkIfAllowed(Class clazz) {
        return this._checkIfAllowed(clazz, true);
    }

    private boolean _checkIfAllowed(Class clazz, boolean checkSchemaAndDtd) {
        if (_noValidationClasses.contains(clazz)) {
            return false;
        }
        if (checkSchemaAndDtd && (_schemaValidationClasses.contains(clazz) || _dtdValidationClasses.get(clazz) != null)) {
            return true;
        }
        if (XMLSourceNode.class.equals((Object)clazz)) {
            return true;
        }
        if (XMLSourceNode.isXmlSourceNodeSubclass(clazz)) {
            Class superClass = clazz.getSuperclass();
            return this._checkIfAllowed(superClass, false);
        }
        return false;
    }

    private void _displayPreParseMessage(Context context) {
        Node sourceNode = context.getNode();
        if (sourceNode != null) {
            LogManager manager = LogManager.getLogManager();
            if (!manager.isLogVisible()) {
                manager.showLog();
            }
            String message = XMLEditorAddin.getTranslatedString(KEY_VALIDATE_MESSAGE);
            manager.getMsgPage().log((Object)message);
            String fileMessage = XMLEditorAddin.getTranslatedString(KEY_VALIDATING);
            MessageFormat f = new MessageFormat(fileMessage);
            Object[] args = new Object[]{sourceNode.getLongLabel()};
            manager.getMsgPage().log((Object)("   " + f.format(args)));
        }
    }

    private void _displayPostParseMessage(Context context, CheckSyntaxLog checkSyntaxLog) {
        if (checkSyntaxLog == null) {
            return;
        }
        LogManager manager = LogManager.getLogManager();
        if (checkSyntaxLog.hasMessages()) {
            List errors = checkSyntaxLog.getErrors();
            List warnings = checkSyntaxLog.getWarnings();
            Integer errorCount = new Integer(errors.size());
            Integer warningCount = new Integer(warnings.size());
            String errorMessage = XMLEditorAddin.getTranslatedString(KEY_VALIDATE_ERRORS);
            MessageFormat errorFormat = new MessageFormat(errorMessage);
            Object[] errorArgs = new Object[]{errorCount, warningCount};
            manager.getMsgPage().log((Object)errorFormat.format(errorArgs));
            if (_validateLogPage == null) {
                _validateLogPage = new CheckSyntaxLogPage("ValidateXMLLogPage", KEY_VALIDATE_XML_PAGE);
            }
            _validateLogPage.log(context, checkSyntaxLog);
        } else {
            manager.getMsgPage().log((Object)XMLEditorAddin.getTranslatedString(KEY_NO_VALIDATE_ERRORS));
            if (_validateLogPage != null) {
                _validateLogPage.clearAll();
                manager.removePage((LogPage)_validateLogPage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Grammar getGrammarForRootNamespace(JDevXmlContext xmlContext) {
        Grammar grammar = null;
        GrammarProvider grammarProvider = xmlContext.getGrammarProvider();
        XmlModel model = xmlContext.getModel();
        model.acquireReadLock();
        try {
            Element rootElement;
            Document domDocument = model.getDocument();
            if (domDocument != null && (rootElement = domDocument.getDocumentElement()) != null) {
                String rootNamespace = rootElement.getNamespaceURI();
                grammar = grammarProvider.getGrammarForNamespace(rootNamespace);
            }
        }
        finally {
            model.releaseReadLock();
        }
        return grammar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static org.w3c.dom.Node _getDocumentElement(Context ideContext) {
        JDevXmlContext xmlContext = JDevXmlContext.getXmlContext(ideContext);
        xmlContext.getModel().acquireReadLock();
        try {
            Document document = xmlContext.getModel().getDocument();
            if (document != null) {
                Element element = document.getDocumentElement();
                return element;
            }
        }
        finally {
            xmlContext.getModel().releaseReadLock();
        }
        return null;
    }

    private synchronized JMenuItem _buildMenu(MenuManager mgr) {
        String translatedString = XMLEditorAddin.getTranslatedString(KEY_VALIDATE_XML);
        String name = StringUtils.stripMnemonic((String)translatedString);
        Integer mnemonic = new Integer(StringUtils.getMnemonicKeyCode((String)translatedString));
        IdeAction action = IdeAction.get((int)ID_CMD_VALIDATE_XML, null, (String)name, (String)null, (Integer)mnemonic, null, null, (boolean)true);
        action.addController((Controller)this);
        return mgr.createMenuItem((ToggleAction)action, 3.0f);
    }

    static {
        _noValidationClasses = new CopyOnWriteArraySet();
        _schemaValidationClasses = new CopyOnWriteArraySet();
        _dtdValidationClasses = new ConcurrentHashMap();
        _customValidationPlugins = new ConcurrentHashMap();
    }

    private class TreeData {
        private final CheckSyntaxMessage _message;
        private final String _displayText;
        private final boolean _isError;

        public TreeData(CheckSyntaxMessage message, String displayText, boolean isError) {
            this._message = message;
            this._displayText = displayText;
            this._isError = isError;
        }

        public CheckSyntaxMessage getCheckSyntaxMessage() {
            return this._message;
        }

        public boolean isError() {
            return this._isError;
        }

        public String toString() {
            return this._displayText;
        }
    }

    private class CheckSyntaxLogPage
    extends DefaultLogPage {
        private Context _context;

        public CheckSyntaxLogPage(String viewID, String key) {
            super(new ViewId(viewID, XMLEditorAddin.getTranslatedString(key)), null, true);
        }

        public HelpInfo getHelpInfo() {
            return new HelpInfo("f1_idelogwindowgen_html");
        }

        public void log(Context context, CheckSyntaxLog checkSyntaxLog) {
            this.clearAll();
            this.show();
            if (this.getCurrentView() != this.getTree()) {
                this.setCurrentView(this.getTree());
            }
            this._context = context;
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            DefaultTreeModel model = new DefaultTreeModel(root);
            DefaultMutableTreeNode parent = root;
            if (this._context.getProject() != null) {
                String project = XMLEditorAddin.getTranslatedString(CheckSyntaxController.KEY_PROJECT);
                MessageFormat mf = new MessageFormat(project);
                Object[] args = new Object[]{this._context.getProject().getShortLabel()};
                String projectName = mf.format(args);
                DefaultMutableTreeNode projectNode = new DefaultMutableTreeNode(projectName);
                root.add(projectNode);
                parent = projectNode;
            }
            String fileName = this._context.getNode().getLongLabel();
            DefaultMutableTreeNode file = new DefaultMutableTreeNode(fileName);
            parent.add(file);
            List errors = checkSyntaxLog.getErrors();
            this._log(file, errors, true);
            List warnings = checkSyntaxLog.getWarnings();
            this._log(file, warnings, false);
            this.getTree().setModel(model);
            this.getTree().setCellRenderer(new MessageCellRenderer());
            for (int i = 0; i < this.getTree().getRowCount(); ++i) {
                this.getTree().expandRow(i);
            }
        }

        private void _log(DefaultMutableTreeNode parent, List messages, boolean isError) {
            if (messages.isEmpty()) {
                return;
            }
            String key = isError ? CheckSyntaxController.KEY_ERROR : CheckSyntaxController.KEY_WARNING;
            String translatedText = XMLEditorAddin.getTranslatedString(key);
            MessageFormat mf = new MessageFormat(translatedText);
            CheckSyntaxMessage message2 = null;
            String description = null;
            for (CheckSyntaxMessage message2 : messages) {
                description = message2.getShortDescription();
                Object[] args = new Object[]{new Integer(message2.getLineNumber()), new Integer(message2.getColumnNumber()), description};
                TreeData data = new TreeData(message2, mf.format(args), isError);
                parent.add(new DefaultMutableTreeNode(data));
            }
        }

        protected void activateObject(Object obj) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
            TreeData data = (TreeData)node.getUserObject();
            CheckSyntaxMessage message = data.getCheckSyntaxMessage();
            final int column = message.getColumnNumber();
            final int row = message.getLineNumber();
            final Context c = this._context;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    NavigationManager nm = NavigationManager.getNavigationManager();
                    LineNavigationPoint p = new LineNavigationPoint(c, row, column, true);
                    try {
                        p.setExplicit(true);
                        if (nm != null) {
                            nm.navigateTo((NavigationPoint)p);
                        } else {
                            p.navigate();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            SwingUtilities.invokeLater(r);
        }

        private final class MessageCellRenderer
        extends DefaultTreeCellRenderer {
            private MessageCellRenderer() {
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                TreeData node;
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                Object obj = ((DefaultMutableTreeNode)value).getUserObject();
                if (leaf && obj instanceof TreeData && (node = (TreeData)obj) != null) {
                    if (node.isError()) {
                        this.setIcon(OracleIcons.getIcon((String)"error.png"));
                    } else {
                        this.setIcon(OracleIcons.getIcon((String)"warning.png"));
                    }
                }
                return this;
            }
        }
    }
}

