/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.scriptrunner.providers;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedPasswordFieldsProvider;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.util.Pair;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.IdeUtil;
import oracle.javatools.util.ClosureException;
import oracle.javatools.util.SwingClosure;

public class GuiPromptedPasswordFieldsProvider
implements IGetPromptedPasswordFieldsProvider {
    private static final Logger LOGGER = Logger.getLogger(GuiPromptedPasswordFieldsProvider.class.getName());
    private final String ENCODING = "UTF-8";
    ScriptRunnerContext m_ctx;

    public Pair<String, String> passwordGetPassword(ScriptRunnerContext scriptRunnerContext, String string, String string2) {
        this.m_ctx = scriptRunnerContext;
        ThreePasswords threePasswords = new ThreePasswords(string.equals(string2) || string2 == null, string, string2, scriptRunnerContext.getCurrentConnection());
        try {
            threePasswords.run();
        }
        catch (ClosureException closureException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, closureException.getStackTrace()[0].toString(), closureException);
            return null;
        }
        String[] stringArray = threePasswords.getResult();
        if (stringArray[3].equals("CONNECT EXCEPTION")) {
            this.report(ScriptRunnerDbArb.getString((String)"FAILED_TO_VALIDATE_USER"));
            return null;
        }
        if (stringArray[3].equals("NO CLICK")) {
            return null;
        }
        if (stringArray[1] != null && !stringArray[1].equals(stringArray[2])) {
            this.report(ScriptRunnerDbArb.getString((String)"PASSWORDS_DO_NOT_MATCH"));
            return null;
        }
        return new Pair((Object)stringArray[2], (Object)stringArray[0]);
    }

    protected void report(String string) {
        WrapListenBufferOutputStream wrapListenBufferOutputStream = this.m_ctx.getOutputStream();
        if (wrapListenBufferOutputStream != null) {
            try {
                wrapListenBufferOutputStream.write(string.getBytes("UTF-8"));
                wrapListenBufferOutputStream.write(10);
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
    }

    private static class ThreePasswords
    extends SwingClosure {
        private String m_localPassword;
        private String m_newPass1;
        private String m_newPass2;
        private String m_user;
        private String m_alterUser;
        private Connection m_lconn;
        private String m_errorOut = null;
        boolean m_showUsers;

        ThreePasswords(boolean bl, String string, String string2, Connection connection) {
            this.m_user = string;
            this.m_lconn = connection;
            this.m_showUsers = bl;
            this.m_alterUser = string2;
        }

        String[] getResult() {
            return new String[]{this.m_localPassword, this.m_newPass1, this.m_newPass2, this.m_errorOut};
        }

        public void runImpl() {
            JPasswordField jPasswordField;
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            int n = 0;
            if (this.m_showUsers) {
                n = 1;
                jPasswordField = new JPasswordField();
                JLabel jLabel = new JLabel(ScriptRunnerDbArb.format((String)"PASSWORD_FOR", (Object[])new Object[]{this.m_user}));
                jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                jPanel.add((Component)jPasswordField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                Object var1_5 = null;
                jPasswordField = null;
            }
            JLabel jLabel = new JLabel(ScriptRunnerDbArb.format((String)"NEW_PASSWORD_FOR", (Object[])new Object[]{this.m_alterUser}));
            final JPasswordField jPasswordField2 = new JPasswordField();
            jPanel.add((Component)jLabel, new GridBagConstraints(0, n + 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            jPanel.add((Component)jPasswordField2, new GridBagConstraints(1, n + 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            JLabel jLabel2 = new JLabel(ScriptRunnerDbArb.getString((String)"NEW_PASSWORD_AGAIN"));
            final JPasswordField jPasswordField3 = new JPasswordField();
            jPanel.add((Component)jLabel2, new GridBagConstraints(0, n + 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            jPanel.add((Component)jPasswordField3, new GridBagConstraints(1, n + 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            jPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, n + 3, 1, 0, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            final JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)ScriptRunnerDbArb.getString((String)"NEW_PASSWORD"), (int)10);
            jEWTDialog.setDefaultButton(8);
            this.m_errorOut = "NO CLICK";
            ActionListener actionListener = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (jPasswordField != null) {
                        m_localPassword = new String(jPasswordField.getPassword());
                    }
                    m_newPass1 = new String(jPasswordField2.getPassword());
                    m_newPass2 = new String(jPasswordField3.getPassword());
                    if (m_showUsers) {
                        Properties properties = new Properties();
                        properties.setProperty("user", '\"' + m_user + '\"');
                        char[] cArray = jPasswordField.getPassword();
                        String string = new String(cArray);
                        properties.setProperty("password", string);
                        if (m_user.equalsIgnoreCase("SYS")) {
                            properties.setProperty("internal_logon", "SYSDBA");
                        }
                        Connection connection = null;
                        try {
                            String string2 = m_lconn.getMetaData().getURL();
                            connection = DriverManager.getConnection(string2, properties);
                            m_errorOut = "OK";
                        }
                        catch (Exception exception) {
                            connection = null;
                            m_errorOut = "CONNECT EXCEPTION";
                        }
                        finally {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (SQLException sQLException) {}
                            }
                        }
                    } else {
                        m_errorOut = "OK";
                    }
                    jEWTDialog.setVisible(false);
                    jEWTDialog.dispose();
                }
            };
            jEWTDialog.addActionListener(actionListener);
            jEWTDialog.setSize(jPanel.getPreferredSize().width * 250 / 100, 120 + n * 20);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
            jEWTDialog.setVisible(true);
        }
    }
}

