/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils.exceptions;

import java.awt.Component;
import java.awt.Window;
import java.sql.SQLException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.IExceptionHandler;
import oracle.dbtools.raptor.utils.SQLExceptionListenerRegistry;
import oracle.dbtools.raptor.utils.exceptions.Messages;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.CanceledException;
import oracle.javatools.util.SwingUtils;

public class UIExceptionHandler
implements IExceptionHandler {
    private static IExceptionHandler handler;
    private static Throwable hitException;
    private static final String DEFAULT_TITLE;

    public static void setHandler(IExceptionHandler iExceptionHandler) {
        handler = iExceptionHandler;
    }

    public Throwable wasException() {
        return hitException;
    }

    public void reset() {
        hitException = null;
    }

    public void handleException(Throwable throwable) {
        this.handleException(null, throwable);
    }

    public void handleException(final String string, final Throwable throwable) {
        hitException = throwable;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (throwable instanceof TaskException || throwable instanceof ExecutionException) {
                    UIExceptionHandler.this.handleException((Exception)throwable.getCause());
                } else if (!UIExceptionHandler.isCancel(throwable)) {
                    if (throwable instanceof SQLException) {
                        SQLErrorDialog.showErrorDialog(string, SwingUtils.getMainWindow(), DEFAULT_TITLE, (SQLException)throwable);
                    } else {
                        Throwable throwable2 = throwable.getCause();
                        if (throwable2 instanceof SQLException) {
                            SQLErrorDialog.showErrorDialog(string, SwingUtils.getMainWindow(), DEFAULT_TITLE, (SQLException)throwable2);
                        } else {
                            ExceptionDialog.showExceptionDialog((Component)SwingUtils.getMainWindow(), (Throwable)throwable);
                        }
                    }
                }
            }
        });
    }

    private static boolean isCancel(Throwable throwable) {
        return throwable instanceof ConnectionCanceledException || throwable.getCause() instanceof ConnectionCanceledException || throwable instanceof CanceledException;
    }

    public void handleException(Exception exception, String string, int n) {
        hitException = exception;
        if (exception instanceof SQLException) {
            SQLErrorDialog.showErrorDialog(null, SwingUtils.getMainWindow(), DEFAULT_TITLE, (SQLException)exception, string, n);
        } else {
            ExceptionDialog.showExceptionDialog((Window)SwingUtils.getMainWindow(), (Exception)exception);
        }
    }

    public void handleException(final Exception exception, final String string, final int n, final int n2, final int n3) {
        hitException = exception;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (exception instanceof SQLException) {
                    SQLErrorDialog.showErrorDialog(null, SwingUtils.getMainWindow(), DEFAULT_TITLE, (SQLException)exception, string, n, n2, n3);
                } else {
                    ExceptionDialog.showExceptionDialog((Window)SwingUtils.getMainWindow(), (Exception)exception);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public boolean handleExceptionWithAction(Exception exception, String string, String string2, String string3) {
        hitException = exception;
        if (string3 == null || string3.length() <= 0) {
            string3 = Messages.getString(string3);
        }
        if (string2 == null || string2.length() <= 0) {
            string2 = Messages.getString(string2);
        }
        return SQLErrorDialog.showErrorWithActionsDialog(null, (Component)Ide.getMainWindow(), string, (SQLException)exception, Messages.getString(string2), Messages.getString(string3));
    }

    public void handleException(Exception exception, String string, String string2, int n, int n2, int n3) {
        hitException = exception;
        if (!SQLExceptionListenerRegistry.listenForError((String)string, (String)string2, (Exception)exception)) {
            if (string2 != null && string2.length() > 0) {
                this.handleException(exception, string2, n, n2, n3);
            } else {
                this.handleException(exception);
            }
        }
    }

    public void handleException(SQLException sQLException, String string, String string2, int n) {
        if (!SQLExceptionListenerRegistry.listenForError((String)string, (String)string2, (Exception)sQLException)) {
            if (string2 != null && string2.length() > 0) {
                this.handleException(sQLException, string2, n);
            } else {
                this.handleException(sQLException);
            }
        }
    }

    public void handleException(Exception exception, String string) {
        if (exception instanceof SQLException) {
            this.handleException((SQLException)exception, string, null, 0);
        } else {
            this.handleException(exception);
        }
    }

    public void handleException(Exception exception, String string, boolean bl, boolean bl2) {
        if (!bl) {
            this.handleException(exception, string);
        } else {
            SQLExceptionListenerRegistry.listenForError((String)string, null, (Exception)exception);
            if (bl2) {
                Logger.getLogger("").log(Level.SEVERE, exception.getMessage());
            }
        }
    }

    static {
        hitException = null;
        DEFAULT_TITLE = Messages.getString("Error Encountered");
    }
}

