/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import oracle.gss.util.NLSLocale;

public class ZipFileWriter {
    private static ZipFileWriter singleton = null;
    private static final int BUFFER = 2048;
    private String _zipFileName = null;
    private String _javaCharSet = null;
    private String _lineSeparator = null;
    private long _currentLineNum = 0L;
    private ZipOutputStream _zipOut = null;

    public ZipFileWriter(String string, String string2) throws Exception {
        this.initialize();
        this.openSource(string, string2);
    }

    public ZipFileWriter() {
        this.initialize();
    }

    public static ZipFileWriter getInstance() {
        if (singleton == null) {
            singleton = new ZipFileWriter();
        }
        return singleton;
    }

    public void initialize() {
        this._lineSeparator = System.getProperty("line.separator");
        this._javaCharSet = null;
        this._zipOut = null;
        this._currentLineNum = 0L;
    }

    public void createZipFile(String string, ArrayList<String> arrayList, ArrayList<String> arrayList2, boolean bl) throws Exception {
        ZipOutputStream zipOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            zipOutputStream.setMethod(8);
            byte[] byArray = new byte[2048];
            ArrayList<String> arrayList3 = arrayList2 != null ? arrayList2 : arrayList;
            for (int i = 0; i < arrayList.size(); ++i) {
                int n;
                bufferedInputStream = new BufferedInputStream(new FileInputStream(arrayList.get(i)), 2048);
                File file = new File(arrayList.get(i));
                ZipEntry zipEntry = new ZipEntry(arrayList3.get(i));
                zipEntry.setSize(file.length());
                zipEntry.setTime(file.lastModified());
                zipOutputStream.putNextEntry(zipEntry);
                while ((n = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                    zipOutputStream.write(byArray, 0, n);
                }
                bufferedInputStream.close();
            }
            if (bl) {
                this.deleteFiles(arrayList);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
    }

    public void addFile(String string, boolean bl, boolean bl2) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        this.addFiles(arrayList, bl, bl2);
    }

    public void addFiles(ArrayList<String> arrayList, boolean bl, boolean bl2) throws Exception {
        BufferedInputStream bufferedInputStream = null;
        try {
            byte[] byArray = new byte[2048];
            for (String string : arrayList) {
                int n;
                System.out.println("Adding to Zip file: " + string);
                bufferedInputStream = new BufferedInputStream(new FileInputStream(string), 2048);
                File file = new File(string);
                ZipEntry zipEntry = new ZipEntry(file.getName());
                zipEntry.setSize(file.length());
                zipEntry.setTime(file.lastModified());
                this._zipOut.putNextEntry(zipEntry);
                while ((n = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                    this._zipOut.write(byArray, 0, n);
                }
            }
            if (bl) {
                this.deleteFiles(arrayList);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (!bl2 && this._zipOut != null) {
                this._zipOut.close();
            }
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
    }

    public boolean deleteFiles(ArrayList<String> arrayList) throws Exception {
        try {
            for (String string : arrayList) {
                File file = new File(string);
                file.delete();
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public void createEntry(String string) throws Exception {
        if (this._zipOut != null) {
            ZipEntry zipEntry = new ZipEntry(string);
            this._zipOut.putNextEntry(zipEntry);
        }
    }

    public void openSource(String string, String string2) throws Exception {
        this._zipFileName = string;
        NLSLocale nLSLocale = NLSLocale.getInstance();
        this._javaCharSet = string2 != null ? nLSLocale.getJavaCharset(string2) : nLSLocale.getJavaCharset("UTF8");
        this._zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
        this._zipOut.setMethod(8);
    }

    public void closeSource() throws Exception {
        if (this._zipOut != null) {
            this._zipOut.flush();
            this._zipOut.close();
        }
    }

    public long getLineCount() {
        return this._currentLineNum;
    }

    public String getSourceName() {
        return this._zipFileName;
    }

    public void writeLine(String string) throws Exception {
        String string2 = string + this._lineSeparator;
        if (this._zipOut != null) {
            if (this._javaCharSet != null) {
                this._zipOut.write(string2.getBytes(this._javaCharSet));
            } else {
                this._zipOut.write(string2.getBytes());
            }
            ++this._currentLineNum;
        }
    }

    public void flush() throws Exception {
        if (this._zipOut != null) {
            this._zipOut.flush();
        }
    }
}

