/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.Component;
import java.awt.Graphics;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dbtools.raptor.controls.NumberOverlayIcon;
import oracle.dbtools.raptor.controls.grid.AbstractRaptorGridModel;
import oracle.dbtools.raptor.controls.grid.GridColumn;
import oracle.dbtools.raptor.controls.grid.GridColumnSortParameter;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.images.BaseRaptorImages;

public class ColumnHeaderCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    public static final ColumnHeaderCellRenderer INSTANCE = new ColumnHeaderCellRenderer();

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JComponent jComponent;
        this.setHorizontalAlignment(2);
        if (jTable != null && (jComponent = jTable.getTableHeader()) != null) {
            this.setForeground(jComponent.getForeground());
            this.setBackground(jComponent.getBackground());
            this.setFont(jComponent.getFont());
        }
        this.setText(object == null ? "" : object.toString());
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        if (jTable instanceof RaptorGridTable) {
            try {
                int n3;
                List<? extends GridColumn> list;
                jComponent = (RaptorGridTable)jTable;
                AbstractRaptorGridModel abstractRaptorGridModel = ((RaptorGridTable)jComponent).getGridModel();
                if (abstractRaptorGridModel != null && (list = abstractRaptorGridModel.getGridColumns()) != null && list.size() > 0 && (n3 = jTable.convertColumnIndexToModel(n2)) != -1) {
                    GridColumn gridColumn = list.get(n3);
                    Icon icon = null;
                    if (gridColumn.isSortable()) {
                        GridColumnSortParameter gridColumnSortParameter = gridColumn.getSortParameter();
                        if (gridColumnSortParameter != null) {
                            icon = this.getSortIcon(gridColumnSortParameter.getSortDir(), gridColumn);
                            icon = NumberOverlayIcon.getIcon(icon, gridColumnSortParameter.getSortOrder());
                        } else {
                            icon = this.getSortIcon(null, gridColumn);
                        }
                    }
                    this.setIcon(icon);
                    this.revalidate();
                    this.paintAll(this.getGraphics());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    protected Icon getSortIcon(GridColumnSortParameter.SortDir sortDir, GridColumn gridColumn) {
        if (sortDir == GridColumnSortParameter.SortDir.ASCENDING) {
            return BaseRaptorImages.getIcon("SORTASCENDING_ENA");
        }
        if (sortDir == GridColumnSortParameter.SortDir.DESCENDING) {
            return BaseRaptorImages.getIcon("SORTDESCENDING_ENA");
        }
        return BaseRaptorImages.getIcon("SORTNONE_ENA");
    }
}

