/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask.internal.test;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.utils.SimpleIdeCore;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RaptorTaskTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        SimpleIdeCore.initIde();
        System.setSecurityManager(null);
    }

    @Test
    public void testTaskFailure() {
        RaptorTask<Boolean> raptorTask = new RaptorTask<Boolean>("Test1", false, IRaptorTaskRunMode.NO_GUI){

            protected Boolean doWork() {
                throw new NullPointerException("null pointer");
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                System.out.println("task failed");
                junit.framework.Assert.assertNotNull((Object)raptorTaskEvent.getThrowable());
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                System.out.println("task finished");
                Assert.fail((String)"Task finished");
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        try {
            raptorTask.getResult();
            Assert.fail((String)"failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetResult() {
        TaskListener taskListener = new TaskListener();
        taskListener.messages = new String[]{"Task Running", "stage 1", "stage 2", "stage 3"};
        taskListener.statuses = new IRaptorTaskStatus[]{IRaptorTaskStatus.RUNNABLE, IRaptorTaskStatus.FINISHED};
        taskListener.progresses = new int[]{30, 60, 90};
        RaptorTask<Boolean> raptorTask = new RaptorTask<Boolean>("Test1", false, IRaptorTaskRunMode.NO_GUI){

            protected Boolean doWork() {
                for (int i = 0; i < 3; ++i) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        Assert.fail((String)interruptedException.getMessage());
                        break;
                    }
                    this.setMessage("stage " + (i + 1));
                    this.getDescriptor().makeProgress(30);
                }
                return Boolean.TRUE;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)taskListener);
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        try {
            Assert.assertTrue((boolean)((Boolean)raptorTask.getResult()));
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testCancel() {
        for (int i = 0; i < 20; ++i) {
            RaptorTask<Boolean> raptorTask = new RaptorTask<Boolean>("Test1", false, IRaptorTaskRunMode.NO_GUI){

                protected Boolean doWork() throws TaskException {
                    for (int i = 0; i < 3; ++i) {
                        try {
                            this.checkCanProceed();
                        }
                        catch (ExecutionException executionException) {
                            return Boolean.FALSE;
                        }
                        for (int j = 0; j < 10000; ++j) {
                        }
                        this.setMessage("stage " + (i + 1));
                        this.getDescriptor().makeProgress(30);
                    }
                    return Boolean.TRUE;
                }
            };
            TaskListener taskListener = new TaskListener((RaptorTask)raptorTask){
                final /* synthetic */ RaptorTask val$task;
                {
                    this.val$task = raptorTask;
                }

                @Override
                public void progressChanged(RaptorTaskEvent raptorTaskEvent) {
                    super.progressChanged(raptorTaskEvent);
                    if (raptorTaskEvent.getTaskDescriptor().getProgress() == 60) {
                        this.val$task.requestCancel();
                    }
                }
            };
            taskListener.messages = new String[]{"Task Running", "stage 1", "stage 2", "Task Canceled"};
            taskListener.statuses = new IRaptorTaskStatus[]{IRaptorTaskStatus.RUNNABLE, IRaptorTaskStatus.FINISHED};
            taskListener.progresses = new int[]{30, 60};
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)taskListener);
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
            try {
                Assert.assertTrue((String)"Task result should false", ((Boolean)raptorTask.getResult() == false ? 1 : 0) != 0);
            }
            catch (Exception exception) {
                if (exception instanceof CancellationException) {
                    return;
                }
                Assert.fail((String)exception.getMessage());
            }
            Assert.assertTrue((String)"Task cancel flag should be true", (boolean)raptorTask.getDescriptor().isCancelled());
        }
    }

    private class TaskListener
    implements IRaptorTaskListener {
        private int lastMessage;
        private int lastStatus;
        private int lastProgress;
        String[] messages;
        IRaptorTaskStatus[] statuses;
        int[] progresses;

        private TaskListener() {
        }

        public void reset() {
            this.lastProgress = 0;
            this.lastStatus = 0;
            this.lastMessage = 0;
        }

        public void messageChanged(RaptorTaskEvent raptorTaskEvent) {
            Assert.assertSame((Object)raptorTaskEvent.getPropertyChanged(), (Object)RaptorTaskDescriptor.PROPERTY.MESSAGE);
            Assert.assertTrue((String)"Messages size mismatch", (this.messages.length > this.lastMessage ? 1 : 0) != 0);
            Assert.assertEquals((String)"Error", (Object)this.messages[this.lastMessage++], (Object)raptorTaskEvent.getTaskDescriptor().getMessage());
        }

        public void progressChanged(RaptorTaskEvent raptorTaskEvent) {
            Assert.assertSame((Object)raptorTaskEvent.getPropertyChanged(), (Object)RaptorTaskDescriptor.PROPERTY.PROGRESS);
            Assert.assertTrue((String)"Progress size mismatch", (this.progresses.length > this.lastProgress ? 1 : 0) != 0);
            Assert.assertEquals((String)"Error", (Object)this.progresses[this.lastProgress++], (Object)raptorTaskEvent.getTaskDescriptor().getProgress());
        }

        public void stateChanged(RaptorTaskEvent raptorTaskEvent) {
            Assert.assertSame((Object)raptorTaskEvent.getPropertyChanged(), (Object)RaptorTaskDescriptor.PROPERTY.STATUS);
            Assert.assertTrue((String)"Status size mismatch", (this.statuses.length > this.lastStatus ? 1 : 0) != 0);
            Assert.assertEquals((String)"Error", (Object)this.statuses[this.lastStatus++], (Object)raptorTaskEvent.getTaskDescriptor().getStatus());
            if (raptorTaskEvent.getTaskDescriptor().getStatus() == IRaptorTaskStatus.FINISHED || raptorTaskEvent.getTaskDescriptor().getStatus() == IRaptorTaskStatus.FAILED) {
                Assert.assertSame((String)"Statuses-", (Object)this.statuses.length, (Object)this.lastStatus);
                Assert.assertSame((String)"Progresses-", (Object)this.progresses.length, (Object)this.lastProgress);
                Assert.assertSame((String)"Messages-", (Object)this.messages.length, (Object)this.lastMessage);
            }
        }
    }
}

