/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import oracle.bali.ewt.text.MultiLineToolTip;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.internal.Messages;
import oracle.dbtools.raptor.backgroundTask.internal.SimpleRaptorTaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;

public class RaptorTaskUI
extends SimpleRaptorTaskUI {
    private static final Dimension PANEL_DIMENSION = new Dimension(400, 100);
    protected JLabel statusLabel;
    protected JLabel nameLabel;
    protected JLabel messageLable;
    protected IRaptorTaskStatus _status;

    public RaptorTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
        super(raptorTaskDescriptor);
    }

    public RaptorTaskUI() {
    }

    @Override
    protected void setState(RaptorTaskDescriptor raptorTaskDescriptor) {
        super.setState(raptorTaskDescriptor);
        this.statusLabel.setIcon(raptorTaskDescriptor.getIcon());
        String string = "[" + this.getFormattedTime(raptorTaskDescriptor) + "] ";
        if (raptorTaskDescriptor.getMessage() != null) {
            string = string + raptorTaskDescriptor.getMessage();
        }
        this.messageLable.setText(string);
        String string2 = raptorTaskDescriptor.getStatus().value();
        if (raptorTaskDescriptor.isCancelled()) {
            string2 = Messages.getString("SimpleRaptorTaskUI.Cancelled");
        }
        this.nameLabel.setText(raptorTaskDescriptor.getName() + " (" + string2 + ")");
    }

    @Override
    protected void initGUI() {
        this.statusLabel = new JLabel(){

            @Override
            public JToolTip createToolTip() {
                MultiLineToolTip multiLineToolTip = new MultiLineToolTip();
                multiLineToolTip.setTextWrapper(WordWrapper.getTextWrapper());
                return multiLineToolTip;
            }
        };
        this.nameLabel = new JLabel();
        this.messageLable = new JLabel(){

            @Override
            public JToolTip createToolTip() {
                MultiLineToolTip multiLineToolTip = new MultiLineToolTip();
                multiLineToolTip.setTextWrapper(WordWrapper.getTextWrapper());
                return multiLineToolTip;
            }
        };
        this.setBorder(BorderFactory.createEmptyBorder());
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.statusLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        JPanel jPanel = this.createSimpleTaskUI();
        this.add((Component)jPanel, gridBagConstraints);
        this._progressComp.setStringPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.messageLable, gridBagConstraints);
    }

    @Override
    public String getMessage() {
        return this.messageLable.getText();
    }

    @Override
    public String getName() {
        if (null == this.nameLabel) {
            return super.getName();
        }
        return this.nameLabel.getText();
    }

    @Override
    public void setMessage(String string) {
        this.messageLable.setText(string);
        this.messageLable.setToolTipText(string);
    }

    @Override
    public void setName(String string) {
        this.nameLabel.setText(string);
        this.nameLabel.setToolTipText(string);
    }

    public static void main(String[] stringArray) {
        RaptorTaskDescriptor raptorTaskDescriptor = new RaptorTaskDescriptor("Task 1");
        raptorTaskDescriptor.setMessage("Running");
        raptorTaskDescriptor.setProgress(80);
        RaptorTaskUI raptorTaskUI = new RaptorTaskUI(raptorTaskDescriptor);
        JFrame jFrame = new JFrame("TaskUI Demo");
        jFrame.setDefaultCloseOperation(3);
        jFrame.add(raptorTaskUI);
        jFrame.setSize(PANEL_DIMENSION);
        jFrame.setVisible(true);
    }

    @Override
    public ITaskUI getNewTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
        return new RaptorTaskUI(raptorTaskDescriptor);
    }
}

