/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.adapter;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import oracle.adf.share.jndi.SecureRefAddr;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.adapter.ReferenceWorker;

public class DatabaseProviderFactory1212
implements ObjectFactory {
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (obj instanceof Reference) {
            ConnectionCreator cc;
            DatabaseProvider provider;
            String connectionName;
            Reference ref = (Reference)obj;
            if (name != null && name.size() > 0) {
                connectionName = name.toString();
                provider = new DatabaseProvider(connectionName, null);
            } else {
                connectionName = null;
                provider = new DatabaseProvider();
            }
            ReferenceWorker encryptionWorker = this.getReferenceWorker(true, environment);
            provider.setReferenceWorker(encryptionWorker);
            RefAddr typeAddr = ref.get("subtype");
            provider.setProperty("subtype", typeAddr == null ? null : (String)typeAddr.getContent());
            try {
                cc = DatabaseProvider.getCreator(provider);
            }
            catch (SQLException sqe) {
                cc = null;
            }
            Enumeration<RefAddr> iter = ref.getAll();
            while (iter.hasMoreElements()) {
                Object refValue;
                RefAddr next = iter.nextElement();
                String refName = next.getType();
                if (next instanceof SecureRefAddr) {
                    refValue = ((SecureRefAddr)next).getCharValue();
                } else if (cc != null && cc.shouldEncrypt(refName)) {
                    ReferenceWorker decryptionWorker = this.getReferenceWorker(false, environment);
                    if (decryptionWorker == null) {
                        DatabaseProviderHelper.getLogger().warning("Cannot decrypt password, don't know how.");
                        refValue = null;
                    } else {
                        refValue = decryptionWorker.decrypt(next, connectionName);
                    }
                } else {
                    refValue = next.getContent();
                }
                if (refValue instanceof String) {
                    provider.setProperty(refName, (String)refValue);
                    continue;
                }
                if (refValue instanceof char[]) {
                    provider.setCredential(refName, (char[])refValue);
                    continue;
                }
                if (refValue == null) continue;
                DatabaseProviderHelper.getLogger().warning(connectionName + ": invalid value for property " + refName);
            }
            return provider;
        }
        return null;
    }

    protected ReferenceWorker getReferenceWorker(boolean encryption, Hashtable environment) {
        Object worker;
        ReferenceWorker retval = null;
        if (environment != null && (worker = environment.get(ReferenceWorker.KEY)) instanceof ReferenceWorker) {
            retval = (ReferenceWorker)worker;
        }
        if (retval == null) {
            retval = DatabaseProviderHelper.getDefaultWorker(encryption);
        }
        return retval;
    }
}

