/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.worker;

import oracle.bali.ewt.worker.AbstractWorker;
import oracle.bali.ewt.worker.EventThreadWorkerQueue;
import oracle.bali.ewt.worker.InvocationContext;
import oracle.bali.ewt.worker.WorkerQueue;
import oracle.bali.ewt.worker.WorkerStatusListener;
import oracle.bali.ewt.worker.WorkerUtils;

public class DeferringWorkerStatus
implements WorkerStatusListener {
    static final int __ACTION_PREPARED = 0;
    static final int __ACTION_PRERUN = 1;
    static final int __ACTION_SUCCEEDED = 2;
    static final int __ACTION_FAILED = 3;
    private WorkerStatusListener _deferredListener = null;
    private WorkerQueue _deferredQueue = null;

    public DeferringWorkerStatus(WorkerStatusListener eventThreadListener) {
        this(eventThreadListener, EventThreadWorkerQueue.getEventThreadWorkerQueue());
    }

    public DeferringWorkerStatus(WorkerStatusListener deferredListener, WorkerQueue deferredQueue) {
        if (deferredListener == null || deferredQueue == null) {
            throw new IllegalArgumentException();
        }
        this._deferredListener = deferredListener;
        this._deferredQueue = deferredQueue;
    }

    @Override
    public void workerPrepared(InvocationContext invokeContext) {
        if (this._deferredQueue.isInWorkerQueueThread()) {
            this._deferredListener.workerPrepared(invokeContext);
        } else {
            this._defer(invokeContext, 0);
        }
    }

    @Override
    public void workerPrerun(InvocationContext invokeContext) {
        if (this._deferredQueue.isInWorkerQueueThread()) {
            this._deferredListener.workerPrerun(invokeContext);
        } else {
            this._defer(invokeContext, 1);
        }
    }

    @Override
    public void workerSucceeded(InvocationContext invokeContext) {
        if (this._deferredQueue.isInWorkerQueueThread()) {
            this._deferredListener.workerSucceeded(invokeContext);
        } else {
            this._defer(invokeContext, 2);
        }
    }

    @Override
    public void workerFailed(InvocationContext invokeContext) {
        if (this._deferredQueue.isInWorkerQueueThread()) {
            this._deferredListener.workerFailed(invokeContext);
        } else {
            this._defer(invokeContext, 3);
        }
    }

    private void _defer(InvocationContext invokeContext, int action) {
        this._deferredQueue.invokeLater(new DeferredStatusWorker(invokeContext, action), WorkerUtils.createMinimalParameterDictionary(), null);
    }

    private class DeferredStatusWorker
    extends AbstractWorker {
        private InvocationContext _invokeContext;
        private int _action = -1;

        public DeferredStatusWorker(InvocationContext invokeContext, int action) {
            this._invokeContext = invokeContext;
            this._action = action;
            this.setWorkerQueue(DeferringWorkerStatus.this._deferredQueue);
        }

        @Override
        public Object runWorker(InvocationContext invokeContext) throws Throwable {
            switch (this._action) {
                case 0: {
                    DeferringWorkerStatus.this._deferredListener.workerPrepared(this._invokeContext);
                    break;
                }
                case 1: {
                    DeferringWorkerStatus.this._deferredListener.workerPrerun(this._invokeContext);
                    break;
                }
                case 2: {
                    DeferringWorkerStatus.this._deferredListener.workerSucceeded(this._invokeContext);
                    break;
                }
                case 3: {
                    DeferringWorkerStatus.this._deferredListener.workerFailed(this._invokeContext);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return null;
        }
    }
}

