/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.util;

import java.awt.Component;
import java.util.Locale;

public final class LocaleUtils {
    public static final Locale ARABIC = new Locale("ar", "", "");
    public static final Locale CHINESE = Locale.CHINESE;
    public static final Locale CZECH = new Locale("cs", "", "");
    public static final Locale DANISH = new Locale("da", "", "");
    public static final Locale DUTCH = new Locale("nl", "", "");
    public static final Locale ENGLISH = Locale.ENGLISH;
    public static final Locale FINNISH = new Locale("fi", "", "");
    public static final Locale FRENCH = Locale.FRENCH;
    public static final Locale GERMAN = Locale.GERMAN;
    public static final Locale HUNGARIAN = new Locale("hu", "", "");
    public static final Locale ITALIAN = Locale.ITALIAN;
    public static final Locale JAPANESE = Locale.JAPANESE;
    public static final Locale KOREAN = Locale.KOREAN;
    public static final Locale NORWEGIAN = new Locale("no", "", "");
    public static final Locale POLISH = new Locale("pl", "", "");
    public static final Locale PORTUGUESE = new Locale("pt", "", "");
    public static final Locale RUSSIAN = new Locale("ru", "", "");
    public static final Locale SLOVAK = new Locale("sk", "", "");
    public static final Locale SPANISH = new Locale("es", "", "");
    public static final Locale SWEDISH = new Locale("sv", "", "");
    public static final Locale SIMPLIFIED_CHINESE = Locale.SIMPLIFIED_CHINESE;
    public static final Locale TRADITIONAL_CHINESE = Locale.TRADITIONAL_CHINESE;
    public static final Locale BRAZIL = new Locale("pt", "BR", "");
    public static final Locale CANADA = Locale.CANADA;
    public static final Locale CANADA_FRENCH = Locale.CANADA_FRENCH;
    public static final Locale CHINA = Locale.CHINA;
    public static final Locale FRANCE = Locale.FRANCE;
    public static final Locale GERMANY = Locale.GERMANY;
    public static final Locale ITALY = Locale.ITALY;
    public static final Locale JAPAN = Locale.JAPAN;
    public static final Locale KOREA = Locale.KOREA;
    public static final Locale PRC = Locale.PRC;
    public static final Locale TAIWAN = Locale.TAIWAN;
    public static final Locale UK = Locale.UK;
    public static final Locale US = Locale.US;
    public static final int DIRECTION_DEFAULT = 0;
    public static final int DIRECTION_LEFTTORIGHT = 1;
    public static final int DIRECTION_RIGHTTOLEFT = 2;
    public static final int ALIGNMENT_DEFAULT = 0;
    public static final int ALIGNMENT_LEFT = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int ALIGNMENT_CENTER = 3;

    private LocaleUtils() {
    }

    public static Locale getDefaultableLocale(Component component) {
        Locale locale = null;
        try {
            locale = component.getLocale();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static int getReadingDirectionForLocale(Locale locale) {
        String language = locale.getLanguage();
        if ("ar".equals(language) || "he".equals(language) || "iw".equals(language)) {
            return 2;
        }
        return 1;
    }

    public static int getAlignmentForReadingDirection(int readingDirection) {
        return readingDirection;
    }
}

