/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.spinBox;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.access.OracleAccessibleRole;
import oracle.bali.ewt.elaf.EWTSpinnerUI;
import oracle.bali.ewt.spinBox.BuddyTextField;
import oracle.bali.ewt.spinBox.NumericSpinBoxModel;
import oracle.bali.ewt.spinBox.SpinAccelerator;
import oracle.bali.ewt.spinBox.SpinBoxModel;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.bali.ewt.spinBox.SpinButton;
import oracle.bali.ewt.spinBox.SpinButtonEvent;
import oracle.bali.ewt.spinBox.SpinButtonListener;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.collection.Range;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.util.IntegerUtils;

public class SpinBox
extends LWComponent
implements Accessible,
SpinButtonListener {
    private SpinButton _spinButton;
    private SpinBuddy _buddy;
    private Component _buddyComponent;
    private Object _value;
    private SpinBoxModel _model;
    private ListenerManager _listeners;
    private static int _sInstanceCounter;
    private static final int _GAP = 1;
    private static final BackGroundChangeListener _BACKGROUND_CHANGE_LISTENER;
    private transient ChangeEvent _changeEvent;
    private SpinListener _spinListener = new SpinListener();

    public SpinBox() {
        this(new BuddyTextField(), new NumericSpinBoxModel(new Range(0, 0)));
    }

    public SpinBox(SpinBuddy buddy, SpinBoxModel model) {
        if (buddy == null) {
            throw new IllegalArgumentException();
        }
        if (model == null) {
            throw new IllegalArgumentException();
        }
        this.addKeyListener(this._spinListener);
        this.addFocusListener(this._spinListener);
        this._spinButton = this.createSpinButton();
        this._spinButton.addSpinButtonListener(this);
        this.setLayout(null);
        this.setSpinBuddy(buddy);
        this.setModel(model);
        this.add(this.getSpinButton());
        this.updateUI();
    }

    @Override
    public void updateUI() {
        this.setUI((EWTSpinnerUI)UIManager.getUI(this));
        this._updateBackground();
    }

    private void _updateBackground() {
        if (this._buddyComponent == null || this.getUIDefaults() == null) {
            return;
        }
        Color c = this._buddyComponent.getBackground();
        if (c == null) {
            c = this.getUIDefaults().getColor("EWTSpinner.background");
        }
        this.setBackground(c);
    }

    @Override
    public String getUIClassID() {
        return "EWTSpinnerUI";
    }

    public void setSpinBuddy(SpinBuddy buddy) {
        if (buddy == null) {
            throw new IllegalArgumentException();
        }
        if (this._buddyComponent != null) {
            this._buddyComponent.removeKeyListener(this._spinListener);
            this._buddyComponent.removeFocusListener(this._spinListener);
            this._buddyComponent.removePropertyChangeListener(_BACKGROUND_CHANGE_LISTENER);
            this.remove(this._buddyComponent);
        }
        this._buddy = buddy;
        this._buddyComponent = (Component)((Object)this._buddy);
        Object value = this.getValue();
        if (value != null) {
            buddy.setValue(value);
        }
        this._buddyComponent.addKeyListener(this._spinListener);
        this._buddyComponent.addFocusListener(this._spinListener);
        this._buddyComponent.addPropertyChangeListener(_BACKGROUND_CHANGE_LISTENER);
        this.add(this._buddyComponent);
    }

    public SpinAccelerator getAccelerator() {
        return this.getSpinButton().getAccelerator();
    }

    public void setAccelerator(SpinAccelerator accelerator) {
        this.getSpinButton().setAccelerator(accelerator);
    }

    public Object getValue() {
        return this._value;
    }

    public SpinBoxModel getModel() {
        return this._model;
    }

    public void setModel(SpinBoxModel model) {
        this._model = model;
        this._buddy.setValue(this._nextElement(true));
        this._updateEnabled();
        this.fireStateChanged();
    }

    public SpinBuddy getSpinBuddy() {
        return this._buddy;
    }

    public void addChangeListener(ChangeListener listener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._listeners.removeListener((EventListener)listener);
    }

    @Override
    public void doLayout() {
        Dimension totalSize = this.getSize();
        int xMargin = UIManager.getInt("EWTSpinner.innerXMargin");
        Component buddy = this._buddyComponent;
        Dimension buddyPref = buddy.getPreferredSize();
        EWTSpinnerUI ui = (EWTSpinnerUI)this.ui;
        ImmInsets i = this.getBorderInsets();
        ImmInsets spinInsets = ui.getSpinButtonInsets(this);
        int leftInset = i.left + xMargin;
        totalSize.width -= leftInset + i.right;
        totalSize.height -= i.top + i.bottom;
        int buddyY = (totalSize.height - buddyPref.height) / 2;
        if (buddyY < 0) {
            buddyY = 0;
            buddyPref.height = totalSize.height;
        }
        SpinButton spin = this.getSpinButton();
        Dimension spinPref = spin.getPreferredSize();
        int spinY = spinInsets.top;
        spinPref.height = totalSize.height - (spinInsets.top + spinInsets.bottom);
        spinPref.width -= spinInsets.left + spinInsets.right;
        if (this.getActualAlignment() != 2) {
            buddy.setBounds(leftInset, buddyY + i.top, totalSize.width - spinPref.width - 1, buddyPref.height);
            spin.setBounds(totalSize.width - spinPref.width + leftInset + spinInsets.left, spinY + i.top, spinPref.width, spinPref.height);
        } else {
            buddy.setBounds(spinPref.width + 1 + leftInset, buddyY + i.top, totalSize.width - spinPref.width - 1, buddyPref.height);
            spin.setBounds(leftInset + spinInsets.left, spinY + i.top, spinPref.width, spinPref.height);
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return !this._buddyComponent.isFocusTraversable();
    }

    @Override
    public void requestFocus() {
        if (this._buddyComponent.isFocusTraversable()) {
            this._buddyComponent.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getSpinButton().setEnabled(enabled);
        this._buddyComponent.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    @Override
    public void setFont(Font f) {
        this._buddyComponent.setFont(f);
        super.setFont(f);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSpinBox();
        }
        return this.accessibleContext;
    }

    @Override
    protected Object getPaintData(Object key) {
        if (key.equals("GapX")) {
            Rectangle bounds = this._spinButton.getBounds();
            if (this.getActualAlignment() != 2) {
                return IntegerUtils.getInteger((int)(bounds.x - 1));
            }
            return IntegerUtils.getInteger((int)(bounds.x + bounds.width));
        }
        return super.getPaintData(key);
    }

    @Override
    protected String paramString() {
        return "value=" + this.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp != this._spinButton && comp != this._buddy) {
            if (!(comp instanceof SpinBuddy)) throw new IllegalArgumentException();
            this.setSpinBuddy((SpinBuddy)((Object)comp));
            return;
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    @Override
    public void spinButtonSpinning(SpinButtonEvent event) {
        if (this._buddyComponent.isFocusTraversable()) {
            this._buddyComponent.requestFocus();
        } else {
            this.requestFocus();
        }
        this.doIncrement(event.getType() == 1);
    }

    protected void fireStateChanged() {
        AccessibleContext ac;
        Enumeration enumer;
        ListenerManager listeners = this._listeners;
        if (listeners != null && (enumer = listeners.getListeners()) != null) {
            while (enumer.hasMoreElements()) {
                ChangeListener listener = (ChangeListener)enumer.nextElement();
                if (this._changeEvent == null) {
                    this._changeEvent = new ChangeEvent(this);
                }
                listener.stateChanged(this._changeEvent);
            }
        }
        if ((ac = this.accessibleContext) != null) {
            ac.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
        }
    }

    protected void doIncrement(boolean increment) {
        this._model.setIteratingForward(increment);
        this.getSpinBuddy().setValue(this._nextElement(false));
        this._updateEnabled();
        this.fireStateChanged();
    }

    protected SpinButton createSpinButton() {
        return new SpinButton(false);
    }

    protected SpinButton getSpinButton() {
        return this._spinButton;
    }

    void _updateEnabled() {
        SpinBoxModel model = this._model;
        SpinButton spin = this.getSpinButton();
        boolean forward = model.isIteratingForward();
        model.setIteratingForward(true);
        spin.setIncrementEnabled(model.hasMoreElements());
        model.setIteratingForward(false);
        spin.setDecrementEnabled(model.hasMoreElements());
        model.setIteratingForward(forward);
    }

    private Object _nextElement(boolean justOne) {
        SpinAccelerator accelerator = this.getAccelerator();
        if (justOne || accelerator == null) {
            this._value = this._model.nextElement();
        } else {
            int skipCount = this._model.remainingElements(accelerator.getIncrement());
            this._value = this._model.skip(skipCount);
        }
        return this._value;
    }

    static {
        _BACKGROUND_CHANGE_LISTENER = new BackGroundChangeListener();
    }

    private static class BackGroundChangeListener
    implements PropertyChangeListener {
        private BackGroundChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            Component buddy;
            Container box;
            if ("background".equals(pe.getPropertyName()) && (box = (buddy = (Component)pe.getSource()).getParent()) instanceof SpinBox && buddy.getBackground() != null) {
                box.setBackground(buddy.getBackground());
            }
        }
    }

    private class SpinListener
    extends KeyAdapter
    implements FocusListener {
        private SpinListener() {
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            boolean modifier;
            SpinButton spin = SpinBox.this.getSpinButton();
            int code = ke.getKeyCode();
            boolean bl = modifier = ke.isAltDown() || ke.isControlDown() || ke.isMetaDown() || ke.isShiftDown();
            if (code != 38 && code != 40 || modifier) {
                spin.setIncrementArmed(false);
                spin.setDecrementArmed(false);
            } else if (!ke.isConsumed()) {
                boolean increment;
                boolean bl2 = increment = code == 38;
                if (increment && spin.isIncrementEnabled() || !increment && spin.isDecrementEnabled()) {
                    if (increment) {
                        spin.setIncrementArmed(true);
                    } else {
                        spin.setDecrementArmed(true);
                    }
                    SpinBox.this.doIncrement(increment);
                    SpinAccelerator accelerator = SpinBox.this.getAccelerator();
                    if (accelerator != null) {
                        accelerator.advance();
                    }
                }
                ke.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent ke) {
            boolean modifier;
            boolean bl = modifier = ke.isAltDown() || ke.isControlDown() || ke.isMetaDown() || ke.isShiftDown();
            if (!modifier && !ke.isConsumed()) {
                switch (ke.getKeyCode()) {
                    case 38: {
                        SpinBox.this.getSpinButton().setIncrementArmed(false);
                        break;
                    }
                    case 40: {
                        SpinBox.this.getSpinButton().setDecrementArmed(false);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                SpinAccelerator accelerator = SpinBox.this.getAccelerator();
                if (accelerator != null) {
                    accelerator.reset();
                }
                ke.consume();
            }
        }

        @Override
        public void focusLost(FocusEvent fe) {
            SpinButton spin = SpinBox.this.getSpinButton();
            spin.setIncrementArmed(false);
            spin.setDecrementArmed(false);
        }

        @Override
        public void focusGained(FocusEvent fe) {
        }
    }

    protected class AccessibleSpinBox
    extends JComponent.AccessibleJComponent {
        protected AccessibleSpinBox() {
            super(SpinBox.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return OracleAccessibleRole.SPIN_BOX;
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return super.getAccessibleName();
        }

        @Override
        public String getAccessibleDescription() {
            if (this.accessibleDescription != null) {
                return this.accessibleDescription;
            }
            return super.getAccessibleDescription();
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (states.contains(AccessibleState.ENABLED)) {
                states.add(AccessibleState.EDITABLE);
            }
            return states;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            SpinBuddy buddy = SpinBox.this.getSpinBuddy();
            if (buddy != null && buddy instanceof Accessible) {
                return ((Accessible)((Object)buddy)).getAccessibleContext().getAccessibleValue();
            }
            return null;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return SpinBox.this.getSpinButton().getAccessibleContext().getAccessibleAction();
        }
    }
}

