/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.shuttle;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.util.FocusUtils;

class ShuttleLayout
implements LayoutManager {
    public static final String FROM_LIST = "FromList";
    public static final String TO_LIST = "ToList";
    public static final String FROM_HEADER = "FromHeader";
    public static final String TO_HEADER = "ToHeader";
    public static final String FROM_FOOTER = "FromFooter";
    public static final String TO_FOOTER = "ToFooter";
    public static final String COMMON_FOOTER = "CommonFooter";
    public static final String SHUTTLE_CONTROL = "ShuttleControl";
    public static final String FROM_REORDER_CONTROL = "FromReorderControl";
    public static final String TO_REORDER_CONTROL = "ToReorderControl";
    private static final String _BOTTOM_RIGHT_CONTROL = "BottomRightControl";
    private static final String _TOP_LEFT_CONTROL = "TopLeftControl";
    private static final int _FOCUS_ROOT = 0;
    private static final int _FROM_HEADER = 1;
    private static final int _TO_HEADER = 2;
    private static final int _FROM_REORDER = 3;
    private static final int _FROM_PICKER = 4;
    private static final int _SHUTTLE = 5;
    private static final int _TO_PICKER = 6;
    private static final int _TO_REORDER = 7;
    private static final int _FROM_FOOTER = 8;
    private static final int _TO_FOOTER = 9;
    private static final int _HEADER_GAP = 0;
    private static final int _FOOTER_GAP = 5;
    private static final int _SHUTTLE_GAP = 5;
    private static final int _INSET = 5;
    private static final int _REORDER_GAP = 5;
    private static final Dimension _ZERO_SIZE = new Dimension(0, 0);
    private Component _fromListComponent;
    private Component _toListComponent;
    private Component _fromListHeader;
    private Component _toListHeader;
    private Component _fromListFooter;
    private Component _toListFooter;
    private Component _commonFooter;
    private Component _shuttleControl;
    private Component _fromReorderControl;
    private Component _toReorderControl;
    private JButton _bottomRightButton;
    private JButton _topLeftButton;
    private Shuttle _shuttle;
    private boolean _reversed = false;
    private boolean _horizontal = true;
    private int _lastDirection = 1;

    public ShuttleLayout(Shuttle shuttle) {
        this._shuttle = shuttle;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (name == FROM_LIST) {
            this._fromListComponent = comp;
        } else if (name == TO_LIST) {
            this._toListComponent = comp;
        } else if (name == FROM_HEADER) {
            this._fromListHeader = comp;
        } else if (name == TO_HEADER) {
            this._toListHeader = comp;
        } else if (name == SHUTTLE_CONTROL) {
            this._shuttleControl = comp;
        } else if (name == FROM_REORDER_CONTROL) {
            this._fromReorderControl = comp;
        } else if (name == TO_REORDER_CONTROL) {
            this._toReorderControl = comp;
        } else if (name == FROM_FOOTER) {
            this._fromListFooter = comp;
        } else if (name == TO_FOOTER) {
            this._toListFooter = comp;
        } else if (name == _BOTTOM_RIGHT_CONTROL) {
            this._bottomRightButton = (JButton)comp;
        } else if (name == _TOP_LEFT_CONTROL) {
            this._topLeftButton = (JButton)comp;
        } else if (name == COMMON_FOOTER) {
            this._commonFooter = comp;
        } else {
            throw new IllegalArgumentException();
        }
        this.updateFocusCycle();
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        boolean lastIndex = false;
        if (comp == this._fromListComponent) {
            this._fromListComponent = null;
        } else if (comp == this._toListComponent) {
            this._toListComponent = null;
        } else if (comp == this._fromListHeader) {
            this._fromListHeader = null;
        } else if (comp == this._toListHeader) {
            this._toListHeader = null;
        } else if (comp == this._shuttleControl) {
            this._shuttleControl = null;
        } else if (comp == this._fromReorderControl) {
            this._fromReorderControl = null;
        } else if (comp == this._toReorderControl) {
            this._toReorderControl = null;
        } else if (comp == this._fromListFooter) {
            this._fromListFooter = null;
        } else if (comp == this._toListFooter) {
            this._toListFooter = null;
        } else if (comp == this._commonFooter) {
            this._commonFooter = null;
        }
        this.updateFocusCycle();
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension dim = this._horizontal ? this._calculateHorizontalSize(this._getPreferredSize(this._fromListComponent), this._getPreferredSize(this._toListComponent), this._getPreferredSize(this._fromListHeader), this._getPreferredSize(this._toListHeader), this._getPreferredSize(this._shuttleControl), this._getPreferredSize(this._fromReorderControl), this._getPreferredSize(this._toReorderControl), this._getPreferredSize(this._fromListFooter), this._getPreferredSize(this._toListFooter), this._getPreferredSize(this._commonFooter)) : this._calculateVerticalSize(this._getPreferredSize(this._fromListComponent), this._getPreferredSize(this._toListComponent), this._getPreferredSize(this._fromListHeader), this._getPreferredSize(this._toListHeader), this._getPreferredSize(this._shuttleControl), this._getPreferredSize(this._fromReorderControl), this._getPreferredSize(this._toReorderControl), this._getPreferredSize(this._fromListFooter), this._getPreferredSize(this._toListFooter), this._getPreferredSize(this._commonFooter));
        Insets inset = parent.getInsets();
        dim.width += inset.left + inset.right;
        dim.height += inset.top + inset.bottom;
        return dim;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension dim = this._horizontal ? this._calculateHorizontalSize(this._getMinimumSize(this._fromListComponent), this._getMinimumSize(this._toListComponent), this._getMinimumSize(this._fromListHeader), this._getMinimumSize(this._toListHeader), this._getMinimumSize(this._shuttleControl), this._getMinimumSize(this._fromReorderControl), this._getMinimumSize(this._toReorderControl), this._getMinimumSize(this._fromListFooter), this._getMinimumSize(this._toListFooter), this._getMinimumSize(this._commonFooter)) : this._calculateVerticalSize(this._getMinimumSize(this._fromListComponent), this._getMinimumSize(this._toListComponent), this._getMinimumSize(this._fromListHeader), this._getMinimumSize(this._toListHeader), this._getMinimumSize(this._shuttleControl), this._getMinimumSize(this._fromReorderControl), this._getMinimumSize(this._toReorderControl), this._getMinimumSize(this._fromListFooter), this._getMinimumSize(this._toListFooter), this._getMinimumSize(this._commonFooter));
        Insets inset = parent.getInsets();
        dim.width += inset.left + inset.right;
        dim.height += inset.top + inset.bottom;
        return dim;
    }

    @Override
    public void layoutContainer(Container parent) {
        JButton dummy;
        Shuttle shuttle = (Shuttle)parent;
        int direction = shuttle.getActualReadingDirection();
        if (direction != this._lastDirection) {
            if (direction == 2) {
                shuttle._setActualLayoutReversed(!shuttle.isLayoutReversed());
            } else if (direction == 1) {
                shuttle._setActualLayoutReversed(shuttle.isLayoutReversed());
            }
            this._lastDirection = direction;
        }
        if (this._bottomRightButton == null) {
            dummy = ShuttleLayout._createBottomRightButton();
            this._shuttle.add((Component)dummy, _BOTTOM_RIGHT_CONTROL);
        }
        if (this._topLeftButton == null) {
            dummy = ShuttleLayout._createTopLeftButton();
            this._shuttle.add((Component)dummy, _TOP_LEFT_CONTROL);
            dummy.setBounds(-1, 0, 0, 0);
        }
        if (this._horizontal) {
            this._layoutHorizontal(parent);
        } else {
            this._layoutVertical(parent);
        }
    }

    public Component getComponent(Object key) {
        if (key == FROM_HEADER) {
            return this._fromListHeader;
        }
        if (key == FROM_FOOTER) {
            return this._fromListFooter;
        }
        if (key == TO_HEADER) {
            return this._toListHeader;
        }
        if (key == TO_FOOTER) {
            return this._toListFooter;
        }
        if (key == COMMON_FOOTER) {
            return this._commonFooter;
        }
        return null;
    }

    public Component getShuttleControl() {
        return this._shuttleControl;
    }

    public void setHorizontalLayout(boolean horizontal) {
        this._horizontal = horizontal;
    }

    public void setReverseLayout(boolean reversed) {
        this._reversed = reversed;
    }

    private void _layoutHorizontal(Container parent) {
        int headerY;
        int shuttleGap = this._getShuttleGap();
        Dimension parentSize = parent.getSize();
        Insets parentInsets = parent.getInsets();
        Dimension fromHeaderPrefSize = this._getPreferredSize(this._fromListHeader);
        Dimension toHeaderPrefSize = this._getPreferredSize(this._toListHeader);
        int headerHeight = Math.max(fromHeaderPrefSize.height, toHeaderPrefSize.height);
        Dimension commonFooterSize = this._getPreferredSize(this._commonFooter);
        Dimension fromFooterPrefSize = this._getPreferredSize(this._fromListFooter);
        Dimension toFooterPrefSize = this._getPreferredSize(this._toListFooter);
        Dimension shuttlePrefSize = this._getPreferredSize(this._shuttleControl);
        Dimension fromReorderPrefSize = this._getPreferredSize(this._fromReorderControl);
        Dimension toReorderPrefSize = this._getPreferredSize(this._toReorderControl);
        int fromReorderWidthAdjustment = fromReorderPrefSize.width;
        int toReorderWidthAdjustment = toReorderPrefSize.width;
        if (fromReorderWidthAdjustment != 0) {
            fromReorderWidthAdjustment += 5;
        }
        if (toReorderWidthAdjustment != 0) {
            toReorderWidthAdjustment += 5;
        }
        int fromListWidth = 0;
        int toListWidth = 0;
        int listCount = 0;
        if (this._fromListComponent != null) {
            ++listCount;
        }
        if (this._toListComponent != null) {
            ++listCount;
        }
        if (listCount == 1) {
            toListWidth = parentSize.width - parentInsets.left - parentInsets.right - shuttlePrefSize.width - shuttleGap * 2 - fromReorderWidthAdjustment - toReorderWidthAdjustment;
            if (this._toListComponent == null) {
                fromListWidth = toListWidth;
                toListWidth = 0;
            }
        } else if (listCount == 2) {
            toListWidth = fromListWidth = (parentSize.width - parentInsets.left - parentInsets.right - shuttlePrefSize.width - shuttleGap * 2 - fromReorderWidthAdjustment - toReorderWidthAdjustment) / 2;
        }
        int leftListX = parentInsets.left;
        if (!this._reversed) {
            if (fromReorderPrefSize != _ZERO_SIZE) {
                leftListX += fromReorderWidthAdjustment;
            }
        } else if (toReorderPrefSize != _ZERO_SIZE) {
            leftListX += toReorderWidthAdjustment;
        }
        int shuttleX = leftListX + shuttleGap;
        int rightListX = (shuttleX += !this._reversed ? fromListWidth : toListWidth) + shuttlePrefSize.width + shuttleGap;
        int toReorderX = !this._reversed ? rightListX + toListWidth + 5 : parentInsets.left;
        int fromReorderX = !this._reversed ? parentInsets.left : rightListX + fromListWidth + 5;
        int fromListX = !this._reversed ? leftListX : rightListX;
        int toListX = !this._reversed ? rightListX : leftListX;
        int listY = headerY = parentInsets.top + 5;
        if (headerHeight > 0) {
            listY += headerHeight + 0;
            if (fromHeaderPrefSize != _ZERO_SIZE) {
                this._fromListHeader.setBounds(fromListX, headerY, fromListWidth, headerHeight);
            }
            if (toHeaderPrefSize != _ZERO_SIZE) {
                this._toListHeader.setBounds(toListX, headerY, toListWidth, headerHeight);
            }
        }
        int fromListHeight = parentSize.height - listY - fromFooterPrefSize.height - commonFooterSize.height - this._getFooterGap() - 5 - parentInsets.bottom;
        int toListHeight = parentSize.height - listY - toFooterPrefSize.height - commonFooterSize.height - this._getFooterGap() - 5 - parentInsets.bottom;
        if (this._fromListComponent != null && this._fromListComponent.isVisible()) {
            this._fromListComponent.setBounds(fromListX, listY, fromListWidth, fromListHeight);
        }
        if (this._toListComponent != null && this._toListComponent.isVisible()) {
            this._toListComponent.setBounds(toListX, listY, toListWidth, toListHeight);
        }
        if (fromFooterPrefSize != _ZERO_SIZE) {
            this._fromListFooter.setBounds(fromListX, listY + fromListHeight + this._getFooterGap(), fromListWidth, fromFooterPrefSize.height);
        }
        if (toFooterPrefSize != _ZERO_SIZE) {
            this._toListFooter.setBounds(toListX, listY + toListHeight + this._getFooterGap(), toListWidth, toFooterPrefSize.height);
        }
        int minListHeight = Math.min(fromListHeight, toListHeight);
        if (shuttlePrefSize != _ZERO_SIZE) {
            this._shuttleControl.setBounds(shuttleX, listY + (minListHeight - shuttlePrefSize.height) / 2, shuttlePrefSize.width, shuttlePrefSize.height);
        }
        if (toReorderPrefSize != _ZERO_SIZE) {
            this._toReorderControl.setBounds(toReorderX, listY + (toListHeight - toReorderPrefSize.height) / 2, toReorderPrefSize.width, toReorderPrefSize.height);
        }
        if (fromReorderPrefSize != _ZERO_SIZE) {
            this._fromReorderControl.setBounds(fromReorderX, listY + (fromListHeight - fromReorderPrefSize.height) / 2, fromReorderPrefSize.width, fromReorderPrefSize.height);
        }
        int y = Math.max(listY + fromListHeight, listY + toListHeight) + this._getFooterGap();
        if (commonFooterSize != _ZERO_SIZE) {
            this._commonFooter.setBounds((parentSize.width - (parentInsets.left + parentInsets.right) - commonFooterSize.width) / 2, y, commonFooterSize.width, commonFooterSize.height);
        }
        this._bottomRightButton.setBounds(rightListX + (this._reversed ? fromListWidth : toListWidth), y, 0, 0);
    }

    private void _layoutVertical(Container parent) {
        int fromReorderY;
        int toReorderY;
        int toFooterY;
        int toHeaderY;
        int toListY;
        int fromFooterY;
        int fromHeaderY;
        int fromListY;
        int bottomFooterY;
        int shuttleGap = this._getShuttleGap();
        Dimension parentSize = parent.getSize();
        Insets parentInsets = parent.getInsets();
        Dimension fromHeaderPrefSize = this._getPreferredSize(this._fromListHeader);
        Dimension toHeaderPrefSize = this._getPreferredSize(this._toListHeader);
        int fromHeaderHeight = fromHeaderPrefSize.height > 0 ? fromHeaderPrefSize.height + 0 : 0;
        int toHeaderHeight = toHeaderPrefSize.height > 0 ? toHeaderPrefSize.height + 0 : 0;
        Dimension fromFooterPrefSize = this._getPreferredSize(this._fromListFooter);
        Dimension toFooterPrefSize = this._getPreferredSize(this._toListFooter);
        Dimension commonFooterPrefSize = this._getPreferredSize(this._commonFooter);
        int fromFooterHeight = fromFooterPrefSize.height > 0 ? fromFooterPrefSize.height + this._getFooterGap() : 0;
        int toFooterHeight = toFooterPrefSize.height > 0 ? toFooterPrefSize.height + this._getFooterGap() : 0;
        int commonFooterHeight = commonFooterPrefSize.height > 0 ? commonFooterPrefSize.height + this._getFooterGap() : 0;
        Dimension shuttlePrefSize = this._getPreferredSize(this._shuttleControl);
        Dimension toReorderPrefSize = this._getPreferredSize(this._toReorderControl);
        Dimension fromReorderPrefSize = this._getPreferredSize(this._fromReorderControl);
        int toReorderWidthAdjustment = toReorderPrefSize.width;
        int fromReorderWidthAdjustment = fromReorderPrefSize.width;
        if (toReorderWidthAdjustment != 0) {
            toReorderWidthAdjustment += 5;
        }
        if (fromReorderWidthAdjustment != 0) {
            fromReorderWidthAdjustment += 5;
        }
        int listWidth = parentSize.width - parentInsets.left - parentInsets.right - Math.max(toReorderWidthAdjustment, fromReorderWidthAdjustment);
        int listX = parentInsets.left;
        int shuttleX = listX + (listWidth - shuttlePrefSize.width) / 2;
        int reorderX = listX + listWidth + 5;
        int baseListHeight = parentSize.height - parentInsets.top - fromHeaderHeight - toHeaderHeight - fromFooterHeight - toFooterHeight - commonFooterHeight - 2 * shuttleGap - shuttlePrefSize.height - parentInsets.bottom;
        if (this._fromListComponent != null && this._toListComponent != null) {
            baseListHeight /= 2;
        }
        int fromListHeight = this._fromListComponent != null ? baseListHeight : 0;
        int toListHeight = this._toListComponent != null ? baseListHeight : 0;
        int topHeaderY = parentInsets.top;
        int topListY = topHeaderY + (this._reversed ? toHeaderHeight : fromHeaderHeight);
        int footerGap = 0;
        if (this._reversed) {
            if (toFooterHeight > 0) {
                footerGap = 5;
            }
        } else if (fromFooterHeight > 0) {
            footerGap = 5;
        }
        int topFooterY = topListY + (this._reversed ? toListHeight : fromListHeight) + footerGap;
        int shuttleY = topFooterY - footerGap + shuttleGap + (this._reversed ? toFooterHeight : fromFooterHeight);
        int bottomHeaderY = shuttleY + shuttlePrefSize.height + shuttleGap;
        int bottomListY = bottomHeaderY + (this._reversed ? fromHeaderHeight : toHeaderHeight);
        int commomFooterY = bottomFooterY = bottomListY + (this._reversed ? fromListHeight : toListHeight) + this._getFooterGap();
        if (!this._reversed) {
            fromListY = topListY;
            fromHeaderY = topHeaderY;
            fromFooterY = topFooterY;
            toListY = bottomListY;
            toHeaderY = bottomHeaderY;
            toFooterY = bottomFooterY;
            toReorderY = bottomListY;
            fromReorderY = topListY;
        } else {
            fromListY = bottomListY;
            fromHeaderY = bottomHeaderY;
            fromFooterY = bottomFooterY;
            toListY = topListY;
            toHeaderY = topHeaderY;
            toFooterY = topFooterY;
            toReorderY = topListY;
            fromReorderY = bottomListY;
        }
        toReorderY += (toListHeight - toReorderPrefSize.height) / 2;
        fromReorderY += (fromListHeight - fromReorderPrefSize.height) / 2;
        if (fromHeaderHeight > 0 && fromHeaderPrefSize != _ZERO_SIZE) {
            this._fromListHeader.setBounds(listX, fromHeaderY, listWidth, fromHeaderPrefSize.height);
        }
        if (toHeaderHeight > 0 && toHeaderPrefSize != _ZERO_SIZE) {
            this._toListHeader.setBounds(listX, toHeaderY, listWidth, toHeaderPrefSize.height);
        }
        if (this._fromListComponent != null && this._fromListComponent.isVisible()) {
            this._fromListComponent.setBounds(listX, fromListY, listWidth, fromListHeight);
        }
        if (this._toListComponent != null && this._toListComponent.isVisible()) {
            this._toListComponent.setBounds(listX, toListY, listWidth, toListHeight);
        }
        if (fromFooterPrefSize != _ZERO_SIZE) {
            this._fromListFooter.setBounds(listX, fromFooterY, listWidth, fromFooterPrefSize.height);
        }
        if (toFooterPrefSize != _ZERO_SIZE) {
            this._toListFooter.setBounds(listX, toFooterY, listWidth, toFooterPrefSize.height);
        }
        if (shuttlePrefSize != _ZERO_SIZE) {
            this._shuttleControl.setBounds(shuttleX, shuttleY, shuttlePrefSize.width, shuttlePrefSize.height);
        }
        if (toReorderPrefSize != _ZERO_SIZE) {
            this._toReorderControl.setBounds(reorderX, toReorderY, toReorderPrefSize.width, toReorderPrefSize.height);
        }
        if (fromReorderPrefSize != _ZERO_SIZE) {
            this._fromReorderControl.setBounds(reorderX, fromReorderY, fromReorderPrefSize.width, fromReorderPrefSize.height);
        }
        if (commonFooterPrefSize != _ZERO_SIZE) {
            this._commonFooter.setBounds(listX + (listWidth - commonFooterPrefSize.width) / 2, commomFooterY, commonFooterPrefSize.width, commonFooterPrefSize.height);
        }
        this._bottomRightButton.setBounds(listX + listWidth, commomFooterY, 0, 0);
    }

    private Dimension _calculateHorizontalSize(Dimension fromListSize, Dimension toListSize, Dimension fromHeaderSize, Dimension toHeaderSize, Dimension shuttleSize, Dimension fromReorderSize, Dimension toReorderSize, Dimension fromFooterSize, Dimension toFooterSize, Dimension commonFooterSize) {
        int footerHeight;
        int shuttleGap = this._getShuttleGap();
        int centerHeight = Math.max(Math.max(Math.max(Math.max(fromListSize.height, fromReorderSize.height), toListSize.height), shuttleSize.height), toReorderSize.height);
        int listWidth = Math.max(Math.max(fromListSize.width, toListSize.width), Math.max(Math.max(fromHeaderSize.width, toHeaderSize.width), Math.max(fromFooterSize.width, toFooterSize.width)));
        int headerHeight = Math.max(fromHeaderSize.height, toHeaderSize.height);
        if (headerHeight > 0) {
            headerHeight += 0;
        }
        if ((footerHeight = Math.max(Math.max(fromFooterSize.height, toFooterSize.height), commonFooterSize.height)) > 0) {
            footerHeight += this._getFooterGap();
        }
        int width = 2 * listWidth + 2 * shuttleGap + shuttleSize.width;
        if (fromReorderSize != _ZERO_SIZE) {
            width += 5 + fromReorderSize.width;
        }
        if (toReorderSize != _ZERO_SIZE) {
            width += 5 + toReorderSize.width;
        }
        return new Dimension(Math.max(width, commonFooterSize.width), headerHeight + centerHeight + footerHeight + 10);
    }

    private Dimension _calculateVerticalSize(Dimension fromListSize, Dimension toListSize, Dimension fromHeaderSize, Dimension toHeaderSize, Dimension shuttleSize, Dimension fromReorderSize, Dimension toReorderSize, Dimension fromFooterSize, Dimension toFooterSize, Dimension commonFooterSize) {
        int shuttleGap = this._getShuttleGap();
        int centerHeight = Math.max(Math.max(Math.max(fromListSize.height, fromReorderSize.height), toListSize.height), toReorderSize.height);
        int listWidth = Math.max(Math.max(shuttleSize.width, Math.max(Math.max(fromListSize.width, toListSize.width), Math.max(Math.max(fromHeaderSize.width, toHeaderSize.width), Math.max(fromFooterSize.width, toFooterSize.width)))), commonFooterSize.width);
        if (fromHeaderSize.height > 0) {
            fromHeaderSize.height += 0;
        }
        if (toHeaderSize.height > 0) {
            toHeaderSize.height += 0;
        }
        if (fromFooterSize.height > 0) {
            fromFooterSize.height += this._getFooterGap();
        }
        if (toFooterSize.height > 0) {
            toFooterSize.height += this._getFooterGap();
        }
        if (commonFooterSize.height > 0) {
            commonFooterSize.height += this._getFooterGap();
        }
        int height = fromHeaderSize.height + toHeaderSize.height + fromFooterSize.height + toFooterSize.height + commonFooterSize.height + centerHeight * 2 + shuttleGap * 2 + shuttleSize.height;
        int width = listWidth;
        if (fromReorderSize != _ZERO_SIZE) {
            width += 5 + fromReorderSize.width;
        } else if (toReorderSize != _ZERO_SIZE) {
            width += 5 + toReorderSize.width;
        }
        return new Dimension(width, height);
    }

    private Dimension _getPreferredSize(Component comp) {
        return comp != null && comp.isVisible() ? comp.getPreferredSize() : _ZERO_SIZE;
    }

    private Dimension _getMinimumSize(Component comp) {
        return comp != null && comp.isVisible() ? comp.getMinimumSize() : _ZERO_SIZE;
    }

    private int _getShuttleGap() {
        return this._shuttleControl != null && this._shuttleControl.getPreferredSize().width > 0 ? 5 : 0;
    }

    private int _getFooterGap() {
        if (this._commonFooter != null && this._commonFooter.isVisible()) {
            return 10;
        }
        if (this._fromListFooter != null && this._fromListFooter.isVisible() || this._toListFooter != null && this._toListFooter.isVisible()) {
            return 5;
        }
        return 0;
    }

    private static void _sGetFocusableComps(Container cont, ArrayList list) {
        if (cont instanceof JComponent && FocusUtils.getAcceptsFocus(cont)) {
            list.add(cont);
        } else if (!cont.isVisible()) {
            return;
        }
        int count = cont.getComponentCount();
        Component temp = null;
        for (int i = 0; i < count; ++i) {
            temp = cont.getComponent(i);
            if (!(temp instanceof Container)) continue;
            ShuttleLayout._sGetFocusableComps((Container)temp, list);
        }
    }

    private void _linkComponents() {
        int i;
        Component[] comps = new Component[]{this._topLeftButton, this._fromListHeader, this._fromListComponent, this._fromListFooter, this._shuttleControl, this._toListHeader, this._toListComponent, this._toListFooter, this._toReorderControl, this._fromReorderControl, this._commonFooter};
        ArrayList<Component> list = new ArrayList<Component>(8);
        int count = comps.length;
        for (i = 0; i < count; ++i) {
            if (!(comps[i] instanceof Container)) continue;
            ShuttleLayout._sGetFocusableComps((Container)comps[i], list);
        }
        if (this._shuttle.getNextFocusableComponent() != null) {
            list.add(this._shuttle.getNextFocusableComponent());
        } else if (this._bottomRightButton != null) {
            list.add(this._bottomRightButton);
        }
        count = list.size();
        for (i = 0; i < count - 1; ++i) {
            ((JComponent)list.get(i)).setNextFocusableComponent((Component)list.get(i + 1));
        }
    }

    public void updateFocusCycle() {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            this._linkComponents();
        } else {
            Component[] comps = new Component[]{this._topLeftButton, this._fromListHeader, this._fromListComponent, this._fromListFooter, this._shuttleControl, this._toListHeader, this._toListComponent, this._toListFooter, this._toReorderControl, this._fromReorderControl, this._commonFooter};
            int lastIndex = -1;
            block0: for (int i = 0; i < comps.length - 1; ++i) {
                if (!(comps[i] instanceof JComponent)) continue;
                lastIndex = i;
                for (int k = i + 1; k < comps.length; ++k) {
                    if (!(comps[k] instanceof JComponent)) continue;
                    lastIndex = k;
                    ((JComponent)comps[i]).setNextFocusableComponent(comps[k]);
                    i = k - 1;
                    continue block0;
                }
            }
            if (lastIndex != -1) {
                ((JComponent)comps[lastIndex]).setNextFocusableComponent(this._bottomRightButton);
            }
            if (this._bottomRightButton != null) {
                this._bottomRightButton.setNextFocusableComponent(this._shuttle.getNextFocusableComponent());
            }
        }
    }

    private static boolean _isFocusable(Component c) {
        return c.isFocusTraversable() && c.isVisible() && c.isEnabled() && FocusUtils.isFocusable(c);
    }

    static Component __getFocusableComponent(Component c) {
        if (FocusUtils.getAcceptsFocus(c)) {
            return c;
        }
        if (c instanceof Container) {
            Container cont = (Container)c;
            int count = cont.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component child = cont.getComponent(i);
                if (!ShuttleLayout._isFocusTraversable(child)) continue;
                return child;
            }
        }
        return null;
    }

    private static boolean _isFocusTraversable(Component c) {
        if (FocusUtils.getAcceptsFocus(c)) {
            return true;
        }
        if (c instanceof Container) {
            Container cont = (Container)c;
            int count = cont.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component child = cont.getComponent(i);
                if (!ShuttleLayout._isFocusTraversable(child)) continue;
                return true;
            }
        }
        return false;
    }

    private static JButton _createBottomRightButton() {
        JButton button = new JButton("");
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            FocusAdapter listener = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    Component temp = FocusUtils.getOppositeComponent(e);
                    if (temp instanceof JComponent && ((JComponent)temp).getNextFocusableComponent() == e.getSource()) {
                        FocusManager.getCurrentManager().focusNextComponent((Component)e.getSource());
                    } else {
                        FocusManager.getCurrentManager().focusPreviousComponent((Component)e.getSource());
                    }
                }
            };
            button.addFocusListener(listener);
        } else {
            button.setEnabled(false);
        }
        return button;
    }

    private static JButton _createTopLeftButton() {
        JButton button = new JButton("");
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            FocusAdapter listener = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    Component temp = FocusUtils.getOppositeComponent(e);
                    JButton but = (JButton)e.getSource();
                    if (but.getNextFocusableComponent() == temp) {
                        FocusManager.getCurrentManager().focusPreviousComponent(but);
                    } else {
                        FocusManager.getCurrentManager().focusNextComponent(but);
                    }
                }
            };
            button.addFocusListener(listener);
        } else {
            button.setEnabled(false);
        }
        return button;
    }
}

