/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.shuttle;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Reorderable2;
import oracle.bali.share.sort.Sort;

public class ReorderableListPicker
extends ListPicker
implements Reorderable2 {
    private static final short _UP = 1;
    private static final short _DOWN = 2;
    private static final short _TOP = 3;
    private static final short _BOTTOM = 4;
    private static final short _DROP = 5;

    public ReorderableListPicker(JList list) {
        super(list);
    }

    @Override
    public void processDnDReorder() {
        this._moveSelection(5);
        this.__resetDropInsertionIndex();
    }

    @Override
    public boolean isSelectionUpwardlyMobile() {
        return this._isSelectionMobile(1);
    }

    @Override
    public boolean isSelectionDownwardlyMobile() {
        return this._isSelectionMobile(2);
    }

    @Override
    public void moveSelectionUp() {
        this._moveSelection(1);
    }

    @Override
    public void moveSelectionDown() {
        this._moveSelection(2);
    }

    @Override
    public boolean isSelectionTopMobile() {
        return this._isSelectionMobile(3);
    }

    @Override
    public boolean isSelectionBottomMobile() {
        return this._isSelectionMobile(4);
    }

    @Override
    public void moveSelectionTop() {
        this._moveSelection(3);
    }

    @Override
    public void moveSelectionBottom() {
        this._moveSelection(4);
    }

    private void _moveSelection(int controlType) {
        JList list = this.getList();
        ListModel model = list.getModel();
        if (!(model instanceof DefaultListModel)) {
            return;
        }
        DefaultListModel dModel = (DefaultListModel)model;
        ListSelectionModel sModel = list.getSelectionModel();
        int[] selectedIndices = list.getSelectedIndices();
        int numSelected = selectedIndices.length;
        if (numSelected > 0) {
            Sort.qSort((int[])selectedIndices, (int)numSelected, (boolean)true);
            if (controlType == 1 || controlType == 2) {
                boolean isUpward = controlType == 1;
                int processed = numSelected - 1;
                while (processed >= 0) {
                    Object curr;
                    int newIndex;
                    int i;
                    int lastInBlock;
                    int firstInBlock = lastInBlock = selectedIndices[processed];
                    int tempIndex = processed;
                    while (tempIndex > 0 && selectedIndices[tempIndex] - selectedIndices[tempIndex - 1] == 1) {
                        --tempIndex;
                        --firstInBlock;
                    }
                    if (isUpward) {
                        for (i = lastInBlock; i >= firstInBlock; --i) {
                            newIndex = firstInBlock - 1;
                            curr = dModel.remove(lastInBlock);
                            dModel.add(newIndex, curr);
                        }
                    } else {
                        for (i = firstInBlock; i <= lastInBlock; ++i) {
                            newIndex = lastInBlock + 1;
                            curr = dModel.remove(firstInBlock);
                            dModel.add(newIndex, curr);
                        }
                    }
                    processed = tempIndex - 1;
                }
                for (int i = 0; i < selectedIndices.length; ++i) {
                    int selection = isUpward ? selectedIndices[i] - 1 : selectedIndices[i] + 1;
                    sModel.addSelectionInterval(selection, selection);
                }
                int visibileIndex = isUpward ? selectedIndices[0] - 1 : selectedIndices[0] + 1;
                this.getList().ensureIndexIsVisible(visibileIndex);
            } else if (controlType == 3) {
                for (int i = 0; i < numSelected; ++i) {
                    dModel.add(i, dModel.remove(selectedIndices[i]));
                }
                sModel.setSelectionInterval(0, numSelected - 1);
                this.getList().ensureIndexIsVisible(0);
            } else if (controlType == 4) {
                int modelSize = dModel.getSize();
                int temp = modelSize - 1;
                for (int i = numSelected - 1; i >= 0; --i) {
                    dModel.add(temp, dModel.remove(selectedIndices[i]));
                    --temp;
                }
                sModel.setSelectionInterval(modelSize - numSelected, modelSize - 1);
                this.getList().ensureIndexIsVisible(modelSize - 1);
            } else if (controlType == 5) {
                int itemsBeforeDropPoint = 0;
                int dropIndex = this.__getDropInsertionIndex();
                if (dropIndex == -1) {
                    dropIndex = model.getSize() - 1;
                }
                Object[] sel = new Object[numSelected];
                for (int start = numSelected - 1; start >= 0; --start) {
                    sel[start] = dModel.remove(selectedIndices[start]);
                    if (selectedIndices[start] >= dropIndex) continue;
                    ++itemsBeforeDropPoint;
                }
                if (itemsBeforeDropPoint > 0) {
                    dropIndex -= itemsBeforeDropPoint;
                }
                int selStart = dropIndex;
                for (int i = 0; i < sel.length; ++i) {
                    dModel.add(dropIndex++, sel[i]);
                }
                sModel.addSelectionInterval(selStart, selStart + numSelected - 1);
                list.ensureIndexIsVisible(selStart);
                list.ensureIndexIsVisible(selStart + numSelected - 1);
            }
        }
    }

    private boolean _isSelectionMobile(int controlType) {
        block11: {
            int numSelected;
            JList list = this.getList();
            ListModel model = list.getModel();
            if (model.getSize() == 0) {
                return false;
            }
            int[] selectedIndices = list.getSelectedIndices();
            int n = numSelected = selectedIndices == null ? 0 : selectedIndices.length;
            if (numSelected == 0) break block11;
            if (controlType == 1) {
                int firstIndex = selectedIndices[0];
                for (int i = 1; i < numSelected; ++i) {
                    if (selectedIndices[i] >= firstIndex) continue;
                    firstIndex = selectedIndices[i];
                }
                return firstIndex != 0;
            }
            if (controlType == 2) {
                int lastIndex = selectedIndices[0];
                for (int i = 1; i < numSelected; ++i) {
                    if (selectedIndices[i] <= lastIndex) continue;
                    lastIndex = selectedIndices[i];
                }
                return lastIndex != model.getSize() - 1;
            }
            Sort.qSort((int[])selectedIndices, (int)numSelected, (boolean)true);
            if (controlType == 3) {
                if (selectedIndices[0] != 0) {
                    return true;
                }
                for (int i = 1; i < numSelected; ++i) {
                    if (selectedIndices[i] == i) continue;
                    return true;
                }
            } else {
                if (selectedIndices[numSelected - 1] != model.getSize() - 1) {
                    return true;
                }
                for (int i = numSelected - 2; i >= 0; --i) {
                    if (selectedIndices[i] == selectedIndices[i + 1] - 1) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

