/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.scrolling;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.button.ContinuousButtonModel;
import oracle.bali.ewt.elaf.EWTArrowBoxUI;
import oracle.bali.ewt.util.ImmInsets;

public class ArrowBox
extends LWComponent
implements Accessible {
    public static final int DISPLAY_AS_NEEDED = 0;
    public static final int DISPLAY_ALWAYS = 1;
    private static final ImmInsets _sBUTTON_INSETS = new ImmInsets(2, 2, 0, 0);
    private JViewport _viewPort;
    private Component _view;
    private Scrollable _scrollable;
    private int _orientation = -1;
    private int _displayPolicy = -1;
    private boolean _together;
    private AbstractButton _upButton;
    private AbstractButton _downButton;
    private ChangeListener _viewListener;
    private static final String _UP_NAME = "Up_Button";
    private static final String _DOWN_NAME = "Down_Button";

    public ArrowBox() {
        this(null);
    }

    public ArrowBox(Component view) {
        this(view, 0, 0, true);
    }

    public ArrowBox(Component view, int orientation, int policy, boolean arrowsTogether) {
        this.setLayout(null);
        this._viewListener = new ViewListen();
        this.setOrientation(orientation);
        this.setViewportView(view);
        this.setDisplayPolicy(policy);
        this.setArrowsTogether(arrowsTogether);
        this.updateUI();
    }

    public int getDisplayPolicy() {
        return this._displayPolicy;
    }

    public void setDisplayPolicy(int policy) {
        if (policy != 0 && policy != 1) {
            throw new IllegalArgumentException();
        }
        this._displayPolicy = policy;
        this._setButtonsVisible();
    }

    public int getOrientation() {
        return this._orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException();
        }
        if (this._orientation != orientation) {
            this._orientation = orientation;
            this._setButtonContents();
            this.revalidate();
            this.repaint();
        }
    }

    public void setViewportView(Component view) {
        if (view == this._view) {
            return;
        }
        this.getViewport().setView(null);
        this.getViewport().setView(view);
        this._view = view;
        this._scrollable = this._view instanceof Scrollable ? (Scrollable)((Object)view) : null;
        this.revalidate();
        this.repaint();
    }

    public Component getViewportView() {
        return this._view;
    }

    public JViewport getViewport() {
        if (this._viewPort == null) {
            this._viewPort = this.createViewport();
            this._viewPort.addChangeListener(this._viewListener);
            this.add(this._viewPort);
        }
        return this._viewPort;
    }

    public void setViewport(JViewport viewport) {
        if (viewport == this._viewPort) {
            return;
        }
        if (this._viewPort != null) {
            this.remove(this._viewPort);
            this._viewPort.setView(null);
            this._viewPort.removeChangeListener(this._viewListener);
        }
        this._viewPort = null;
        if (viewport == null) {
            viewport = this.createViewport();
        }
        this._viewPort = viewport;
        if (this._viewPort != null) {
            this._viewPort.setView(this._view);
            this._viewPort.addChangeListener(this._viewListener);
            this.add(this._viewPort);
        }
        this.revalidate();
        this.repaint();
    }

    public boolean getArrowsTogether() {
        return this._together;
    }

    public void setArrowsTogether(boolean together) {
        if (this._together != together) {
            this._together = together;
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleArrowBox();
        }
        return this.accessibleContext;
    }

    @Override
    public void updateUI() {
        this.setUI((EWTArrowBoxUI)UIManager.getUI(this));
        this._setButtonContents();
    }

    @Override
    public String getUIClassID() {
        return "EWTArrowBoxUI";
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = this._view == null ? new Dimension() : this._view.getPreferredSize();
        return this._preferredSize(d);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension d = this._view == null ? new Dimension() : this._view.getMinimumSize();
        return this._preferredSize(d);
    }

    @Override
    public void doLayout() {
        Dimension size = this.getSize();
        ImmInsets borderInsets = this.getBorderInsets();
        size.width -= borderInsets.left + borderInsets.right;
        size.height -= borderInsets.top + borderInsets.bottom;
        this._setButtonsVisible();
        boolean buttonsVisible = this._upButton.isVisible();
        if (!buttonsVisible) {
            this._viewPort.setBounds(borderInsets.left, borderInsets.top, size.width, size.height);
        } else {
            int downX;
            int upX;
            int viewX;
            int viewY;
            int upY;
            int downY;
            int viewHeight;
            int viewWidth;
            int buttonHeight;
            int buttonWidth;
            ImmInsets insets = _sBUTTON_INSETS;
            Dimension buttonSize = this._upButton.getPreferredSize();
            if (this.getOrientation() == 0) {
                buttonWidth = buttonSize.width;
                buttonHeight = size.height;
                viewWidth = size.width - 2 * buttonWidth - insets.left;
                viewHeight = size.height;
                upY = downY = borderInsets.top;
                viewY = borderInsets.top;
                if (this.getArrowsTogether()) {
                    viewX = borderInsets.left;
                    if (this.getActualReadingDirection() == 1) {
                        upX = viewX + viewWidth + insets.left;
                        downX = upX + buttonWidth + insets.right;
                    } else {
                        downX = viewWidth + insets.left;
                        upX = downX + buttonWidth + insets.right;
                    }
                } else if (this.getActualReadingDirection() == 1) {
                    upX = borderInsets.left;
                    viewX = upX + buttonWidth + insets.right;
                    downX = viewX + viewWidth + insets.left;
                } else {
                    downX = insets.left;
                    viewX = downX + buttonWidth + insets.right;
                    upX = size.width - insets.left - buttonWidth;
                }
            } else {
                buttonWidth = size.width;
                buttonHeight = buttonSize.height;
                viewWidth = size.width;
                viewHeight = size.height - 2 * buttonHeight - insets.top;
                upX = downX = borderInsets.left;
                viewX = borderInsets.left;
                if (this.getArrowsTogether()) {
                    viewY = borderInsets.top;
                    upY = viewY + viewHeight + insets.top;
                    downY = upY + buttonHeight + insets.bottom;
                } else {
                    upY = borderInsets.top;
                    viewY = upY + buttonHeight + insets.bottom;
                    downY = viewY + viewHeight + insets.top;
                }
            }
            this._upButton.setBounds(upX, upY, buttonWidth, buttonHeight);
            this._downButton.setBounds(downX, downY, buttonWidth, buttonHeight);
            this._viewPort.setBounds(viewX, viewY, viewWidth, viewHeight);
        }
        if (!this._view.isValid()) {
            this._view.doLayout();
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this._configureButtons();
    }

    protected JViewport createViewport() {
        return new JViewport();
    }

    private void _configureButtons() {
        if (!this._upButton.isVisible() && !this._downButton.isVisible()) {
            this._upButton.setEnabled(true);
            this._downButton.setEnabled(true);
            return;
        }
        JViewport view = this.getViewport();
        Rectangle r = view.getViewRect();
        Dimension size = view.getView().getPreferredSize();
        boolean enable = this.isEnabled();
        if (this.getOrientation() == 0) {
            this._upButton.setEnabled(r.x != 0 && enable);
            this._downButton.setEnabled(r.x + r.width < size.width && enable);
        } else {
            this._upButton.setEnabled(r.y != 0 && enable);
            this._downButton.setEnabled(r.y + r.height < size.height && enable);
        }
        this.repaint();
    }

    private void _setButtonsVisible() {
        boolean visible;
        if (this._upButton == null) {
            return;
        }
        if (this.getDisplayPolicy() == 1) {
            visible = true;
        } else {
            Dimension size;
            Component view = this.getViewportView();
            Dimension dimension = size = view == null ? new Dimension() : view.getPreferredSize();
            boolean bl = this.getOrientation() == 0 ? size.width >= this.getWidth() : (visible = size.height >= this.getHeight());
        }
        if (visible != this._upButton.isVisible()) {
            if (!visible) {
                this._upButton.setEnabled(true);
                this._downButton.setEnabled(true);
            }
            this._upButton.setVisible(visible);
            this._downButton.setVisible(visible);
            this.revalidate();
            this.repaint();
        }
    }

    private Dimension _preferredSize(Dimension viewSize) {
        Dimension d = new Dimension();
        Dimension buttonSize = this._upButton.getPreferredSize();
        ImmInsets insets = _sBUTTON_INSETS;
        buttonSize.width += insets.left + insets.right;
        buttonSize.height += insets.top + insets.bottom;
        if (this.getOrientation() == 0) {
            d.width = 2 * buttonSize.width + viewSize.width;
            d.height = Math.max(buttonSize.height, viewSize.height);
        } else {
            d.width = Math.max(buttonSize.width, viewSize.width);
            d.height = 2 * buttonSize.height + viewSize.height;
        }
        ImmInsets borderInsets = this.getBorderInsets();
        d.width += borderInsets.left + borderInsets.right;
        d.height += borderInsets.top + borderInsets.bottom;
        return d;
    }

    private EWTArrowBoxUI _getEWTArrowBoxUI() {
        return (EWTArrowBoxUI)this.ui;
    }

    private void _setButtonContents() {
        if (this._getEWTArrowBoxUI() == null) {
            return;
        }
        if (this._upButton != null) {
            this.remove(this._upButton);
        }
        if (this._downButton != null) {
            this.remove(this._downButton);
        }
        this._upButton = this._getEWTArrowBoxUI().getDecrementButton(this);
        this._upButton.setName(_UP_NAME);
        this._upButton.setModel(new Pulser(this._upButton));
        this._downButton = this._getEWTArrowBoxUI().getIncrementButton(this);
        this._downButton.setName(_DOWN_NAME);
        this._downButton.setModel(new Pulser(this._downButton));
        this.add(this._upButton);
        this.add(this._downButton);
    }

    private void _scrollView(boolean up) {
        JViewport viewport = this.getViewport();
        Component view = viewport.getView();
        Dimension size = view.getPreferredSize();
        Rectangle r = viewport.getViewRect();
        if (this.getOrientation() == 0) {
            if (up) {
                r.x = this._scrollable == null ? --r.x : (r.x -= this._scrollable.getScrollableUnitIncrement(r, 0, -1));
                if (r.x < 0) {
                    r.x = 0;
                }
            } else {
                r.x = this._scrollable == null ? ++r.x : (r.x += this._scrollable.getScrollableUnitIncrement(r, 0, 1));
                if (r.x + r.width > size.width) {
                    r.x = size.width - r.width;
                }
            }
        } else if (up) {
            r.y = this._scrollable == null ? --r.y : (r.y -= this._scrollable.getScrollableUnitIncrement(r, 1, -1));
            if (r.y < 0) {
                r.y = 0;
            }
        } else {
            r.y = this._scrollable == null ? ++r.y : (r.y += this._scrollable.getScrollableUnitIncrement(r, 1, 1));
            if (r.y + r.height > size.height) {
                r.y = size.height - r.height;
            }
        }
        viewport.setViewPosition(new Point(r.x, r.y));
    }

    private class AccessibleArrowBox
    extends JComponent.AccessibleJComponent {
        private AccessibleArrowBox() {
            super(ArrowBox.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_PANE;
        }
    }

    private class ViewListen
    implements ChangeListener {
        private ViewListen() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ArrowBox.this._configureButtons();
        }
    }

    private class Pulser
    extends ContinuousButtonModel {
        protected Pulser(AbstractButton button) {
            super(button);
        }

        @Override
        protected void processPulse() {
            boolean up = this.getButton() == ArrowBox.this._upButton;
            ArrowBox.this._scrollView(up);
        }
    }
}

