/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyVetoException;
import java.io.IOException;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.pivot.PivotGrid;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.pivot.PivotTransfer;
import oracle.bali.share.datatransfer.TransferUtils;

@Deprecated
class PivotGridDropAdapter
implements DropTargetListener {
    private PivotGrid _pivotGrid;
    private PivotHeader _pivotHeader;
    private Component _corner;
    private DropTarget _pivotGridDropTarget;
    private DropTarget _columnHeaderDropTarget;
    private DropTarget _rowHeaderDropTarget;
    private DropTarget _pivotGridGridDropTarget;
    private DropTarget _cornerDropTarget;

    public PivotGridDropAdapter(PivotGrid pivotGrid) {
        this._pivotGrid = pivotGrid;
        this._corner = this._pivotGrid.getCornerComponent("UPPER_LEFT_CORNER");
        this._pivotGridDropTarget = new DropTarget(this._pivotGrid, this);
        Header header = this._pivotGrid.getColumnHeader();
        if (header != null) {
            this._columnHeaderDropTarget = new DropTarget(header, this);
        }
        if ((header = this._pivotGrid.getRowHeader()) != null) {
            this._rowHeaderDropTarget = new DropTarget(header, this);
        }
        Grid grid = this._pivotGrid.getGrid();
        this._pivotGridGridDropTarget = new DropTarget(grid, this);
        this._cornerDropTarget = new DropTarget(this._corner, this);
    }

    public void dispose() {
        this._pivotGridDropTarget.setComponent(null);
        this._pivotGridDropTarget.removeDropTargetListener(this);
        this._pivotGridDropTarget = null;
        this._columnHeaderDropTarget.setComponent(null);
        this._columnHeaderDropTarget.removeDropTargetListener(this);
        this._columnHeaderDropTarget = null;
        this._rowHeaderDropTarget.setComponent(null);
        this._rowHeaderDropTarget.removeDropTargetListener(this);
        this._rowHeaderDropTarget = null;
        this._pivotGridGridDropTarget.setComponent(null);
        this._pivotGridGridDropTarget.removeDropTargetListener(this);
        this._pivotGridGridDropTarget = null;
        this._cornerDropTarget.setComponent(null);
        this._cornerDropTarget.removeDropTargetListener(this);
        this._cornerDropTarget = null;
        this._pivotGrid = null;
        this._pivotHeader = null;
        this._corner = null;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (!this._acceptDrag(e)) {
            e.rejectDrag();
            return;
        }
        this._updateFeedback(e.getDropTargetContext().getComponent(), e.getLocation());
    }

    public void dragScroll(DropTargetDragEvent e) {
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this._updatePivotHeader(null);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        e.acceptDrop(1);
        this._updatePivotHeader(null);
        Transferable transfer = e.getTransferable();
        Object data = null;
        try {
            data = transfer.getTransferData(PivotTransfer.DATA_FLAVOR);
        }
        catch (IOException ioException) {
            data = null;
        }
        catch (UnsupportedFlavorException ufException) {
            data = null;
        }
        boolean success = false;
        if (data != null && data instanceof PivotTransfer) {
            PivotTransfer pivotTransfer = (PivotTransfer)data;
            Object source = pivotTransfer.getSource();
            int sourceIndex = pivotTransfer.getIndex();
            PivotHeader destination = this._getPivotHeader(e.getDropTargetContext().getComponent(), e.getLocation());
            int destinationIndex = this._getIndex(destination);
            PivotTable pivot = this._pivotGrid.getPivotTable();
            boolean fireEvent = true;
            if (source == destination) {
                if (sourceIndex < destinationIndex) {
                    --destinationIndex;
                }
                if (sourceIndex == destinationIndex) {
                    fireEvent = false;
                }
            }
            if (fireEvent) {
                try {
                    pivot.deselectAll();
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                pivot.firePivotEvent(source, sourceIndex, destination, destinationIndex);
            }
            success = true;
        }
        e.dropComplete(success);
    }

    private boolean _acceptDrag(DropTargetDragEvent dtde) {
        if (!this._pivotGrid.isEnabled()) {
            return false;
        }
        DataFlavor[] flavors = dtde.getCurrentDataFlavors();
        if (flavors == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!TransferUtils.supportsDataFlavor((DataFlavor)flavors[i], (DataFlavor)PivotTransfer.DATA_FLAVOR)) continue;
            return true;
        }
        return false;
    }

    private PivotHeader _getPivotHeader(Component c, Point p) {
        PivotHeader header = null;
        if (c == this._pivotGrid || c == this._pivotGrid.getGrid() || c == this._corner) {
            header = p.x >= p.y ? this._getHorizontalHeader() : this._getVerticalHeader();
        } else if (c == this._pivotGrid.getColumnHeader()) {
            header = this._getHorizontalHeader();
        } else if (c == this._pivotGrid.getRowHeader()) {
            header = this._getVerticalHeader();
        }
        return header;
    }

    private void _updateFeedback(Component c, Point p) {
        PivotHeader header = this._getPivotHeader(c, p);
        this._updatePivotHeader(header);
    }

    private void _updatePivotHeader(PivotHeader header) {
        if (this._pivotHeader != header && this._pivotHeader != null) {
            this._pivotHeader.setDropLocation(-1, false);
        }
        this._pivotHeader = header;
        if (this._pivotHeader != null) {
            int index = this._getIndex(header);
            this._pivotHeader.setDropLocation(index, false);
        }
    }

    private int _getIndex(PivotHeader header) {
        boolean h = header.getOrientation() == 0;
        TwoDModel ds = header.getModel();
        return h ? ds.getRowCount() : ds.getColumnCount();
    }

    private PivotHeader _getHorizontalHeader() {
        return this._pivotGrid.getPivotTable().getColumnPivotHeader();
    }

    private PivotHeader _getVerticalHeader() {
        return this._pivotGrid.getPivotTable().getRowPivotHeader();
    }
}

