/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.bigCell.AbstractBigCell;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.pivot.AbstractPivotHeaderCell;
import oracle.bali.ewt.pivot.PivotHeader;

class LevelHighlighter
extends MouseAdapter {
    private PivotHeader _header;

    public LevelHighlighter(PivotHeader header) {
        this._header = header;
        this._header.getGrid().addMouseListener(this);
    }

    public void dispose() {
        this._header.getGrid().removeMouseListener(this);
        this._header = null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isConsumed() || !this._header.isEnabled()) {
            return;
        }
        boolean left = SwingUtilities.isLeftMouseButton(e);
        if (!left) {
            return;
        }
        Grid grid = this._header.getGrid();
        Point canvasPoint = grid.convertOuterToCanvas(e.getX(), e.getY());
        int column = grid.getColumnAt(canvasPoint.x);
        int row = grid.getRowAt(canvasPoint.y);
        if (column != -1 && row != -1) {
            AbstractBigCell cell = AbstractBigCell.getBigCell(grid, column, row);
            if (cell != null) {
                column = cell.getColumn();
                row = cell.getRow();
                if (cell instanceof AbstractPivotHeaderCell) {
                    AbstractPivotHeaderCell pivotCell = (AbstractPivotHeaderCell)cell;
                    column += pivotCell.getIndent();
                }
            }
            int item = -1;
            if (this._header.getOrientation() == 0) {
                item = row;
                Header header = this._header.getRowHeader();
            } else {
                item = column;
                Header header = this._header.getColumnHeader();
            }
            this._header.setHighlightItem(item);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this._header.setHighlightItem(-1);
    }
}

