/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.JComponent;
import oracle.bali.ewt.pivot.PageItem;
import oracle.bali.ewt.pivot.PagingComponent;
import oracle.bali.ewt.pivot.PivotTransfer;
import oracle.bali.share.datatransfer.TransferUtils;

class JDKPagingComponentDragDropAdapter
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private static final String _DRAG_GESTURE_RECOGNIZER = "oracle.bali.ewt.pivot.PagingComponent.DRAG_GESTURE_RECOGNIZER";
    private PageItem _dragComponent;
    private int _dragIndex = -1;
    private int _dropIndex = -1;
    private boolean _swapping;
    private PagingComponent _pagingComp;
    private DropTarget _dropTarget;

    public JDKPagingComponentDragDropAdapter(PagingComponent comp) {
        this._pagingComp = comp;
        this._dropTarget = new DropTarget(comp, this);
    }

    public void dispose() {
        if (this._dropTarget == null) {
            return;
        }
        this._dropTarget.setComponent(null);
        this._dropTarget.removeDropTargetListener(this);
        this._dropTarget = null;
        this._dragComponent = null;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        Point origin = e.getDragOrigin();
        Component c = e.getComponent();
        PageItem item = this._getPageItem(c);
        if (item != null && item.isDragEnabled()) {
            int index = this._getIndex(item);
            Image dragImage = this._pagingComp.getDragImage(index);
            this._dragComponent = item;
            this._dragIndex = index;
            this._dragComponent.setDragging(true);
            Transferable t = PivotTransfer.createTransferable(this._pagingComp, index);
            e.startDrag(null, dragImage, new Point(5, -origin.y), t, this);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (this._dragComponent != null) {
            int count;
            if (this._dragComponent.isShowing()) {
                this._dragComponent.requestFocus();
            } else if (this._dragIndex != -1 && (count = this._pagingComp.getComponentCount()) != 0) {
                int index = this._dragIndex - 1;
                if (index < 0) {
                    index = 0;
                }
                if (index >= count) {
                    index = count - 1;
                }
                this._pagingComp.getComponent(index).requestFocus();
            }
            this._dragComponent.setDragging(false);
            this._dragComponent = null;
            this._dragIndex = -1;
        }
        this._pagingComp.repaint();
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dsde) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (!this.acceptDrag(dtde)) {
            dtde.rejectDrag();
            return;
        }
        Component c = dtde.getDropTargetContext().getComponent();
        Point p = dtde.getLocation();
        if (c != this._pagingComp && c != this._pagingComp.getParent()) {
            c = this._convertPointAndFindPageItem(c, p);
        }
        boolean swap = this._pagingComp.isSwap(c, p);
        int index = this._pagingComp.getIndex(c, p, swap);
        this.__setDropLocation(index, swap);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (!this.acceptDrag(dtde)) {
            dtde.rejectDrag();
            return;
        }
        Component c = dtde.getDropTargetContext().getComponent();
        Point p = dtde.getLocation();
        if (c != this._pagingComp && c != this._pagingComp.getParent()) {
            c = this._convertPointAndFindPageItem(c, p);
        }
        boolean swap = this._pagingComp.isSwap(c, p);
        int index = this._pagingComp.getIndex(c, p, swap);
        this.__setDropLocation(index, swap);
    }

    @Override
    public void dragExit(DropTargetEvent dtde) {
        this.__setDropLocation(-1, false);
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        if (this._dragComponent != null && this._dropIndex != -1 && this._getIndex(this._dragComponent) == this._dropIndex) {
            e.rejectDrop();
            this.__setDropLocation(-1, false);
            this._pagingComp.repaint();
            return;
        }
        int index = this._dropIndex;
        boolean swap = this._swapping;
        this.__setDropLocation(-1, false);
        this._pagingComp.repaint();
        Transferable transfer = e.getTransferable();
        Object data = null;
        try {
            data = transfer.getTransferData(PivotTransfer.DATA_FLAVOR);
        }
        catch (IOException ioException) {
            data = null;
        }
        catch (UnsupportedFlavorException ufException) {
            data = null;
        }
        boolean success = false;
        if (data != null && data instanceof PivotTransfer) {
            PivotTransfer pivotTransfer = (PivotTransfer)data;
            Object source = pivotTransfer.getSource();
            int sourceIndex = pivotTransfer.getIndex();
            if (!swap) {
                if ((source == this._pagingComp || source == this._pagingComp.getParent()) && sourceIndex < index) {
                    --index;
                }
                this._pagingComp.firePivotEvent(source, sourceIndex, this._pagingComp, index);
            } else {
                this._pagingComp.fireSwapEvent(source, sourceIndex, this._pagingComp, index);
            }
            success = true;
        }
        e.dropComplete(success);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public PageItem getDragComponent() {
        return this._dragComponent;
    }

    public int getDropIndex() {
        return this._dropIndex;
    }

    public boolean isSwapping() {
        return this._swapping;
    }

    boolean acceptDrag(DropTargetDragEvent e) {
        if (!this._pagingComp.isEnabled()) {
            return false;
        }
        DataFlavor[] flavors = e.getCurrentDataFlavors();
        if (flavors == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!TransferUtils.supportsDataFlavor((DataFlavor)flavors[i], (DataFlavor)PivotTransfer.DATA_FLAVOR)) continue;
            return true;
        }
        return false;
    }

    void __setDropLocation(int index, boolean swapping) {
        if (this._dropIndex != index || swapping != this._swapping) {
            PageItem item;
            if (this._dropIndex != -1 && this._dropIndex < this._pagingComp.getComponentCount() && (item = this._pagingComp.getItem(this._dropIndex)) != null) {
                item.setSwapping(false);
            }
            this._dropIndex = index;
            this._swapping = swapping;
            if (this._dropIndex != -1 && this._dropIndex < this._pagingComp.getComponentCount() && (item = this._pagingComp.getItem(this._dropIndex)) != null) {
                item.setSwapping(swapping);
            }
            this._pagingComp.repaint();
        }
    }

    Object __createDropTarget(Component c) {
        return new DropTarget(c, this);
    }

    void __addDropTarget(Component c) {
        DropTarget dummy = new DropTarget(c, this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            int count = cont.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this.__addDropTarget(cont.getComponent(i));
            }
        }
    }

    void __addDragListener(Component comp) {
        DragGestureRecognizer recognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(comp, 2, this);
        if (comp instanceof JComponent) {
            JComponent c = (JComponent)comp;
            c.putClientProperty(_DRAG_GESTURE_RECOGNIZER, recognizer);
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            int count = cont.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this.__addDragListener(cont.getComponent(i));
            }
        }
    }

    void __removeDragListener(Component comp) {
        if (comp instanceof JComponent) {
            JComponent c = (JComponent)comp;
            Object o = c.getClientProperty(_DRAG_GESTURE_RECOGNIZER);
            if (o instanceof DragGestureRecognizer) {
                DragGestureRecognizer r = (DragGestureRecognizer)o;
                r.setComponent(null);
                r.removeDragGestureListener(this);
            }
            c.putClientProperty(_DRAG_GESTURE_RECOGNIZER, null);
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            int count = cont.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this.__removeDragListener(cont.getComponent(i));
            }
        }
    }

    void __removeDropTarget(Component c) {
        if (c instanceof JComponent) {
            JComponent comp = (JComponent)c;
            DropTarget target = comp.getDropTarget();
            if (target != null) {
                target.setComponent(null);
                target.removeDropTargetListener(this);
            }
            comp.setDropTarget(null);
            int count = comp.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this.__removeDropTarget(comp.getComponent(i));
            }
        }
    }

    private PageItem _getPageItem(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof PageItem) {
            return (PageItem)c;
        }
        return this._getPageItem(c.getParent());
    }

    private int _getIndex(Component c) {
        int index = -1;
        int count = this._pagingComp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            if (this._pagingComp.getComponent(i) != c) continue;
            index = i;
            break;
        }
        return index;
    }

    private PageItem _convertPointAndFindPageItem(Component c, Point p) {
        if (c instanceof PageItem) {
            return (PageItem)c;
        }
        if (c == null) {
            return null;
        }
        Point temp = c.getLocation();
        p.x += temp.x;
        p.y += temp.y;
        return this._convertPointAndFindPageItem(c.getParent(), p);
    }
}

